package com.xdja.im.uikit.newui.holder.send;

import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.lib.share.model.WebPageInfo;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.newui.base.BaseSendHolder;
import com.xdja.im.uikit.view.CircleImageView;

/**
 * Created by wenqi on 2018/4/13.
 */

public class ViewSendWebHolder extends BaseSendHolder {

    private final static String TAG = "ViewSendWebItem";

    private TextView sendWebTitle;
    private TextView sendWebDes;
    private ImageView sendWebThumb;
    private CircleImageView ivHeader;

    public ViewSendWebHolder(View itemView) {
        super(itemView);
        sendWebTitle = (TextView) findViewById(R.id.web_title);
        sendWebDes = (TextView) findViewById(R.id.web_des);
        sendWebThumb = (ImageView) findViewById(R.id.web_thumb);
        mContentLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getPresenter().clickWebMessage(dataSource);
            }
        });
    }

    @Override
    public void bindData(int position, TalkMessageBean dataSource) {
        super.bindData(position, dataSource);
        WebPageInfo webPageInfo = dataSource.getWebPageInfo();
        if (webPageInfo != null){
            String webUri = webPageInfo.getWebUri();
            String description = webPageInfo.getDescription();
            String source = webPageInfo.getSource();
            String title = webPageInfo.getTitle();
            sendWebTitle.setText(title);
            sendWebDes.setText(description);
        }
    }
}
