package com.xdja.im.uikit.newui.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.RecyclerView;
import android.text.Editable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.xdja.im.common.database.dao.MeetInfoEntityDao;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.MeetInfo;
import com.xdja.im.lib.action.ChatActionView;
import com.xdja.im.lib.action.ChatInputView;
import com.xdja.im.lib.action.bean.OptionBean;
import com.xdja.im.lib.action.listener.IChatActionCallback;
import com.xdja.im.lib.action.listener.IChatActionItemClickListener;
import com.xdja.im.lib.filemanage.util.XToast;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.base.ImFragmentSuperView;
import com.xdja.im.uikit.newui.adapter.ChatDetailAdapter;
import com.xdja.im.uikit.newui.presenter.ChatDetailPresenter;
import com.xdja.im.uikit.newui.vu.ChatDetailVu;
import com.xdja.im.uikit.utils.FunctionUtils;
import com.xdja.im.uikit.utils.NetworkHelper;
import com.xdja.im.uikit.view.KeyboardLayout;

import java.util.List;

import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

/**
 * Created by wenqi on 2018/4/13.
 *
 */

public class ChatDetailView extends ImFragmentSuperView<ChatDetailPresenter> implements ChatDetailVu {

    private KeyboardLayout mRootLayout;

    private RelativeLayout mContentLayout;

    /**
     * 消息列表控件
     */
    private RecyclerView mRecyclerView;
    /**
     * 操作输入控件
     */
    private ChatInputView mChatInputView;

    /**
     * 消息操作面板
     */
    private ChatActionView mChatActionView;

    /**
     * 下拉刷新组件
     */
    private SwipeRefreshLayout swipeRefreshLayout;

    /**
     * 键盘
     */
    private InputMethodManager inputMethodManager;

    /**
     * 网络状态组件
     *
     * @return
     */
    private LinearLayout networkStateLineaLayout;
    /**
     * 网络状态显示组件
     *
     * @return
     */
    private TextView networkStateTv;


    private RelativeLayout im_uikit_meeting_tips_layout;

    private TextView im_uikit_meeting_tips_txt;

    /**
     * 目标项是否在最后一个可见项之后
     */
    private boolean mShouldScroll,isScrollView;
    /**
     * 记录目标项位置
     */
    private int mToPosition;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_chat_detail_layout;
    }

    @Override
    protected int getToolbarType() {
        return ToolbarDef.NAVIGATE_BACK;
    }

    @Override
    protected void injectView() {
        super.injectView();

        mRootLayout = (KeyboardLayout) findViewById(R.id.root_layout);
        mContentLayout = (RelativeLayout) findViewById(R.id.content_layout);
        mRecyclerView = (RecyclerView) findViewById(R.id.lv_message_list);
        mChatInputView = (ChatInputView) findViewById(R.id.layout_chat_operate);
        mChatActionView = (ChatActionView) findViewById(R.id.layout_chat_action);
        swipeRefreshLayout = (SwipeRefreshLayout) findViewById(R.id.swipe_container);
        networkStateLineaLayout = (LinearLayout) findViewById(R.id.network_state_view);
        networkStateTv = (TextView) findViewById(R.id.networkstate_tv);

        //根据静态注册的广播接收器中保存的当前网络状态是否可用的值，来确定View是否可见
        changeNetworkViewState(NetworkHelper.getHelper().getNetState());

        im_uikit_meeting_tips_layout = (RelativeLayout) findViewById(R.id.im_uikit_meeting_tips_layout);
        im_uikit_meeting_tips_txt = (TextView) findViewById(R.id.im_uikit_meeting_tips_txt);
        im_uikit_meeting_tips_layout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getPresenter().addMeeting();
            }
        });
    }

    @Override
    public void init(LayoutInflater inflater, ViewGroup container) {
        super.init(inflater, container);
        inputMethodManager = ((InputMethodManager) getActivity().getSystemService(Context.INPUT_METHOD_SERVICE));

        swipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener() {
            @Override
            public void onRefresh() {
                getPresenter().downRefreshList();
            }
        });
        registerInputCallback();

        mRootLayout.setActivity(getActivity());
        mChatActionView.setAcceptInput(mChatInputView.getInputEdt());

        initChatListListView();

        setNavigateCallback(new onNavigateCallback() {
            @Override
            public void onBackClick() {
                hideSoftInputView();
            }

            @Override
            public void onAddClick() {
                getPresenter().startSetting();
            }
        });
    }

    /**
     * 添加显示列表的监听事件
     */
    private void initChatListListView() {
        mRecyclerView.setOnTouchListener(new View.OnTouchListener() {
            @SuppressLint("ClickableViewAccessibility")
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == MotionEvent.ACTION_DOWN ) {
                    if (mChatActionView.isShown()) {
                        restoreActionState();
                        return true;
                    }
                    mRecyclerView.setFocusable(true);
                    displayInputKeyBoard(false);
                    return false;
                }
                return false;
            }
        });
        mRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener() {
            @Override
            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                if (mShouldScroll) {
                    mShouldScroll = false;
                    smoothMoveToPosition(mToPosition);
                }
            }

            @Override
            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (isScrollView){
                    isScrollView = false;
                    int lastItem = mRecyclerView.getAdapter().getItemCount()-1;
                    smoothMoveToPosition(lastItem);
                }
            }
        });
    }

    @Override
    public void smoothMoveToPosition(int index) {
        //获取当前recycleView屏幕可见的第一项和最后一项的Position
        int firstItem = getPresenter().getLinearLayoutManager().findFirstVisibleItemPosition();
        int lastItem = getPresenter().getLinearLayoutManager().findLastVisibleItemPosition();
        //然后区分情况
        if (index <= firstItem) {
            //当要置顶的项在当前显示的第一个项的前面时
            mRecyclerView.smoothScrollToPosition(index);
        } else if (index <= lastItem) {
            //当要置顶的项已经在屏幕上显示时，计算它离屏幕原点的距离
            int movePosition = index - firstItem;
            if (movePosition >= 0 && movePosition < mRecyclerView.getChildCount()) {
                int top = mRecyclerView.getChildAt(movePosition).getTop();
                mRecyclerView.smoothScrollBy(0, top);
            }
        } else {
            //当要置顶的项在当前显示的最后一项的后面时
            mRecyclerView.smoothScrollToPosition(index);
            //记录当前需要在RecyclerView滚动监听里面继续第二次滚动
            mToPosition = index;
            mShouldScroll = true;
        }
    }

    @Override
    public void setToolBarVisibility(int visibility) {
        supportActionBar(visibility == View.VISIBLE);
    }

    @Override
    public void setToolBarAddVisibility(int visibility) {
        setToolBarAddVisible(visibility == View.VISIBLE);
    }

    @Override
    public void setTitle(String title) {
        if (isSupportActionBar()) {
            setToolBarTitle(title);
        }
    }

    @Override
    public void setAdapter(ChatDetailAdapter adapter) {
        mRecyclerView.setLayoutManager(getPresenter().getLinearLayoutManager());
        mRecyclerView.setAdapter(adapter);
    }

    @Override
    public void setOptions(List<OptionBean> options) {
        if (mChatActionView != null) {
            mChatActionView.setOptionsData(options);
        }
    }

    @Override
    public RecyclerView getRecyclerView() {
        return mRecyclerView;
    }

    @Override
    public String getInputContent() {
        return mChatInputView.getInputText();
    }

    @Override
    public void setInputContent(String content) {
        if (!TextUtils.isEmpty(content)) {
            mChatInputView.setIsDraft(true);
        }
        mChatInputView.setInputText(content);
    }

    @Override
    public boolean isRefreshing() {
        return swipeRefreshLayout.isRefreshing();
    }

    @Override
    public void stopRefresh() {
        swipeRefreshLayout.setRefreshing(false);
    }

    @Override
    public void setListSelection(int selection) {
        //getPresenter().getLinearLayoutManager().scrollToPositionWithOffset(selection, 0);
        //getPresenter().getLinearLayoutManager().setStackFromEnd(true);
        smoothMoveToPosition(selection);
    }

    /**
     * 重置action面板状态
     */
    @Override
    public void restoreActionState() {
        mChatActionView.setVisibility(View.GONE);
        mChatInputView.setShanState(false);
        mChatInputView.setMoreState(false);
//        if (mRecyclerView.getTranscriptMode() == AbsListView.TRANSCRIPT_MODE_ALWAYS_SCROLL) {
//            mRecyclerView.setTranscriptMode(AbsListView.TRANSCRIPT_MODE_NORMAL);
//        }
    }

    @Override
    public void changeViewSate(int state) {
        changeNetworkViewState(state);
        if (!NetworkHelper.getHelper().isFirstNotice()
                && FunctionUtils.isAppOnForeground(getActivity())) {
            if (state == NetworkHelper.NET_DISABLED) {
                Toast.makeText(getActivity(), "Network unavailable", Toast.LENGTH_LONG).show();
            } else if (state == NetworkHelper.NO_SERVER) {
                Toast.makeText(getActivity(), "Unable to access the server", Toast.LENGTH_LONG).show();
            }
        }
    }

    @Override
    public void setMeetState(boolean isShow, int talkType) {
        if (isShow && talkType == ConstDef.CHAT_TYPE_P2G) {
            im_uikit_meeting_tips_layout.setVisibility(View.VISIBLE);
        } else {
            im_uikit_meeting_tips_layout.setVisibility(View.GONE);
        }
    }

    @Override
    public void setChatMeet(String talkFlag) {
        Observable.just(talkFlag)
                .subscribeOn(Schedulers.newThread())
                .map(new Func1<String, MeetInfo>() {
                    @Override
                    public MeetInfo call(String s) {
                        MeetInfo meetInfo = MeetInfoEntityDao.getInstance().get(s);
                        return meetInfo;
                    }
                })
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MeetInfo>() {
                    @Override
                    public void onCompleted() {
                    }

                    @Override
                    public void onError(Throwable e) {
                        e.printStackTrace();
                        im_uikit_meeting_tips_layout.setVisibility(View.GONE);
                    }

                    @Override
                    public void onNext(MeetInfo meetInfo) {
                        if (meetInfo != null) {
                            if (meetInfo.getIsShow() == 1 && meetInfo.getTaklFlag().equals(getPresenter().getTalkFlag())) {
                                im_uikit_meeting_tips_layout.setVisibility(View.VISIBLE);
                            } else {
                                im_uikit_meeting_tips_layout.setVisibility(View.GONE);
                            }
                            if (!TextUtils.isEmpty(meetInfo.getTips()))
                                im_uikit_meeting_tips_txt.setText(meetInfo.getTips());
                        } else {
                            im_uikit_meeting_tips_layout.setVisibility(View.GONE);
                        }
                    }
                });
    }

    @Override
    public void setChatMeetTips(String tips) {
        if (!TextUtils.isEmpty(tips) && im_uikit_meeting_tips_txt != null) {
            im_uikit_meeting_tips_txt.setText(tips);
        }
    }

    @Override
    public void setTalkType(int talkType) {
        if (mToolbarAdd != null) {
            if (talkType == ConstDef.CHAT_TYPE_P2P) {
                mToolbarAdd.setImageResource(R.mipmap.im_uikit_ic_toolbar_add);
                mChatInputView.setChatType(talkType);
            } else if (talkType == ConstDef.CHAT_TYPE_P2G) {
                mToolbarAdd.setImageResource(R.mipmap.im_uikit_ic_toolbar_add_p2g);
                mChatInputView.setChatType(talkType);
            }
        }
    }

    @Override
    public void setGroupId(String groupId) {
        if(!TextUtils.isEmpty(groupId)) {
            mChatInputView.setGroupId(groupId);
        }
    }

    @Override
    public void setAccount(String account) {
        if(!TextUtils.isEmpty(account)) {
            mChatInputView.setAccount(account);
        }
    }

    @Override
    public void showAtActionView() {
        if (!mChatActionView.isActionViewVisible())
            showActionView();
        if (!inputMethodManager.isActive())
            displayInputKeyBoard(true);
    }

    @Override
    public void setAtText(String s, int type) {
        if (mChatInputView.getInputEdt().length() + s.length() > 2048) {
            new XToast(getActivity()).display(R.string.im_uikit_input_length_warnning);
            return;
        }
        if (type == ConstDef.CLICK_IMAGE) {
            showInputBoardAndHideAction();
            if (mChatInputView.getInputEdt().getText().toString().contains(s)) return;
        }
        int index = mChatInputView.getInputEdt().getSelectionStart();
        Editable editable = mChatInputView.getInputEdt().getEditableText();
        if (index < 0 || index >= editable.length()) {
            editable.append(s);
        } else {
            editable.insert(index,s);
        }
    }

    /**
     * AT长按头像，输入框输入，面板与软键盘交互
     * @param
     */
    private void showInputBoardAndHideAction() {
        mChatActionView.setVisibility(View.GONE);
       // mRecyclerView.setTranscriptMode(AbsListView.TRANSCRIPT_MODE_NORMAL);
        setEditTextFocus(true);
    }



    /**
     * 消息输入回调
     * 尽量的少操作ChatInputView自身的控件，重点进行逻辑处理
     */
    private void registerInputCallback() {
        mChatInputView.registerActionViewCallBack(new IChatActionCallback() {
            @Override
            public void onVirtualViewCallBack() {

            }

            @Override
            public void onMoreCheckChanged() {

                if (mChatActionView.isActionViewVisible()) {
                    hideActionView(false);
                    restoreActionState();
                } else {

                    showActionView();
                    mChatInputView.setMoreState(true);
                    mChatActionView.setActionViewVisible(true);
                }
            }

            @Override
            public void onShanCheckChanged() {

                //闪信
                //getPresenter().setLimitFlagFromView(isChecked);
                //mChatActionView.updateGrid(isChecked);

                //表情
                if (mChatActionView.isEmojiVisible()) {
                    hideActionView(true);
                    restoreActionState();

                    setEditTextFocus(true);
                } else {
                    showActionView();
                    mChatInputView.setShanState(true);
                    mChatActionView.setEmojiVisible(true);
                }
            }

            @Override
            public void onInputCheckChanged(boolean isChecked) {

                //isChecked false 语音  true 文字
                if (isChecked) {
                    if (mChatActionView.isShown()) {
                        hideActionView(true);
                    }
                } else {
                    if (mRootLayout.isSoftInputShown()) {
                        hideSoftInputView();
                    }
                    if (mChatActionView.isShown()) {
                        hideActionView(false);
                    }
                    restoreActionState();
                }
            }

            @Override
            public void onSendTextCallBack() {
                String content = mChatInputView.getInputText();
                if (TextUtils.isEmpty(content.trim())) {
                    CommonTool.showToast(R.string.im_uikit_content_cannot_null);
                    return;
                }

                if (getPresenter().sendTextMessage(content)) {
                    mChatInputView.setInputText("");
                }
            }

            @Override
            public void onInputEareTouchCallBack() {

                if (mChatActionView.isShown()) {
                    restoreActionState();
                }
                isScrollView = true;
//                if (mRecyclerView.getTranscriptMode() != AbsListView.TRANSCRIPT_MODE_ALWAYS_SCROLL) {
//                    mRecyclerView.setTranscriptMode(AbsListView.TRANSCRIPT_MODE_ALWAYS_SCROLL);
//                }
            }

            @Override
            public void onRecorderFinish(int seconds, String filePath) {
                getPresenter().sendVoiceMessage(filePath, seconds);
            }
        });

        mChatActionView.setChatActionItemClickListener(new IChatActionItemClickListener() {
            @Override
            public void onItemClick(int position, OptionBean optionBean) {
                // TODO: 2017/7/12
                if (optionBean.getId() == 5 || optionBean.getId() == 6) {
                    getPresenter().startVoice(position, optionBean);
                } else if (optionBean.getId() == 8) {
                    getPresenter().startLocation(position, optionBean);
                } else if (optionBean.getId() == 7) {
                    getPresenter().startCallback(position, optionBean);
                } else {
                    getPresenter().startToOptionView(position, optionBean);
                }
            }
        });
    }

    /**
     * 显示控制面板
     */
    public void showActionView() {

        if (mRootLayout.isSoftInputShown()) {
            lockContentViewHeight();
            hideSoftInputView();
            restoreActionState();
            unlockContentViewHeightDelayed();
        }

//        if (mRecyclerView.getTranscriptMode() != AbsListView.TRANSCRIPT_MODE_ALWAYS_SCROLL) {
//            mRecyclerView.setTranscriptMode(AbsListView.TRANSCRIPT_MODE_ALWAYS_SCROLL);
//        }
        mChatActionView.setVisibility(View.VISIBLE);
        mChatInputView.switchToInputEdt(true);
        isScrollView = true;
    }

    /**
     * 隐藏控制面板，并根据参数进行输入法的显示
     *
     * @param isShowSoftInputView
     */
    public void hideActionView(boolean isShowSoftInputView) {
        if (mChatActionView.isShown()) {
            mChatActionView.setVisibility(View.GONE);
//            if (mRecyclerView.getTranscriptMode() == AbsListView.TRANSCRIPT_MODE_ALWAYS_SCROLL) {
//                mRecyclerView.setTranscriptMode(AbsListView.TRANSCRIPT_MODE_NORMAL);
//            }
            if (isShowSoftInputView) {
                showSoftInputView();
            }
        }
    }

    /**
     * 固定控制面板之外的内容布局的高度
     */
    public void lockContentViewHeight() {
        LinearLayout.LayoutParams params = getLayoutParamsForContent();
        params.height = mContentLayout.getHeight() + 200;
        params.weight = 0;
    }

    /**
     * 释放掉控制面板之外的内容布局的高度
     */
    public void unlockContentViewHeightDelayed() {
        mChatInputView.getInputEdt().postDelayed(new Runnable() {
            @Override
            public void run() {
                LinearLayout.LayoutParams params = getLayoutParamsForContent();
                params.weight = 1;
                mContentLayout.invalidate();
            }
        }, 200);
    }

    /**
     * 获取控制面板之外的内容布局的布局参数
     *
     * @return
     */
    private LinearLayout.LayoutParams getLayoutParamsForContent() {
        return (LinearLayout.LayoutParams) mContentLayout.getLayoutParams();
    }

    /**
     * 显示输入法
     */
    private void showSoftInputView() {
        final EditText et = mChatInputView.getInputEdt();
        et.requestFocus();
        et.post(new Runnable() {
            @Override
            public void run() {
                inputMethodManager.showSoftInput(et, 0);
                isScrollView = true;
            }
        });
    }

    /**
     * 隐藏输入法
     */
    private void hideSoftInputView() {
        inputMethodManager.hideSoftInputFromWindow(mChatInputView.getInputEdt().getWindowToken(), 0);
    }

    /**
     * 显示或者隐藏EditText对应的软键盘
     *
     * @param isShow 显示或者隐藏
     */
    public void displayInputKeyBoard(boolean isShow) {
        setEditTextFocus(isShow);
        if (!isShow) {
            inputMethodManager.hideSoftInputFromWindow(mChatInputView.getInputEdt().getWindowToken(), 0);
//            if (mRecyclerView.getTranscriptMode() == AbsListView.TRANSCRIPT_MODE_ALWAYS_SCROLL) {
//                mRecyclerView.setTranscriptMode(AbsListView.TRANSCRIPT_MODE_NORMAL);
//            }
        } else {
            inputMethodManager.toggleSoftInput(0, InputMethodManager.HIDE_NOT_ALWAYS);
        }
    }

    /**
     * 设置EditText对应的焦点
     *
     * @param isShow 获取焦点或者是去焦点
     */
    private void setEditTextFocus(boolean isShow) {
        if (isShow) {
            mChatInputView.getInputEdt().setFocusable(true);
            mChatInputView.getInputEdt().setFocusableInTouchMode(true);
            mChatInputView.getInputEdt().requestFocus();
        } else {
            mChatInputView.getInputEdt().setFocusable(false);
        }
    }

    /**
     * 网络状态监测
     */
    private void changeNetworkViewState(int flag) {
        String tips;
        switch (flag) {
            case NetworkHelper.NET_DISABLED:
                tips = getActivity().getResources().getString(R.string.im_uikit_network_disabled);
                networkStateTv.setText(tips);
                networkStateLineaLayout.setVisibility(View.VISIBLE);
                break;
            case NetworkHelper.NO_SERVER:
                tips = getActivity().getResources().getString(R.string.im_uikit_network_no_server);
                networkStateTv.setText(tips);
                networkStateLineaLayout.setVisibility(View.VISIBLE);
                break;
            case NetworkHelper.NET_OK:
                networkStateLineaLayout.setVisibility(View.GONE);
                break;
            default:
                break;
        }
    }
}
