package com.xdja.im.uikit.newui.vu;

import android.support.v7.widget.RecyclerView;

import com.xdja.im.base.frame.view.FragmentBaseView;
import com.xdja.im.lib.action.bean.OptionBean;
import com.xdja.im.uikit.newui.adapter.ChatDetailAdapter;
import com.xdja.im.uikit.newui.presenter.ChatDetailPresenter;

import java.util.List;

/**
 * Created by wenqi on 2018/4/13.
 */

public interface ChatDetailVu extends FragmentBaseView<ChatDetailPresenter> {


    /**
     * 设置ToolBar是否可见
     *
     * @param visibility
     */
    void setToolBarVisibility(int visibility);

    /**
     * 设置Toolbar上add功能是否可用
     *
     * @param visibility
     */
    void setToolBarAddVisibility(int visibility);

    /**
     * 设置显示
     *
     * @param title
     */
    void setTitle(String title);

    /**
     * 设置适配器
     *
     * @param adapter 适配器
     */
    void setAdapter(ChatDetailAdapter adapter);

    /**
     * 设置Option数据
     *
     * @param options
     */
    void setOptions(List<OptionBean> options);

    /**
     * 获取聊天列表控件
     *
     * @return
     */
    RecyclerView getRecyclerView();

    /**
     * 获取输入框文字信息
     *
     * @return
     */
    String getInputContent();

    /**
     * 设置文本显示信息
     *
     * @param content
     */
    void setInputContent(String content);

    /**
     * 是否正在下拉刷新中
     *
     * @return
     */
    boolean isRefreshing();

    /**
     * 停止下拉刷新
     */
    void stopRefresh();

    /**
     * 设置当前选中项<br>
     * 建议使用 setListSelection2Last
     *
     * @param selection
     */
    void setListSelection(int selection);


    /**
     * 恢复操作面板
     */
    void restoreActionState();

    /**
     * 网络状态监测
     * @param state
     */
    void changeViewSate(int state);

    void setMeetState(boolean isShow, int talkType);

    void setChatMeet(String talkFlag);

    void setChatMeetTips(String tips);

    /**
     * 设置聊天类型
     */
    void setTalkType(int talkType);

    /**
     * 设置聊天GroupId
     */
    void setGroupId(String groupId);

    /**
     * 设置聊天账号
     */
    void setAccount(String account);

    void showAtActionView();

    /**
     * 添加@名称
     */
    void setAtText(String s, int type);


    void smoothMoveToPosition(int position);
}
