package com.xdja.im.uikit.ui.activity;

import android.util.Log;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.xdja.im.core.model.message.NoDistrubBean;
import com.xdja.im.core.model.param.DisturbParam;
import com.xdja.im.core.model.param.SettingParam;
import com.xdja.im.lib.video.widget.CustomTimePicker;
import com.xdja.im.uikit.ImUiKitSetting;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.base.ImBaseSettingActivity;

import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;
import rx.schedulers.Schedulers;


/**
 * Created by wangzhen-PC on 2018/01/02.
 */

public class DisturbActivity extends ImBaseSettingActivity implements View.OnClickListener, CompoundButton.OnCheckedChangeListener {

    private final static String TAG = DisturbActivity.class.getSimpleName();

    private CheckBox cbDistrubOn;
    private RelativeLayout rl4StartTime;
    private RelativeLayout rl4EndTime;
    private LinearLayout llShowDistrub;
    private TextView nodistrubStartTv;
    private TextView nodistrubEndTv;

    private DisturbParam param;

    @Override
    public int getLayoutView() {
        return R.layout.im_uikit_activity_distribute;
    }

    @Override
    public void initView() {
        cbDistrubOn = (CheckBox) findViewById(R.id.no_disturb_checkbox);
        rl4StartTime = (RelativeLayout) findViewById(R.id.nodistrub_begin_container);
        rl4EndTime = (RelativeLayout) findViewById(R.id.nodistrub_end_container);
        llShowDistrub = (LinearLayout) findViewById(R.id.nodistrub_time_layout);
        nodistrubStartTv = (TextView) findViewById(R.id.nodistrub_begin_text);
        nodistrubEndTv = (TextView) findViewById(R.id.nodistrub_end_text);
        cbDistrubOn.setOnCheckedChangeListener(this);
        rl4StartTime.setOnClickListener(this);
        rl4EndTime.setOnClickListener(this);

        loadSettingParam();
    }

    @Override
    protected void onPause() {
        super.onPause();

        ImUiKitSetting.getInstance().setDisturbMode(param.isOpen());
        ImUiKitSetting.getInstance().setDisturbStart(param.getStartTime());
        ImUiKitSetting.getInstance().setDisturbEnd(param.getEndTime());
    }


    @Override
    public void onClick(View v) {
        if (v.getId() == R.id.nodistrub_begin_container) {
            if (param != null) {
                NoDistrubBean bean = buildDisturbBean(true, param.getStartTime(), param.getEndTime());
                int hour = bean.getBeginHour();
                int min = bean.getBeginMinu();
                new CustomTimePicker(DisturbActivity.this, new CustomTimePicker.TimerPickerCallBack() {
                    @Override
                    public void onTimeSelected(int hourOfDay, int minute) {
                        final int start = hourOfDay * 3600 + minute * 60;
                        ImUiKitSetting.getInstance().setDisturbStart(start);
                        param.setStartTime(start);

                        NoDistrubBean b = buildDisturbBean(true, start, param.getEndTime());
                        nodistrubStartTv.setText(b.getBeginTime());
                    }
                }).createView(hour, min).show();
            }
        } else if (v.getId() == R.id.nodistrub_end_container) {
            if (param != null) {
                NoDistrubBean bean = buildDisturbBean(true, param.getStartTime(), param.getEndTime());
                int hour = bean.getBeginHour();
                int min = bean.getBeginMinu();
                new CustomTimePicker(DisturbActivity.this, new CustomTimePicker.TimerPickerCallBack() {
                    @Override
                    public void onTimeSelected(int hourOfDay, int minute) {
                        final int end = hourOfDay * 3600 + minute * 60;
                        ImUiKitSetting.getInstance().setDisturbEnd(end);
                        param.setEndTime(end);

                        NoDistrubBean b = buildDisturbBean(true, param.getStartTime(), end);
                        nodistrubEndTv.setText(b.getEndTime());
                    }
                }).createView(hour, min).show();
            }
        }
    }

    @Override
    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        if (buttonView.getId() == R.id.no_disturb_checkbox) {
            if (isChecked) {
                llShowDistrub.setVisibility(View.VISIBLE);
                param.setOpen(true);
            } else {
                llShowDistrub.setVisibility(View.GONE);
                param.setOpen(false);
            }
        }
    }

    /**
     * 加载新消息提醒设置信息
     */
    private void loadSettingParam() {
        Observable.just("")
                .subscribeOn(Schedulers.newThread())
                .flatMap(new Func1<String, Observable<SettingParam>>() {
                    @Override
                    public Observable<SettingParam> call(String s) {
                        SettingParam param = ImUiKitSetting.getInstance().getSettingParam();
                        if (param == null) {
                            return Observable.error(new IllegalArgumentException());
                        }
                        return Observable.just(param);
                    }
                })
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<SettingParam>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        Log.e(TAG, "Load disturb param failed." + e.getMessage());
                    }

                    @Override
                    public void onNext(SettingParam settingParam) {
                        param = settingParam.getDisturb();
                        if (null != param) {
                            if (param.isOpen()) {
                                long startTime = param.getStartTime();
                                long endTime = param.getEndTime();
                                NoDistrubBean bean = buildDisturbBean(true, startTime, endTime);
                                cbDistrubOn.setChecked(true);
                                llShowDistrub.setVisibility(View.VISIBLE);
                                nodistrubStartTv.setText(bean.getBeginTime());
                                nodistrubEndTv.setText(bean.getEndTime());
                            } else {
                                cbDistrubOn.setChecked(false);
                                llShowDistrub.setVisibility(View.GONE);
                            }
                        } else {
                            cbDistrubOn.setChecked(false);
                            llShowDistrub.setVisibility(View.GONE);
                        }
                    }
                });
    }

    private NoDistrubBean buildDisturbBean(boolean isOpen, long start, long end) {
        NoDistrubBean bean = new NoDistrubBean();
        if (start == 0 && end == 0) {
            return bean;
        }
        int startHour = (int) (start / 3600);
        int startMin = (int) ((start - startHour * 3600) / 60);
        int endHour = (int) (end / 3600);
        int endMin = (int) ((end - endHour * 3600) / 60);
        bean.setBeginHour(startHour);
        bean.setBeginMinu(startMin);
        bean.setEndHour(endHour);
        bean.setEndMinu(endMin);
        bean.setIsOpen(isOpen);
        return bean;
    }
}
