package com.xdja.im.uikit.ui.presenter;

import android.app.Activity;
import android.content.Intent;

import com.xdja.im.base.frame.Presenter;
import com.xdja.im.base.frame.view.AdapterBaseView;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.lib.action.bean.OptionBean;

import java.util.List;

/**
 * @Package: com.xdja.im.uikit.presenter.command
 * @Author: xdjaxa
 * @Creation: 2017-04-19 14:58
 * @Version V1.0
 * @Description:
 */
public interface ChatListPresenter extends Presenter {

    /**
     * 获取Activity对象
     *
     * @return
     */
    Activity getActivity();

    /**
     * 获取聊天标识
     *
     * @return
     */
    String getTalkFlag();

    /**
     * 获取聊天类型
     *
     * @return
     */
    int getTalkType();

    /**
     * 启动Activity
     *
     * @param intent
     */
    void startActivity(Intent intent);

    /**
     * 启动Activity
     *
     * @param intent
     * @param requestCode
     */
    void startActivityForResult(Intent intent, int requestCode);

    /**
     * 获取当前聊天页面消息数量
     *
     * @return 消息数量
     */
    int getMessageSize();

    /**
     * 刷新文件下载列表
     */
    void downRefreshList();

    /**
     * 发送文本消息
     *
     * @param message 文本消息内容
     * @return {@code true} 消息可发送，并且发送的动作操作成功 <br />
     * {@code false} 消息不可发送，或者发送的动作操作失败
     */
    boolean sendTextMessage(String message);

    /**
     * 发送文件消息
     *
     * @param fileList 文件列表
     * @return {@code true} 消息可发送，并且发送的动作操作成功 <br />
     * {@code false} 消息不可发送，或者发送的动作操作失败
     */
    void sendFileMessage(List<FileInfo> fileList);

    /**
     * 发送语音录音文件
     *
     * @param path    录音文件路径
     * @param seconds 录音文件时长
     */
    void sendVoiceMessage(String path, int seconds);

    /**
     * 打开Option对应的View界面
     *
     * @param position
     * @param optionBean
     */
    void startToOptionView(int position, OptionBean optionBean);

    /**
     * 启动图库获取图片
     */
    void startToAlbum();

    /**
     * 相机拍照获取图片
     */
    void startToCamera();

    /**
     * 文件管理器获取文件
     */
    void startToFileExplorer();

    /**
     * 摄像头获取小视频
     */
    void startToVideo();

    /**
     * 打开设置界面
     */
    void startSetting();

    /**
     * @用户
     *
     * @param account
     */
    void onLongClickAtUser(String groupId, String account,String name);

    void startLocation(int position, OptionBean optionBean);

    void startCallback(int position, OptionBean optionBean);

    void startVoice(int position , OptionBean optionBean);

    void listScroll(int firstVisibleItem, int endVisibleItem);

    /**
     * 加入云会议
     */
    void addMeeting();

    void setNoReadNumber();
}
