package com.xdja.im.uikit.ui.view;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.xdja.im.base.frame.view.AdapterBaseView;
import com.xdja.im.base.frame.view.AdapterSuperBaseView;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.presenter.ChatListAdapterPresenter;
import com.xdja.im.uikit.utils.sys.TimeUtil;

/**
 * Created by wenqi on 2018/4/19.
 * ViewCustomThirdView第三方自定义view
 */

public class ViewCustomThirdView extends AdapterSuperBaseView<ChatListAdapterPresenter, TalkMessageBean>
        implements AdapterBaseView<ChatListAdapterPresenter, TalkMessageBean> {

    private LinearLayout linearLayout;
    private LinearLayout.LayoutParams layoutParams;
    /**
     * 时间差
     */
    public static final long TIME_DIFFERENCE = 5 * 60 * 1000;
    /**
     * 时间线
     */
    private TextView mTimeLineTv;

    private LinearLayout newMessageRemind;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_view_custom_third_view_layout;
    }

    @SuppressLint("WrongViewCast")
    @Override
    protected void injectView() {
        super.injectView();
        linearLayout = getView().findViewById(R.id.view_custom_third_view_layout);
        mTimeLineTv = (TextView) findViewById(R.id.tv_timeLine);
        newMessageRemind = (LinearLayout) findViewById(R.id.no_read_remaind);
        layoutParams = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);
        try {
            if (dataSource != null){
                linearLayout.removeAllViews();
                linearLayout.addView(getPresenter().getThirdTypeViewItem(getActivity(),dataSource),layoutParams);
            }
        }catch (Exception e){
            e.printStackTrace();
        }
        //时间线计算
        if (position == 0) {
            setTimeLineVisible(dataSource.getShowTime());
        } else {
            TalkMessageBean lastMessage = getPresenter().getTalkMessage(curPosition);
            if (lastMessage != null && dataSource.getShowTime() - lastMessage.getShowTime() > TIME_DIFFERENCE) {
                mTimeLineTv.setVisibility(View.VISIBLE);
                mTimeLineTv.setText(TimeUtil.convertChatTime(dataSource.getShowTime()));
            } else {
                mTimeLineTv.setVisibility(View.GONE);
            }
        }

        if (dataSource.isRemind()) {
            newMessageRemind.setVisibility(View.VISIBLE);
        } else {
            newMessageRemind.setVisibility(View.GONE);
        }
        //发送阅读回执
        if (dataSource.getMessageState() < ConstDef.STATE_READED) {
            getPresenter().sendReadReceipt(dataSource);
        }
    }

    private void setTimeLineVisible(long time) {
        mTimeLineTv.setVisibility(View.VISIBLE);
        mTimeLineTv.setText(TimeUtil.convertChatTime(time));
    }
}
