package com.xdja.im.uikit.ui.view;

import android.support.annotation.NonNull;
import android.text.Html;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.xdja.im.common.database.dao.MeetInfoEntityDao;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.message.MeetInfo;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.param.SessionParam;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.lib.emoji.EmotionConfig;
import com.xdja.im.lib.emoji.utils.EmotionUtils;
import com.xdja.im.lib.filemanage.util.UniversalUtil;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.AtPreferencesUtils;
import com.xdja.im.uikit.utils.log.LogUtil;

import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

/**
 * @Package:com.xdja.im.uikit.ui
 * @Author:Lei
 * @Creation:2017-04-13 00:48
 * @Version 1.0
 * @Description:群组会话显示控件
 */
public class ViewGroupItem extends ViewSessionItem {

    public static final String SEPARATOR = ": ";
    private String at = "at";
    private TextView senderName;

    private TextView senderNameSeparator;

    private TextView atRemind;
    private ImageView img_meeting_flag;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_session_group;
    }

    @Override
    protected void injectView() {
        super.injectView();

        View view = getView();
        if (null != view) {
            senderName = (TextView) view.findViewById(R.id.tv_senderName);
            senderNameSeparator = (TextView) view.findViewById(R.id.tv_senderNameSeparate);
            atRemind = (TextView) view.findViewById(R.id.at_remind);
            img_meeting_flag = (ImageView) view.findViewById(R.id.img_meeting_flag);
        }
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkSessionBean dataSource) {
        super.bindDataSource(position, dataSource);
        //senderName.setTag(dataSource.getTalkerAccount());
        updateSessionSenderInfo();
    }

    @Override
    public void onViewReused() {
        super.onViewReused();
      /*  senderName.setVisibility(View.GONE);
        senderNameSeparator.setVisibility(View.GONE);*/
    }

    @Override
    protected CharSequence getContent(String displayName) {
        if (dataSource.getLastMsg() != null && dataSource.getLastMsg().isMine()) {
            senderName.setVisibility(View.GONE);
            senderNameSeparator.setVisibility(View.GONE);
            return getMessageContent();
        } else {
            senderName.setVisibility(View.VISIBLE);
            senderName.setText(displayName);
            senderNameSeparator.setVisibility(View.VISIBLE);
            return getMessageContent();
        }
    }

    /**
     * 获取消息显示内容
     *
     * @return 消息体
     */
    private CharSequence getMessageContent() {
        TalkMessageBean talkMessageBean = dataSource.getLastMsg();

        //草稿处理
        SessionParam param = dataSource.getParam();
        if (param != null && !TextUtils.isEmpty(param.getDraftContent()) &&
                param.getDraftTime() > 0) {
            CharSequence content = formatDraft(param.getDraftContent());
            LogUtil.d("ViewGroupItem draft:" + content);
            return EmotionUtils.formatSpanContent(content,
                    getActivity(),
                    EmotionConfig.FACE_ITEM_SMALL_VALUE);
        }

        if (talkMessageBean == null) {
            LogUtil.w("Last message info is null.");
            return "";
        }

        int messageType = talkMessageBean.getMessageType();
        //普通消息
        switch (messageType) {
            case ConstDef.MSG_TYPE_TEXT:
                return EmotionUtils.formatSpanContent(dataSource.getContent(),
                        getActivity(), EmotionConfig.FACE_ITEM_SMALL_VALUE);
            case ConstDef.MSG_TYPE_VOICE:
                return getStringRes(R.string.im_uikit_voice);
            case ConstDef.MSG_TYPE_VIDEO:
                return getStringRes(R.string.im_uikit_video);
            case ConstDef.MSG_TYPE_PHOTO:
                return getStringRes(R.string.im_uikit_image);
            case ConstDef.MSG_TYPE_FILE:
                return getStringRes(R.string.im_uikit_file);
            case ConstDef.MSG_TYPE_WEB:
                return getStringRes(R.string.im_uikit_web_message);
            case ConstDef.MSG_TYPE_CUSTOM:
                return getCustomStr(talkMessageBean);
            default:
                return dataSource.getContent() == null ? "" : dataSource.getContent();
        }
    }

    private void updateSessionSenderInfo() {
        atRemind.setVisibility(View.GONE);
        img_meeting_flag.setVisibility(View.GONE);
        if (dataSource != null && dataSource.getLastMsg() != null
                && dataSource.getLastMsg().getMessageType() != ConstDef.MSG_TYPE_PRESENTATION
                /*&& !UniversalUtil.isCiphert(getActivity())*/) {
            if (isCanAtRemid()) {
                atRemind.setVisibility(View.VISIBLE);
                atRemind.setText(formatAtRemind());
            }
        }
        Observable.just(dataSource != null ? dataSource.getTalkFlag() : "")
                .subscribeOn(Schedulers.newThread())
                .map(new Func1<String, MeetInfo>() {
                    @Override
                    public MeetInfo call(String s) {
                        return MeetInfoEntityDao.getInstance().get(s);
                    }
                })
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<MeetInfo>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {
                        e.printStackTrace();
                    }

                    @Override
                    public void onNext(MeetInfo mMeetInfo) {
                        if (mMeetInfo != null && mMeetInfo.getIsShow() == 1 && mMeetInfo.getTaklFlag().equals(dataSource.getTalkFlag())) {
                            img_meeting_flag.setVisibility(View.VISIBLE);
                        } else {
                            img_meeting_flag.setVisibility(View.GONE);
                        }
                    }
                });
//        MeetInfo mMeetInfo = MeetInfoEntityDao.getInstance().get(dataSource != null ? dataSource.getTalkFlag() : "");
//        if (mMeetInfo != null && mMeetInfo.getIsShow() == 1 && mMeetInfo.getTaklFlag().equals(dataSource.getTalkFlag())) {
//            img_meeting_flag.setVisibility(View.VISIBLE);
//        } else if (SpUtils.getInstance().getBoolean(SpUtils.meetChat) && dataSource.getTalkFlag().equals(SpUtils.getInstance().getString(SpUtils.meetTalkFlag))) {
//            img_meeting_flag.setVisibility(View.VISIBLE);
//        } else {
//            img_meeting_flag.setVisibility(View.GONE);
//        }
        if (null != dataSource.getLastMsgAccount() && !dataSource.getLastMsg().isMine()
                && dataSource.getLastMsgType() != ConstDef.MSG_TYPE_PRESENTATION) {
            senderName.setVisibility(View.VISIBLE);
            senderNameSeparator.setVisibility(View.VISIBLE);
            updateSenderView(IMUiKitProxyImpl.getInstance().getAccount(dataSource.getLastMsgAccount(), ConstDef.CHAT_TYPE_P2P));
          /*  IMUiKitProxyImpl.getInstance().getAccount(dataSource.getLastMsgAccount(), ConstDef.CHAT_TYPE_P2P, new Subscriber<AccountBean>() {
                @Override
                public void onCompleted() {

                }

                @Override
                public void onError(Throwable e) {
                    e.printStackTrace();
                }

                @Override
                public void onNext(AccountBean accountBean) {
                    if (senderName.getTag().equals(dataSource.getTalkerAccount())) {
                        updateSenderView(accountBean);
                    }

                }
            });*/

        } else {
            senderName.setVisibility(View.GONE);
            senderNameSeparator.setVisibility(View.GONE);
        }
    }

    private void updateSenderView(AccountBean accountBean) {
        if (null == accountBean) return;
        senderName.setText(accountBean.getDisplayName());
    }

    private boolean isCanAtRemid() {
        if (AtPreferencesUtils.getWrapper(getActivity(), at).gPrefBooleanValue(dataSource.getTalkerAccount(), false)) {
            return true;
        }
        return false;
    }

    private CharSequence formatAtRemind() {
//        String atPreStr = "<font color=\"#941100\">" + getActivity().getString(R.string.im_uikit_at_have_people_remind) + "</font>";
        String str = "<font color=\"" + getActivity().getString(R.string.im_uikit_at_text_color) + "\">" + getActivity().getString(R.string.im_uikit_at_have_people_remind) + "</font>";
        return Html.fromHtml(str);
    }
}
