package com.xdja.im.uikit.utils.tbs;

import android.annotation.SuppressLint;
import android.content.ActivityNotFoundException;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.PixelFormat;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.preference.PreferenceManager;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ImageSpan;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ProgressBar;
import android.widget.Toast;

import com.tencent.smtt.export.external.interfaces.IX5WebChromeClient;
import com.tencent.smtt.export.external.interfaces.JsResult;
import com.tencent.smtt.export.external.interfaces.WebResourceResponse;
import com.tencent.smtt.sdk.CookieSyncManager;
import com.tencent.smtt.sdk.DownloadListener;
import com.tencent.smtt.sdk.WebSettings;
import com.tencent.smtt.sdk.WebViewClient;
import com.xdja.im.lib.filemanage.presenter.BasePresenterActivity;
import com.xdja.im.lib.filemanage.util.ActomaController;
import com.xdja.im.lib.filemanage.util.UniversalUtil;
import com.xdja.im.uikit.R;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TBSBrowserActivity extends AppCompatActivity {

    private static final String TAG = "TBSBrowserActivity";

    public static final String ACTION_VIEW = "android.intent.action.XDJA.VIEW";
    private static final int MAX = 100;
    private static final int MSG_EVENT_PROGRESS = 0;
    public static final String WEB_SHARE_TYPE = "web/";//web分享动作类型
    public static final String TEXT_SHARE_TYPE = "text/";//文本分享动作类型
    public static final String TYPE = "type";
    public static final String FORWARD_ISTEXT = "isText";

    private Toolbar mToolbar;
    private com.tencent.smtt.sdk.WebView mWebView;
    private Uri mUri;
    private int mStyle = BasePresenterActivity.THEME_DARK;
    private SharedPreferences mSharedPreferences = null;
    private ProgressBar mProgressBar;
    private WorkHandler mWorkHandler = new WorkHandler(this);

    public static final class ADFilter {
        private ADFilter() {

        }
        public static boolean hasTBSADURL(Context context, String url) {
            if (TextUtils.isEmpty(url) || context == null) return false;
            url = url.toLowerCase();
            Resources res = context.getResources();
            String[] urls = res.getStringArray(R.array.im_uikit_AD_URL);
            for (String s : urls) {
                if (url.contains(s)) {
                    return true;
                }
            }
            return false;
        }
    }

    @Override
    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext(newBase);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        initializeTheme();
        getWindow().setFormat(PixelFormat.TRANSLUCENT);
        setContentView(R.layout.im_uikit_activity_tbs_activity);
        initializeURL();
        initializeControl();
    }

    @SuppressLint("NewApi")
    private void initializeTheme() {
        mStyle = UniversalUtil.getThemeStyle(this);
        Window window = getWindow();
        window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
        if (mStyle == BasePresenterActivity.THEME_DARK) {
            window.setStatusBarColor(Color.BLACK);
            setTheme(R.style.im_uikit_CommonThemeDark);
        } else {
            View decor = window.getDecorView();
            int ui = decor.getSystemUiVisibility();
            if (Build.VERSION.SDK_INT >= 23) {
                ui |= View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR;
                window.setStatusBarColor(getResources().getColor(R.color.im_uikit_toolbar_background_light));
            } else {
                ui &= ~View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR;
                window.setStatusBarColor(Color.BLACK);
            }
            decor.setSystemUiVisibility(ui);
            setTheme(R.style.im_uikit_CommonThemeLight);
        }
        mSharedPreferences = PreferenceManager.getDefaultSharedPreferences(this);
        if (mSharedPreferences == null || mSharedPreferences.getBoolean(BasePresenterActivity.SCREEN_SHORTS + "-" +
                ActomaController.getMark(), true)) {
            //2018-5-30 wangzhen start modify: 去除防截屏功能
            //getWindow().addFlags(WindowManager.LayoutParams.FLAG_SECURE);
            //2018-5-30 wangzhen end
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.im_uikit_menu_browser, menu);
        return super.onCreateOptionsMenu(menu);
    }

    @SuppressLint("NewApi")
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int id = item.getItemId();
        if (id == R.id.action_refresh) {
            reload();
        } else if (id == R.id.action_copy) {
            ClipData data = ClipData.newPlainText(" ", mWebView.getUrl());
            ((ClipboardManager) getSystemService(Context.CLIPBOARD_SERVICE)).setPrimaryClip(data);
            return true;
        } else if (id == R.id.action_open_browser) {
            openBrowser(mWebView.getUrl());
        } else if (id == R.id.action_send_friend) {
            Intent intent = new Intent();
            intent.setClassName(getPackageName(), "com.xdja.im.lib.share.ShareSessionListActivity");
            intent.setAction("android.intent.action.FORWARD");
            if (WEB_SHARE_TYPE.equals(getIntent().getStringExtra(TYPE))) {
                intent.putExtras(getIntent().getExtras());
                intent.setType(WEB_SHARE_TYPE);
            } else {
                if (getIntent().getBooleanExtra("isAnTongTeam", false)) {
                    String urlString = mWebView.getUrl();
                    if (TextUtils.isEmpty(urlString)) {
                        return true;
                    }
                    intent.setAction(Intent.ACTION_SEND);
                    intent.putExtra("web_url", urlString);
                    intent.putExtra(Intent.EXTRA_TEXT, urlString);
                    intent.putExtra(Intent.EXTRA_SUBJECT, mWebView.getTitle());
                    intent.putExtra("isAnTongTeam", true);
                    intent.setDataAndType(Uri.parse(urlString), "text/plain");
                } else {
                    ClipData beanContentClip = ClipData.newPlainText(" ", mWebView.getUrl());
                    intent.setClipData(beanContentClip);
                    intent.putExtra(Intent.EXTRA_TEXT, mWebView.getUrl());
                    intent.setType(TEXT_SHARE_TYPE);
                    intent.putExtra(FORWARD_ISTEXT, true);
                }
            }
            startActivity(intent);
        }

        return super.onOptionsItemSelected(item);
    }

    private void openBrowser(String url) {
        if (TextUtils.isEmpty(url)) return;
        try {
            Intent intent = new Intent();
            intent.setAction(Intent.ACTION_VIEW);
            intent.setData(Uri.parse(url));
            startActivity(intent);
        } catch (ActivityNotFoundException e) {
            e.printStackTrace();
            Toast.makeText(this, R.string.im_uikit_no_browser, Toast.LENGTH_SHORT).show();
        }
    }

    private void initializeURL() {
        Intent intent = getIntent();
        if (intent == null || intent.getData() == null) {
            finish();
            return;
        }
        mUri = intent.getData();
        if (Integer.parseInt(Build.VERSION.SDK) >= 11) {
            getWindow().setFlags(WindowManager.LayoutParams.FLAG_HARDWARE_ACCELERATED,
                    WindowManager.LayoutParams.FLAG_HARDWARE_ACCELERATED);
        }
    }

    @SuppressLint("SetJavaScriptEnabled")
    private void setConfig() {
        WebSettings webSetting = mWebView.getSettings();
        webSetting.setAllowFileAccess(true);
        webSetting.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);
        webSetting.setSupportZoom(true);
        webSetting.setBuiltInZoomControls(true);
        webSetting.setUseWideViewPort(true);
        webSetting.setSupportMultipleWindows(false);
        // webSetting.setLoadWithOverviewMode(true);
        webSetting.setAppCacheEnabled(true);
        // webSetting.setDatabaseEnabled(true);
        webSetting.setDomStorageEnabled(true);
        webSetting.setJavaScriptEnabled(true);
        webSetting.setGeolocationEnabled(true);
        webSetting.setAppCacheMaxSize(Long.MAX_VALUE);
        webSetting.setAppCachePath(this.getDir("appcache", 0).getPath());
        webSetting.setDatabasePath(this.getDir("databases", 0).getPath());
        webSetting.setGeolocationDatabasePath(this.getDir("geolocation", 0).getPath());
        // webSetting.setPageCacheCapacity(IX5WebSettings.DEFAULT_CACHE_CAPACITY);
        webSetting.setPluginState(WebSettings.PluginState.ON_DEMAND);
    }

    private static class WorkHandler extends Handler {
        private WeakReference<TBSBrowserActivity> mWeakReference;

        public WorkHandler(TBSBrowserActivity weak) {
            if (weak != null) mWeakReference = new WeakReference<TBSBrowserActivity>(weak);
        }

        @Override
        public void handleMessage(Message msg) {
            if (mWeakReference == null || mWeakReference.get() == null) return;
            switch (msg.what) {
                case MSG_EVENT_PROGRESS:
                    if (mWeakReference.get().mProgressBar != null)
                        mWeakReference.get().mProgressBar.setVisibility((Boolean) msg.obj ? View.VISIBLE : View.GONE);
                    break;
            }
        }
    }

    /**
     * 对安通+文本进行输出
     *
     * @return
     * @throws IllegalAccessException
     * @throws NoSuchFieldException
     * @throws IllegalArgumentException
     * @throws NumberFormatException
     */
    private SpannableString formatAnTongSpanContent(CharSequence sourceContent, Context context, float smallScall) {
        if (TextUtils.isEmpty(sourceContent)) {
            return null;
        }
        SpannableString spannableString = new SpannableString(sourceContent);
        int style = UniversalUtil.getThemeStyle(context);
        try {
            Bitmap bitmap;
            String anTongStr = (style == 0 ? "antong_title" : "antong_title_light");

            Pattern pattern = Pattern.compile(context.getResources().getString(R.string.app_name));
            Matcher matcher = pattern.matcher(sourceContent);

            while (matcher.find()) {
                Field field = R.drawable.class.getDeclaredField(anTongStr);
                int resouseId = Integer.parseInt(field.get(null).toString());
                bitmap = BitmapFactory.decodeResource(context.getResources(), resouseId);

                Matrix matrix = new Matrix();
                matrix.postScale(smallScall, smallScall); // 长和宽放大缩小的比例
                Bitmap resizeBmp = Bitmap.createBitmap(bitmap, 0, 0, bitmap.getWidth(),
                        bitmap.getHeight(), matrix, true);
                //memory leak
                if (resizeBmp != bitmap) {
                    bitmap.recycle();
                }
                // 缩小表情图片
                // 用ImageSpan指定图片替代文字
                ImageSpan span = new ImageSpan(context, resizeBmp);
                // 其实写入EditView中的是这个字段“[fac”，表情图片会替代这个字段显示
                spannableString.setSpan(span, matcher.end(), matcher.end() + 1,
                        Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return spannableString;
    }

    private void setWebClient() {
        mWebView.setWebViewClient(new WebViewClient() {
            @Override
            public WebResourceResponse shouldInterceptRequest(com.tencent.smtt.sdk.WebView webView, String url) {
                if (!ADFilter.hasTBSADURL(TBSBrowserActivity.this, url)) {
                    return super.shouldInterceptRequest(webView, url);
                }
                return new WebResourceResponse(null, null, null);
            }

            @Override
            public boolean shouldOverrideUrlLoading(com.tencent.smtt.sdk.WebView view, String url) {
                return false;
            }

            @Override
            public void onPageStarted(com.tencent.smtt.sdk.WebView webView, String s, Bitmap bitmap) {
                super.onPageStarted(webView, s, bitmap);
                removeTBSJSDiv(webView);
                mWorkHandler.removeMessages(MSG_EVENT_PROGRESS);
                mWorkHandler.sendMessage(mWorkHandler.obtainMessage(MSG_EVENT_PROGRESS, true));
            }

            @Override
            public void onPageFinished(com.tencent.smtt.sdk.WebView view, String url) {
                super.onPageFinished(view, url);
                removeTBSJSDiv(view);
                mWorkHandler.sendMessageDelayed(mWorkHandler.obtainMessage(MSG_EVENT_PROGRESS, false), 500);
            }
        });
        mWebView.setWebChromeClient(new com.tencent.smtt.sdk.WebChromeClient() {
            @Override
            public boolean onJsConfirm(com.tencent.smtt.sdk.WebView arg0, String arg1, String arg2, JsResult arg3) {
                return super.onJsConfirm(arg0, arg1, arg2, arg3);
            }

            /**
             * 全屏播放配置
             */
            @Override
            public void onShowCustomView(View view, IX5WebChromeClient.CustomViewCallback customViewCallback) {
            }

            @Override
            public void onProgressChanged(com.tencent.smtt.sdk.WebView webView, int progress) {
                super.onProgressChanged(webView, progress);
                removeTBSJSDiv(webView);
                if (progress <= MAX) {
                    if (mProgressBar != null) mProgressBar.setProgress(progress);
                }
            }

            @Override
            public void onReceivedTitle(com.tencent.smtt.sdk.WebView webView, String s) {
                super.onReceivedTitle(webView, s);
                boolean isAnTongTeam = getIntent().getBooleanExtra("isAnTongTeam", false);
                setTitle(isAnTongTeam ? formatAnTongSpanContent(getString(R.string.app_name),
                        TBSBrowserActivity.this, 1.0f) : s);
            }

            @Override
            public void onHideCustomView() {
            }

            @Override
            public boolean onJsAlert(com.tencent.smtt.sdk.WebView arg0, String arg1, String arg2, JsResult arg3) {
                return super.onJsAlert(null, arg1, arg2, arg3);
            }
        });
        mWebView.setDownloadListener(new DownloadListener() {

            @Override
            public void onDownloadStart(String arg0, String arg1, String arg2, String arg3, long arg4) {
                openBrowser(mWebView.getUrl());
            }
        });
    }

    private void removeTBSJSDiv(com.tencent.smtt.sdk.WebView webView) {
        if (webView == null) return;
        webView.loadUrl("javascript:function setTop(){document.querySelector('.mod-download-fixer').style" + "" +
                ".display=\"none\";}setTop();");
    }

    private void initializeControl() {
        setTitle("");
        mToolbar = (Toolbar) this.findViewById(R.id.toolbar);
        setSupportActionBar(mToolbar);
        mToolbar.setNavigationIcon(mStyle == BasePresenterActivity.THEME_LIGHT ? R.drawable.im_uikit_af_abs_ic_back_light : R
                .drawable.im_uikit_af_abs_ic_back);
        mToolbar.setNavigationOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });
        mProgressBar = (ProgressBar) findViewById(android.R.id.progress);
        mProgressBar.setProgressDrawable(getResources().getDrawable(mStyle == BasePresenterActivity.THEME_LIGHT ? R
                .drawable.im_uikit_progress_horizontal_light : R.drawable.im_uikit_progress_horizontal));
        mProgressBar.setMax(MAX);
        mWebView = (com.tencent.smtt.sdk.WebView) findViewById(R.id.webview);
        mWebView.getView().setClickable(true);
        setConfig();
        setWebClient();
        CookieSyncManager.createInstance(this);
        CookieSyncManager.getInstance().sync();
        loadUrl(mUri.toString());
    }

    private void loadUrl(String url) {
        if (mWebView != null) mWebView.loadUrl(url);
    }

    private void reload() {
        if (mWebView != null) mWebView.reload();
    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (intent == null || mWebView == null || intent.getData() == null) return;
        loadUrl(intent.getData().toString());
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            if (mWebView != null && mWebView.canGoBack()) {
                mWebView.goBack();
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    protected void onResume() {
        super.onResume();
        if (mWebView != null) mWebView.onResume();
    }

    @Override
    protected void onPause() {
        super.onPause();
        if (mWebView != null) mWebView.onPause();
    }

    @Override
    protected void onDestroy() {
        if (mWebView != null) {
            mWebView.clearCache(true);
            mWebView.clearFormData();
            mWebView.clearHistory();
            mWebView.destroy();
        }
        super.onDestroy();
        if (mWorkHandler != null) {
            mWorkHandler.removeCallbacksAndMessages(null);
        }
    }
}
