/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.http;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;
import com.xdja.imsdk.logger.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class WebRelayHttps {
    private static String DEFAULT_PASSWORD = "111111";

    public static SSLParams getSslSocketFactory(Context context, int storeId, String pwd) {
        SSLParams sslParams = new SSLParams();
        KeyStore keyStore = WebRelayHttps.readKeyStore(context, storeId, pwd);
        SSLContext sslContext = WebRelayHttps.getSSLContext(keyStore);
        X509TrustManager trustManager = WebRelayHttps.getTrustManager(keyStore);
        sslParams.sSLSocketFactory = sslContext.getSocketFactory();
        sslParams.trustManager = trustManager;
        return sslParams;
    }

    private static KeyStore readKeyStore(Context cxt, int res, String pwd) {
        InputStream inputStream = null;
        KeyStore keyStore = null;
        String password = "";
        password = TextUtils.isEmpty((CharSequence)pwd) ? DEFAULT_PASSWORD : pwd;
        try {
            try {
                keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                inputStream = cxt.getResources().openRawResource(res);
                keyStore.load(inputStream, password.toCharArray());
            }
            catch (Exception e) {
                Logger.getLogger().e(e);
            }
        }
        catch (Throwable throwable) {}
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return keyStore;
    }

    @SuppressLint(value={"TrulyRandom"})
    private static SSLContext getSSLContext(KeyStore keyStore) {
        if (keyStore == null) {
            return null;
        }
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("SSL");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, DEFAULT_PASSWORD.toCharArray());
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
        }
        catch (Exception e) {
            Logger.getLogger().e(e);
        }
        return sslContext;
    }

    private static X509TrustManager getTrustManager(KeyStore keyStore) {
        if (keyStore == null) {
            return null;
        }
        X509TrustManager trustManager = null;
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, DEFAULT_PASSWORD.toCharArray());
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            trustManager = trustManagers != null ? new IMTrustManager(WebRelayHttps.chooseTrustManager(trustManagers)) : new UnSafeTrustManager();
        }
        catch (Exception e) {
            Logger.getLogger().e(e);
        }
        return trustManager;
    }

    private static X509TrustManager chooseTrustManager(TrustManager[] trustManagers) {
        TrustManager[] trustManagerArray = trustManagers;
        int n = trustManagers.length;
        int n2 = 0;
        while (n2 < n) {
            TrustManager trustManager = trustManagerArray[n2];
            if (trustManager instanceof X509TrustManager) {
                return (X509TrustManager)trustManager;
            }
            ++n2;
        }
        return null;
    }

    private static class IMTrustManager
    implements X509TrustManager {
        private X509TrustManager defaultTrustManager;
        private X509TrustManager localTrustManager;

        public IMTrustManager(X509TrustManager localTrustManager) throws NoSuchAlgorithmException, KeyStoreException {
            TrustManagerFactory var4 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            var4.init((KeyStore)null);
            this.defaultTrustManager = WebRelayHttps.chooseTrustManager(var4.getTrustManagers());
            this.localTrustManager = localTrustManager;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            try {
                this.defaultTrustManager.checkServerTrusted(chain, authType);
            }
            catch (CertificateException ce) {
                this.localTrustManager.checkServerTrusted(chain, authType);
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    public static class SSLParams {
        public SSLSocketFactory sSLSocketFactory;
        public X509TrustManager trustManager;
    }

    private static class UnSafeTrustManager
    implements X509TrustManager {
        private UnSafeTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

