/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.http.file;

import android.content.Context;
import com.xdja.imsdk.logger.Logger;
import com.xdja.imsdk.manager.ImSdkConfigManager;
import com.xdja.imsdk.util.ToolUtils;
import java.io.IOException;
import java.util.Properties;

public class FastDfsHttpClientConfig {
    public static final String CONF_PATH = "fdfs_http_client.conf";
    private int timeout = 3000;
    private String host;
    private String port;
    private String uploadUrl;
    private String appendUrl;
    private String downloadUrl;
    private String deleteUrl;
    private String infoUrl;
    private String crc32Url;

    public FastDfsHttpClientConfig(Context context) {
        try {
            Properties prop = new Properties();
            prop.load(context.getAssets().open(CONF_PATH));
            this.host = this.isEmpty(ImSdkConfigManager.getInstance().getFileServer()) ? prop.getProperty("http.host") : ImSdkConfigManager.getInstance().getFileServer();
            this.port = this.isEmpty(ImSdkConfigManager.getInstance().getFilePort()) ? prop.getProperty("http.port") : ImSdkConfigManager.getInstance().getFilePort();
            this.uploadUrl = this.isEmpty(prop.getProperty("http.upload")) ? this.normalize("{HOST}:{PORT}/upload") : this.normalize(prop.getProperty("http.upload"));
            this.appendUrl = this.isEmpty(prop.getProperty("http.append")) ? this.normalize("{HOST}:{PORT}/append/{FID}") : this.normalize(prop.getProperty("http.append"));
            this.downloadUrl = this.isEmpty(prop.getProperty("http.download")) ? this.normalize("{HOST}:{PORT}/download/{FID}") : this.normalize(prop.getProperty("http.download"));
            this.deleteUrl = this.isEmpty(prop.getProperty("http.delete")) ? this.normalize("{HOST}:{PORT}/delete/{FID}") : this.normalize(prop.getProperty("http.delete"));
            this.infoUrl = this.isEmpty(prop.getProperty("http.info")) ? this.normalize("{HOST}:{PORT}/info/{FID}") : this.normalize(prop.getProperty("http.info"));
            this.crc32Url = this.isEmpty(prop.getProperty("http.crc32")) ? this.normalize("{HOST}:{PORT}/crc32/{FID}") : this.normalize(prop.getProperty("http.crc32"));
            Logger.getLogger().d("uploadUrl:" + this.uploadUrl + ",appendUrl:" + this.appendUrl + ",downloadUrl:" + this.downloadUrl);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String normalize(String property) {
        return "http://" + property.replace("{HOST}", this.host).replace("{PORT}", this.port);
    }

    public String getUploadUrl() {
        return this.uploadUrl;
    }

    public String getAppendUrl(String fid) {
        return this.appendUrl.replace("{FID}", fid);
    }

    public String getDownloadUrl(String fid) {
        return this.downloadUrl.replace("{FID}", fid);
    }

    public String getDeleteUrl(String fid) {
        return this.deleteUrl.replace("{FID}", fid);
    }

    public String getInfoUrl(String fid) {
        return this.infoUrl.replace("{FID}", fid);
    }

    public String getCrc32Url(String fid) {
        return this.crc32Url.replace("{FID}", fid);
    }

    public int getTimeout() {
        return this.timeout;
    }

    private boolean isEmpty(String str) {
        return ToolUtils.isEmpty(str);
    }
}

