/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.http.okhttp;

import android.content.Context;
import android.support.annotation.NonNull;
import com.xdja.imsdk.constant.internal.HttpApiConstant;
import com.xdja.imsdk.http.RequestInfo;
import com.xdja.imsdk.http.SecurityHttps;
import com.xdja.imsdk.http.callback.IHttpCallback;
import com.xdja.imsdk.http.callback.IPostCallback;
import com.xdja.imsdk.http.config.ImRequestConfig;
import com.xdja.imsdk.http.file.FileEntry;
import com.xdja.imsdk.http.file.callback.IFileDownloadCallback;
import com.xdja.imsdk.http.file.callback.IFileUploadCallback;
import com.xdja.imsdk.http.okhttp.ProgressListener;
import com.xdja.imsdk.http.okhttp.constant.OkHttpConstants;
import com.xdja.imsdk.http.okhttp.interceptor.FileChunkInterceptor;
import com.xdja.imsdk.http.okhttp.interceptor.FileIdInterceptor;
import com.xdja.imsdk.http.okhttp.interceptor.LoggingInterceptor;
import com.xdja.imsdk.http.okhttp.interceptor.NetworkStateInterceptor;
import com.xdja.imsdk.http.okhttp.interceptor.ProgressInterceptor;
import com.xdja.imsdk.http.okhttp.interceptor.RetryInterceptor;
import com.xdja.imsdk.http.okhttp.interceptor.SignInterceptor;
import com.xdja.imsdk.http.okhttp.interceptor.TicketInterceptor;
import com.xdja.imsdk.http.okhttp.interceptor.TimeStampInterceptor;
import com.xdja.imsdk.logger.Logger;
import com.xdja.imsdk.manager.HttpManager;
import com.xdja.imsdk.manager.ImSdkConfigManager;
import com.xdja.imsdk.util.CRC32Util;
import com.xdja.imsdk.util.FileUtils;
import com.xdja.imsdk.util.JsonUtils;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dispatcher;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.json.JSONException;
import org.json.JSONObject;

public class OkHttpManager
extends HttpManager {
    private static final OkHttpManager ourInstance = new OkHttpManager();
    private static final int MAX_FILE_NAME_LENGTH = 128;
    private OkHttpClient mClient;

    public static OkHttpManager getInstance() {
        return ourInstance;
    }

    private OkHttpManager() {
    }

    private synchronized OkHttpClient getClient() {
        if (this.mClient == null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.mClient;
    }

    @Override
    protected synchronized void initClient(Context context, int keyStoreId, String keyStorePassword) {
        if (this.mClient == null) {
            SecurityHttps.SSLParams sslParams = SecurityHttps.getSSLParams(context, keyStoreId, keyStorePassword);
            this.mClient = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).sslSocketFactory(sslParams.sSLSocketFactory).addInterceptor((Interceptor)new LoggingInterceptor()).addNetworkInterceptor((Interceptor)new NetworkStateInterceptor(new NetworkStateInterceptor.Callback(){

                @Override
                public void onState(int code) {
                    if (OkHttpManager.this.mCallback != null) {
                        OkHttpManager.this.mCallback.NetChanged(code);
                    }
                }
            })).build();
            this.notifyAll();
        }
    }

    @Override
    protected void doImRequest(final JSONObject object, ImRequestConfig config, final IHttpCallback callback) {
        final String method = HttpApiConstant.IMRequestType.STATE.equals((Object)config.getpType()) ? "PUT" : "POST";
        OkHttpClient client = this.getClient().newBuilder().addInterceptor((Interceptor)new TicketInterceptor()).addInterceptor((Interceptor)new RetryInterceptor(new RetryInterceptor.Callback(){

            @Override
            @NonNull
            public Request createRequest(Request originalRequest) {
                return originalRequest.newBuilder().method(method, RequestBody.create((MediaType)OkHttpConstants.MEDIA_TYPE_JSON, (String)object.toString())).build();
            }
        })).build();
        Request request = new Request.Builder().url(this.getPostUrl(config)).method(method, RequestBody.create((MediaType)OkHttpConstants.MEDIA_TYPE_JSON, (String)object.toString())).tag((Object)config.getMsgId()).build();
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NonNull Call call, @NonNull IOException e) {
                callback.onFailed(50102, object);
            }

            public void onResponse(@NonNull Call call, @NonNull Response response) throws IOException {
                String result = response.body().string();
                if (response.isSuccessful()) {
                    try {
                        callback.onSuccess(new JSONObject(result));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        callback.onFailed(50102, object);
                    }
                } else {
                    callback.onFailed(response.code(), object, result);
                }
            }
        });
    }

    @Override
    public void postAsync(final @NonNull RequestInfo requestInfo, final IPostCallback callback) {
        OkHttpClient client = this.getClient().newBuilder().addInterceptor((Interceptor)new TicketInterceptor()).build();
        Request request = new Request.Builder().url(requestInfo.getUrl()).post(RequestBody.create((MediaType)OkHttpConstants.MEDIA_TYPE_JSON, (String)requestInfo.getJson())).tag((Object)requestInfo.getTag()).build();
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NonNull Call call, @NonNull IOException e) {
                callback.onFailed(40000, requestInfo);
            }

            public void onResponse(@NonNull Call call, @NonNull Response response) throws IOException {
                if (response.isSuccessful()) {
                    callback.onSuccess(response.body().string(), requestInfo);
                } else {
                    callback.onFailed(response.code(), requestInfo);
                }
            }
        });
    }

    @Override
    public void uploadFile(final FileEntry entry, final IFileUploadCallback callback) {
        File file = new File(entry.getEncryptPath());
        final FileChunkInterceptor fileChunkInterceptor = new FileChunkInterceptor(file, new ProgressListener(){

            @Override
            public void update(long byteCount, int progress, boolean done) {
                entry.settSize(byteCount);
                callback.uploadFileProgressUpdate(progress, entry);
            }
        });
        OkHttpClient client = this.getClient().newBuilder().addInterceptor((Interceptor)new TimeStampInterceptor()).addInterceptor((Interceptor)new SignInterceptor(ImSdkConfigManager.getInstance().getFastDfsUserId())).addInterceptor((Interceptor)fileChunkInterceptor).addInterceptor((Interceptor)new FileIdInterceptor(new FileIdInterceptor.Callback(){

            @Override
            public void onFileIdObtained(String fileId) {
                entry.setFid(fileId);
                callback.uploadFileStart(entry);
            }
        })).addInterceptor((Interceptor)new RetryInterceptor(new RetryInterceptor.Callback(){

            @Override
            @NonNull
            public Request createRequest(Request originalRequest) {
                return originalRequest.newBuilder().post(fileChunkInterceptor.createRequestBody()).build();
            }
        })).build();
        String userId = ImSdkConfigManager.getInstance().getFastDfsUserId();
        HttpUrl url = HttpUrl.parse((String)ImSdkConfigManager.getInstance().getFastDfsUpload()).newBuilder().addQueryParameter("userid", userId).build();
        Request request = new Request.Builder().url(url).header("filename", this.getValidFileName(entry)).header("filesize", String.valueOf(entry.getEncryptSize())).tag((Object)String.valueOf(entry.getId())).build();
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NonNull Call call, @NonNull IOException e) {
                callback.uploadFileError(50035, entry);
            }

            public void onResponse(@NonNull Call call, @NonNull Response response) {
                if (response.isSuccessful()) {
                    OkHttpManager.this.getFileInfo(entry, callback);
                } else {
                    callback.uploadFileError(50035, entry);
                }
            }
        });
    }

    private void getFileInfo(final FileEntry entry, final IFileUploadCallback callback) {
        OkHttpClient client = this.getClient().newBuilder().addInterceptor((Interceptor)new TimeStampInterceptor()).addInterceptor((Interceptor)new SignInterceptor("/info/" + entry.getFid())).build();
        Request request = new Request.Builder().url(ImSdkConfigManager.getInstance().getFastDfsInfo(entry.getFid())).tag((Object)String.valueOf(entry.getId())).build();
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NonNull Call call, @NonNull IOException e) {
                callback.uploadFileFinish(entry);
            }

            public void onResponse(@NonNull Call call, @NonNull Response response) throws IOException {
                String serverCrc32;
                String localCrc32 = Long.toHexString(CRC32Util.getFileCRC32(entry.getEncryptPath()));
                if (localCrc32.equals(serverCrc32 = JsonUtils.getString(response.body().string(), "crc32"))) {
                    callback.uploadFileFinish(entry);
                } else {
                    callback.uploadFileError(50035, entry);
                    OkHttpManager.this.deleteFile(entry);
                }
            }
        });
    }

    private void deleteFile(final FileEntry entry) {
        OkHttpClient client = this.getClient().newBuilder().addInterceptor((Interceptor)new TimeStampInterceptor()).addInterceptor((Interceptor)new SignInterceptor("/delete/" + entry.getFid())).build();
        Request request = new Request.Builder().url(ImSdkConfigManager.getInstance().getFastDfsDelete(entry.getFid())).tag((Object)String.valueOf(entry.getId())).build();
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NonNull Call call, @NonNull IOException e) {
                Logger.getLogger().w("Delete file failed: fileId=" + entry.getFid() + ", error=" + e);
            }

            public void onResponse(@NonNull Call call, @NonNull Response response) throws IOException {
                Logger.getLogger().i("Delete file result: fileId=" + entry.getFid() + ", code=" + response.code() + ", message=" + response.body().string());
            }
        });
    }

    @Override
    protected void pauseFileUpload(String tag) {
        this.cancel(tag);
    }

    @Override
    public void downloadFile(final FileEntry entry, boolean isSupportRange, final IFileDownloadCallback callback) {
        if (this.isRepeatedDownload(entry)) {
            return;
        }
        final File file = new File(entry.getEncryptPath());
        final long offset = isSupportRange ? entry.gettSize() : 0L;
        OkHttpClient client = this.getClient().newBuilder().addInterceptor((Interceptor)new TimeStampInterceptor()).addInterceptor((Interceptor)new SignInterceptor(entry.getFid())).addInterceptor((Interceptor)new RetryInterceptor(new RetryInterceptor.Callback(){

            @Override
            @NonNull
            public Request createRequest(Request originalRequest) {
                return originalRequest;
            }
        })).addNetworkInterceptor((Interceptor)new ProgressInterceptor(offset, new ProgressListener(){

            @Override
            public void update(long byteCount, int progress, boolean done) {
                entry.settSize(byteCount);
                callback.downloadFileProgressUpdate(progress, entry);
                if (done) {
                    callback.downloadFileFinish(entry);
                }
            }
        })).build();
        String rangeValue = String.format(Locale.getDefault(), "bytes=%d-", offset);
        Request request = new Request.Builder().url(String.valueOf(ImSdkConfigManager.getInstance().getFastDfsDownload()) + entry.getFid()).header("RANGE", rangeValue).tag((Object)String.valueOf(entry.getId())).build();
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NonNull Call call, @NonNull IOException e) {
                if (call.isCanceled()) {
                    callback.downloadFilePause(entry);
                } else {
                    callback.downloadFileError(50036, entry);
                }
            }

            public void onResponse(@NonNull Call call, @NonNull Response response) {
                if (response.isSuccessful()) {
                    ResponseBody body = response.body();
                    try {
                        FileUtils.save(body.byteStream(), body.contentLength(), file, offset);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        callback.downloadFilePause(entry);
                    }
                } else {
                    callback.downloadFileError(50036, entry);
                }
            }
        });
    }

    @Override
    public void downloadFilePause(FileEntry entry) {
        this.cancel(String.valueOf(entry.getId()));
    }

    @Override
    public void cancelRequest(Long msgId) {
        this.cancel(String.valueOf(msgId));
    }

    @Override
    public void cancelAll() {
        this.getClient().dispatcher().cancelAll();
    }

    private void cancel(String tag) {
        Dispatcher dispatcher = this.getClient().dispatcher();
        for (Call call : dispatcher.queuedCalls()) {
            if (!tag.equals(call.request().tag())) continue;
            call.cancel();
        }
        for (Call call : dispatcher.runningCalls()) {
            if (!tag.equals(call.request().tag())) continue;
            call.cancel();
        }
    }

    private String getValidFileName(FileEntry entry) {
        String fileName = entry.getName();
        String suffix = FileUtils.getSuffix(fileName);
        if (suffix == null) {
            fileName = String.valueOf(fileName) + "." + entry.getSuffix();
        }
        if (fileName.length() > 128) {
            fileName = fileName.substring(fileName.length() - 128);
        }
        try {
            fileName = URLEncoder.encode(fileName, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return fileName;
    }

    private boolean isRepeatedDownload(@NonNull FileEntry entry) {
        String tag = String.valueOf(entry.getId());
        String url = String.valueOf(ImSdkConfigManager.getInstance().getFastDfsDownload()) + entry.getFid();
        Dispatcher dispatcher = this.getClient().dispatcher();
        for (Call call : dispatcher.queuedCalls()) {
            if (!tag.equals(call.request().tag()) || !url.equals(call.request().url().toString())) continue;
            return true;
        }
        for (Call call : dispatcher.runningCalls()) {
            if (!tag.equals(call.request().tag()) || !url.equals(call.request().url().toString())) continue;
            return true;
        }
        return false;
    }
}

