/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.http.okhttp.body;

import android.support.annotation.NonNull;
import com.xdja.imsdk.http.okhttp.ProgressListener;
import com.xdja.imsdk.http.okhttp.constant.OkHttpConstants;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;

public final class ChunkProgressRequestBody
extends RequestBody {
    private static final int BUFFER_LENGTH = 2048;
    @NonNull
    private File mFile;
    private long mChunk;
    @NonNull
    private final ProgressListener mProgressListener;

    public ChunkProgressRequestBody(@NonNull File file, long chunk, @NonNull ProgressListener progressListener) {
        this.mFile = file;
        this.mChunk = chunk;
        this.mProgressListener = progressListener;
    }

    public MediaType contentType() {
        return OkHttpConstants.MEDIA_TYPE_FILE;
    }

    public long contentLength() {
        long available = this.mFile.length() - this.mChunk * 0x500000L;
        return Math.min(available, 0x500000L);
    }

    public void writeTo(@NonNull BufferedSink sink) throws IOException {
        RandomAccessFile accessFile = null;
        int currentProgress = 0;
        long offset = this.mChunk * 0x500000L;
        int blocks = (int)Math.ceil((double)this.contentLength() * 1.0 / 2048.0);
        byte[] buffer = new byte[2048];
        try {
            accessFile = new RandomAccessFile(this.mFile, "r");
            accessFile.seek(offset);
            int i = 0;
            while (i < blocks) {
                int size = accessFile.read(buffer);
                sink.write(buffer, 0, size);
                long byteCount = offset + (long)(i * 2048) + (long)size;
                int progress = (int)(byteCount * 100L / this.mFile.length());
                if (progress > currentProgress) {
                    this.mProgressListener.update(byteCount, progress, byteCount == this.mFile.length());
                    currentProgress = progress;
                }
                ++i;
            }
        }
        finally {
            if (accessFile != null) {
                accessFile.close();
            }
        }
    }
}

