/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.http.okhttp.interceptor;

import android.support.annotation.NonNull;
import com.xdja.imsdk.http.okhttp.ProgressListener;
import com.xdja.imsdk.http.okhttp.body.ChunkProgressRequestBody;
import java.io.File;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public final class FileChunkInterceptor
implements Interceptor {
    @NonNull
    private File mFile;
    @NonNull
    private ProgressListener mProgressListener;
    private int mChunk;

    public FileChunkInterceptor(@NonNull File file, @NonNull ProgressListener callback) {
        this.mFile = file;
        this.mProgressListener = callback;
    }

    public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
        Response response = null;
        this.mChunk = 0;
        while (this.mFile.length() - (long)(this.mChunk * 0x500000) > 0L) {
            Request request = chain.request().newBuilder().post(this.createRequestBody()).build();
            response = chain.proceed(request);
            if (!response.isSuccessful()) break;
            ++this.mChunk;
        }
        return response;
    }

    @NonNull
    public RequestBody createRequestBody() {
        return new ChunkProgressRequestBody(this.mFile, this.mChunk, this.mProgressListener);
    }
}

