/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.http.okhttp.interceptor;

import android.support.annotation.NonNull;
import com.xdja.imsdk.http.okhttp.constant.OkHttpConstants;
import com.xdja.imsdk.util.JsonUtils;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public final class FileIdInterceptor
implements Interceptor {
    private String mFileId;
    @NonNull
    private Callback mCallback;

    public FileIdInterceptor(@NonNull Callback callback) {
        this.mCallback = callback;
    }

    public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
        if (this.mFileId == null) {
            Response response = chain.proceed(chain.request());
            String result = response.body().string();
            this.mFileId = JsonUtils.getString(result, "fileid");
            this.mCallback.onFileIdObtained(this.mFileId);
            return response.newBuilder().body(ResponseBody.create((MediaType)OkHttpConstants.MEDIA_TYPE_JSON, (String)result)).build();
        }
        Request request = chain.request().newBuilder().header("fileid", this.mFileId).build();
        return chain.proceed(request);
    }

    public static interface Callback {
        public void onFileIdObtained(String var1);
    }
}

