/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.http.okhttp.interceptor;

import android.support.annotation.NonNull;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import okhttp3.Interceptor;
import okhttp3.Response;

public final class NetworkStateInterceptor
implements Interceptor {
    @NonNull
    private Callback mCallback;

    public NetworkStateInterceptor(@NonNull Callback callback) {
        this.mCallback = callback;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        try {
            response = chain.proceed(chain.request());
            this.mCallback.onState(40000);
        }
        catch (IOException e) {
            e.printStackTrace();
            if (e instanceof SocketTimeoutException) {
                this.mCallback.onState(40007);
            } else if (e instanceof UnknownHostException) {
                this.mCallback.onState(40004);
            }
            throw e;
        }
        return response;
    }

    public static interface Callback {
        public void onState(int var1);
    }
}

