/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.http.okhttp.interceptor;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.xdja.imsdk.logger.Logger;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.json.JSONException;
import org.json.JSONObject;

public final class RetryInterceptor
implements Interceptor {
    private static final long MAX_RETRY_TIME = 1200000L;
    private static final long DELAY_INTERVAL = 3000L;
    @NonNull
    private Callback mCallback;

    public RetryInterceptor(@NonNull Callback callback) {
        this.mCallback = callback;
    }

    public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
        long fistRequestTime = System.currentTimeMillis();
        int retryCount = 0;
        RetryResponse retryResponse = this.proceedRequest(chain, chain.request());
        while (retryResponse.isFailed() && !retryResponse.isAborted() && !retryResponse.isCanceled() && System.currentTimeMillis() - fistRequestTime < 1200000L) {
            try {
                Thread.sleep((long)(++retryCount) * 3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Logger.getLogger().d("Retry request: url=" + chain.request().url() + ", headers=" + chain.request().headers() + ", reason=" + retryResponse);
            retryResponse = this.proceedRequest(chain, this.mCallback.createRequest(chain.request()));
        }
        if (retryResponse.exception != null) {
            throw retryResponse.exception;
        }
        return retryResponse.response;
    }

    private RetryResponse proceedRequest(Interceptor.Chain chain, Request request) {
        RetryResponse retryResponse;
        try {
            Response response = chain.proceed(request);
            retryResponse = new RetryResponse(response, null);
        }
        catch (IOException e) {
            e.printStackTrace();
            retryResponse = new RetryResponse(null, e);
        }
        return retryResponse;
    }

    public static interface Callback {
        @NonNull
        public Request createRequest(Request var1);
    }

    private static final class RetryResponse {
        @Nullable
        Response response;
        @Nullable
        IOException exception;

        RetryResponse(@Nullable Response response, @Nullable IOException exception) {
            this.response = response;
            this.exception = exception;
        }

        boolean isFailed() {
            return this.response == null || !this.response.isSuccessful();
        }

        boolean isAborted() {
            if (this.response == null) {
                return false;
            }
            String errorContent = null;
            try {
                errorContent = this.response.body().string();
                JSONObject errorJsonObject = new JSONObject(errorContent);
                int errorCode = errorJsonObject.optInt("code");
                if (errorCode == 0) {
                    errorCode = errorJsonObject.optInt("errCode");
                }
                if (errorCode == 703 || errorCode == 36872) {
                    return true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            finally {
                if (errorContent != null) {
                    this.response = this.response.newBuilder().body(ResponseBody.create((MediaType)this.response.body().contentType(), (String)errorContent)).build();
                }
            }
            return false;
        }

        boolean isCanceled() {
            return this.exception != null && "Canceled".equals(this.exception.getMessage());
        }

        public String toString() {
            if (this.response != null) {
                return "RetryResponse{code=" + this.response.code() + ", headers=" + this.response.headers() + "}";
            }
            if (this.exception != null) {
                return "RetryResponse{exception=" + this.exception + "}";
            }
            return super.toString();
        }
    }
}

