/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.http.okhttp.interceptor;

import android.support.annotation.NonNull;
import com.xdja.imsdk.manager.ImSdkConfigManager;
import com.xdja.imsdk.util.HmacSHA1Util;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public final class SignInterceptor
implements Interceptor {
    @NonNull
    private String mSignPrefix;

    public SignInterceptor(@NonNull String signPrefix) {
        this.mSignPrefix = signPrefix;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        HttpUrl originalUrl = chain.request().url();
        String data = String.valueOf(this.mSignPrefix) + originalUrl.queryParameter("ts");
        String sign = null;
        try {
            sign = HmacSHA1Util.hamcsha1(data, ImSdkConfigManager.getInstance().getFastDfsUserSecret());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        HttpUrl url = originalUrl.newBuilder().addQueryParameter("sign", sign).build();
        Request request = chain.request().newBuilder().url(url).build();
        return chain.proceed(request);
    }
}

