/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.http.okhttp.interceptor;

import android.os.SystemClock;
import android.support.annotation.NonNull;
import com.xdja.imsdk.manager.ImSdkConfigManager;
import com.xdja.imsdk.util.JsonUtils;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public final class TimeStampInterceptor
implements Interceptor {
    private static final int EXPIRED_TIME = 1800000;
    private static long sBootTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
        Class<TimeStampInterceptor> clazz = TimeStampInterceptor.class;
        synchronized (TimeStampInterceptor.class) {
            if (sBootTime == 0L) {
                OkHttpClient client = new OkHttpClient();
                Request request = new Request.Builder().url(ImSdkConfigManager.getInstance().getFastDfsTime()).build();
                try {
                    Response response = client.newCall(request).execute();
                    sBootTime = JsonUtils.getLong(response.body().string(), "timestamp") - SystemClock.elapsedRealtime();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            HttpUrl url = chain.request().url().newBuilder().addQueryParameter("ts", String.valueOf(this.getExpiredTimestamp())).build();
            Request request = chain.request().newBuilder().url(url).build();
            return chain.proceed(request);
        }
    }

    private long getExpiredTimestamp() {
        return (sBootTime > 0L ? sBootTime + SystemClock.elapsedRealtime() : System.currentTimeMillis()) + 1800000L;
    }
}

