/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.http.receipt;

import com.xdja.google.gson.reflect.TypeToken;
import com.xdja.imsdk.http.receipt.request.MssGetRequest;
import com.xdja.imsdk.http.receipt.request.param.MssBaseInfo;
import com.xdja.imsdk.http.receipt.result.MssBatchResult;
import com.xdja.imsdk.http.receipt.result.MssSuccessResult;
import com.xdja.imsdk.logger.Logger;
import com.xdja.imsdk.util.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MssParser {
    public static MssGetRequest parseReadRequest(String request) {
        try {
            MssGetRequest getRequest = (MssGetRequest)JsonUtils.getGson().fromJson(request, new TypeToken<MssGetRequest>(){}.getType());
            return getRequest;
        }
        catch (Exception e) {
            Logger.getLogger().e("ImSdk parse error: " + e);
            return null;
        }
    }

    public static List<String> parseUnreadResult(String result) {
        ArrayList<String> unread = new ArrayList();
        try {
            unread = (List)JsonUtils.getGson().fromJson(result, new TypeToken<List<String>>(){}.getType());
            return unread;
        }
        catch (Exception e) {
            Logger.getLogger().e("ImSdk parse error: " + e);
            return unread;
        }
    }

    public static Map<String, Integer> parseReadResult(String result) {
        try {
            MssSuccessResult value = (MssSuccessResult)JsonUtils.getGson().fromJson(result, new TypeToken<MssSuccessResult<Map<String, Integer>>>(){}.getType());
            if (value != null) {
                Map getValue = (Map)value.getValue();
                return getValue;
            }
        }
        catch (Exception e) {
            Logger.getLogger().e("ImSdk parse error: " + e);
        }
        return null;
    }

    public static MssBatchResult parseBatchUpdateResult(String result) {
        if ("{}".equals(result)) {
            MssBatchResult mssResult = new MssBatchResult(0);
            return mssResult;
        }
        try {
            MssSuccessResult info = (MssSuccessResult)JsonUtils.getGson().fromJson(result, new TypeToken<List<MssBaseInfo>>(){}.getType());
            if (info != null) {
                List getValue = (List)info.getValue();
                MssBatchResult mssResult = new MssBatchResult(2);
                mssResult.setFailResult(getValue);
                return mssResult;
            }
        }
        catch (Exception e) {
            Logger.getLogger().i("ImSdk parse error: " + e);
        }
        return null;
    }
}

