/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.manager;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.xdja.imsdk.constant.internal.HttpApiConstant;
import com.xdja.imsdk.http.RequestInfo;
import com.xdja.imsdk.http.callback.IHttpCallback;
import com.xdja.imsdk.http.callback.IPostCallback;
import com.xdja.imsdk.http.config.ImRequestConfig;
import com.xdja.imsdk.http.file.FileEntry;
import com.xdja.imsdk.http.file.callback.IFileDownloadCallback;
import com.xdja.imsdk.http.file.callback.IFileUploadCallback;
import com.xdja.imsdk.http.strategy.FileSystemStrategy;
import com.xdja.imsdk.http.strategy.FileSystemStrategyFactory;
import com.xdja.imsdk.logger.Logger;
import com.xdja.imsdk.manager.ImSdkConfigManager;
import com.xdja.imsdk.manager.callback.NetCallback;
import java.io.File;
import java.util.List;
import org.json.JSONObject;

public abstract class HttpManager {
    private FileSystemStrategy mFileSystemStrategy;
    @Nullable
    protected NetCallback mCallback;

    public void init(@NonNull Context context, @Nullable NetCallback callback) {
        this.mFileSystemStrategy = FileSystemStrategyFactory.createFileSystemStrategy();
        this.mCallback = callback;
        int keyStoreId = ImSdkConfigManager.getInstance().getKeyStore();
        String keyStorePassword = ImSdkConfigManager.getInstance().getCert();
        this.initClient(context, keyStoreId, keyStorePassword);
    }

    protected abstract void initClient(Context var1, int var2, String var3);

    public void sendImRequest(@NonNull JSONObject object, ImRequestConfig config, @NonNull IHttpCallback callback) {
        String baseUrl = ImSdkConfigManager.getInstance().getImServer();
        if (TextUtils.isEmpty((CharSequence)baseUrl)) {
            Logger.getLogger().e("Request url is null!!");
            callback.onFailed(50100, object);
            return;
        }
        this.doImRequest(object, config, callback);
    }

    protected abstract void doImRequest(JSONObject var1, ImRequestConfig var2, IHttpCallback var3);

    public abstract void postAsync(@NonNull RequestInfo var1, IPostCallback var2);

    public void uploadStart(FileEntry entry, IFileUploadCallback callback) {
        if (!this.checkImFileAvailable(entry)) {
            Logger.getLogger().e("File is not available!!");
            callback.uploadFileError(50034, entry);
            return;
        }
        Logger.getLogger().d("Start upload file: " + entry.getPath() + ", requestTag: " + entry.getId());
        this.mFileSystemStrategy.startUploadFile(this, entry, callback);
    }

    public abstract void uploadFile(FileEntry var1, IFileUploadCallback var2);

    public void uploadFilePause(@NonNull FileEntry entry) {
        try {
            String msgId = String.valueOf(entry.getId());
            if (TextUtils.isEmpty((CharSequence)msgId)) {
                return;
            }
            this.pauseFileUpload(msgId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected abstract void pauseFileUpload(String var1);

    public void uploadFileResume(@NonNull FileEntry entry, IFileUploadCallback callback) {
        try {
            String msgId = String.valueOf(entry.getId());
            if (TextUtils.isEmpty((CharSequence)msgId)) {
                return;
            }
            this.mFileSystemStrategy.resumeUploadFile(this, entry, callback);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void download(FileEntry entry, boolean isSupportRange, IFileDownloadCallback callback) {
        Logger.getLogger().d("ImSdk downloadFile start: " + entry);
        if (!this.checkDownFileParamsAvailable(entry)) {
            callback.downloadFileError(50034, entry);
            return;
        }
        String fileSavePath = entry.getEncryptPath();
        if (TextUtils.isEmpty((CharSequence)fileSavePath)) {
            Logger.getLogger().e("ERROR: File save path is null.");
            callback.downloadFileError(50034, entry);
            return;
        }
        this.mFileSystemStrategy.downloadFile(this, entry, isSupportRange, callback);
    }

    public void downloadStart(FileEntry entry, IFileDownloadCallback callback) {
        this.download(entry, false, callback);
    }

    public abstract void downloadFile(FileEntry var1, boolean var2, IFileDownloadCallback var3);

    public abstract void downloadFilePause(FileEntry var1);

    public void downloadFileResume(FileEntry entry, IFileDownloadCallback callback) {
        this.download(entry, true, callback);
    }

    public abstract void cancelRequest(Long var1);

    public void cancelRequest(List<Long> msgIds) {
        for (Long msgId : msgIds) {
            this.cancelRequest(msgId);
        }
    }

    public abstract void cancelAll();

    protected String getPostUrl(ImRequestConfig config) {
        String url = "";
        HttpApiConstant.IMRequestType type = config.getpType();
        switch (type) {
            case LOGIN: {
                url = ImSdkConfigManager.getInstance().getLoginUrl();
                break;
            }
            case LOGOUT: {
                url = ImSdkConfigManager.getInstance().getLogoutUrl();
                break;
            }
            case NORMAL: 
            case RECALL: 
            case REMIND: {
                url = ImSdkConfigManager.getInstance().getSendmsgUrl();
                break;
            }
            case PULL: {
                url = ImSdkConfigManager.getInstance().getGetmsgUrl();
                break;
            }
            case STATE: {
                url = ImSdkConfigManager.getInstance().getStateUrl();
                break;
            }
        }
        return url;
    }

    private boolean checkDownFileParamsAvailable(FileEntry entry) {
        if (entry == null) {
            Logger.getLogger().e("ERROR: File entry is null.");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)entry.getFid())) {
            Logger.getLogger().e("ERROR: File fid is null.");
            return false;
        }
        return true;
    }

    private boolean checkImFileAvailable(FileEntry entry) {
        if (entry == null || TextUtils.isEmpty((CharSequence)entry.getEncryptPath())) {
            Logger.getLogger().e("File params error!");
            return false;
        }
        File file = new File(entry.getEncryptPath());
        if (!file.exists()) {
            Logger.getLogger().e("File not exist!");
            return false;
        }
        return true;
    }
}

