/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.manager.msg;

import com.xdja.imsdk.http.bean.MsgBean;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class PullAccord {
    private int size = 0;
    private long startId = 0L;
    private long endId = -1L;
    private long maxId = 0L;
    private long lastId = 0L;
    private AtomicInteger pullPE = new AtomicInteger();
    private AtomicBoolean firstCanCallback = new AtomicBoolean();
    private List<MsgBean> firstCallbackList = new ArrayList<MsgBean>();

    public long getStartId() {
        return this.startId;
    }

    public void setStartId(long startId) {
        this.startId = startId;
    }

    public int getSize() {
        return this.computePullSize(this.getPE());
    }

    public void setSize(int size) {
        this.size = size;
    }

    public long getEndId() {
        return this.endId;
    }

    public void setEndId(long endId) {
        this.endId = endId;
    }

    public boolean needQueryEnd() {
        return this.endId < 0L && this.startId == 0L;
    }

    public boolean isFirstPull() {
        return this.endId == 0L;
    }

    public long getMaxId() {
        return this.maxId;
    }

    public void setMaxId(long maxId) {
        this.maxId = maxId;
    }

    public long getLastId() {
        return this.lastId;
    }

    public void setLastId(long lastId) {
        this.lastId = lastId;
    }

    public int getPE() {
        return this.pullPE.get();
    }

    public void peIncrement() {
        this.pullPE.incrementAndGet();
    }

    public void setPE(int pe) {
        this.pullPE.set(pe);
    }

    public void nextAccord(long lastId) {
        this.peIncrement();
        this.setLastId(lastId);
        this.setStartId(lastId);
    }

    public boolean firstCanCallback() {
        return this.firstCanCallback.get();
    }

    public void setFirstCanCallback(boolean can) {
        this.firstCanCallback.set(can);
    }

    public void addFirstList(List<MsgBean> messages) {
        this.firstCallbackList.addAll(messages);
    }

    public List<MsgBean> getFirstList() {
        return this.firstCallbackList;
    }

    public void clearFirstList() {
        this.firstCallbackList.clear();
    }

    private int computePullSize(int exponent) {
        int pullSize = (int)Math.pow(4.0, exponent);
        if (pullSize > 256) {
            pullSize = 256;
        }
        return pullSize;
    }

    public String toString() {
        return "PullAccord{size=" + this.size + ", startId=" + this.startId + ", endId=" + this.endId + ", maxId=" + this.maxId + ", lastId=" + this.lastId + ", pullPE=" + this.pullPE + ", firstCanCallback=" + this.firstCanCallback + ", firstCallbackList=" + this.firstCallbackList + '}';
    }
}

