/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.util;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.xdja.google.gson.Gson;
import com.xdja.google.gson.JsonSyntaxException;
import com.xdja.google.gson.reflect.TypeToken;
import com.xdja.imsdk.http.result.FileIdResult;
import com.xdja.imsdk.logger.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonUtils {
    private static Gson gson = new Gson();

    public static String getString(JSONObject jsonObject, String key) {
        String value = "";
        try {
            if (jsonObject.has(key)) {
                value = jsonObject.getString(key);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return value;
    }

    @Nullable
    public static String getString(String jsonString, String key) {
        try {
            return JsonUtils.getString(new JSONObject(jsonString), key);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getInt(JSONObject jsonObject, String key) {
        int value = 0;
        try {
            value = jsonObject.getInt(key);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return value;
    }

    public static long getLong(@NonNull JSONObject jsonObject, String key) {
        long value = 0L;
        try {
            value = jsonObject.getLong(key);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return value;
    }

    public static long getLong(String jsonString, String key) {
        try {
            return JsonUtils.getLong(new JSONObject(jsonString), key);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static Gson getGson() {
        return gson;
    }

    public static <T> T mapGson(String json, Class<T> cls) {
        if (TextUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        Object result = null;
        try {
            result = gson.fromJson(json.trim(), TypeToken.get(cls).getType());
        }
        catch (JsonSyntaxException e) {
            Logger.getLogger().e("im json exception " + json);
            return null;
        }
        return (T)result;
    }

    public static String parseFileId(String response) {
        if (TextUtils.isEmpty((CharSequence)response)) {
            return null;
        }
        try {
            FileIdResult result = (FileIdResult)JsonUtils.getGson().fromJson(response, new TypeToken<FileIdResult>(){}.getType());
            if (result != null) {
                return result.getFileid();
            }
        }
        catch (Exception e) {
            Logger.getLogger().e("ImSdk new file result exception!!! [" + response + "]");
        }
        return "";
    }
}

