/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.common.database.dao;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import com.xdja.im.common.database.DatabaseManager;
import com.xdja.im.common.database.bean.SettingDb;
import com.xdja.im.common.database.builder.SettingEntityBuilder;
import com.xdja.im.common.database.dao.AbstractDao;
import com.xdja.im.common.database.helper.UpdateArgs;

public class SettingEntityDao
extends AbstractDao<SettingDb> {
    private SettingEntityDao() {
    }

    public static SettingEntityDao getInstance() {
        return SingletonInstance.mInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingDb get() {
        SettingDb msgEntryDb = null;
        Cursor cursor = null;
        try {
            cursor = this.query(SettingEntityBuilder.querySql());
            if (cursor != null && cursor.moveToNext()) {
                msgEntryDb = this.readEntry(cursor, 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeCursor(cursor);
        }
        return msgEntryDb;
    }

    public long insert(SettingDb settingDb) {
        SQLiteDatabase db = this.getDatabase();
        if (db != null) {
            return this.insert(db, settingDb, SettingEntityBuilder.insertSql());
        }
        return -1L;
    }

    public void update(SettingDb settingDb) {
        UpdateArgs args = new UpdateArgs("t_setting");
        ContentValues values = new ContentValues();
        values.put("account", settingDb.getAccount());
        values.put("remindMode", Integer.valueOf(settingDb.getRemindType()));
        values.put("remindVoice", Integer.valueOf(settingDb.getRemindVoice()));
        values.put("remindVibrate", Integer.valueOf(settingDb.getRemindVibrate()));
        values.put("receiverMode", Integer.valueOf(settingDb.getReceiverMode()));
        values.put("disturbMode", Integer.valueOf(settingDb.getDisturbMode()));
        values.put("disturbStart", Long.valueOf(settingDb.getDisturbStart()));
        values.put("disturbEnd", Long.valueOf(settingDb.getDisturbEnd()));
        String[] whereClause = new String[]{"account"};
        String[] whereArgs = new String[]{settingDb.getAccount()};
        args.setValues(values);
        args.setWhereClause(whereClause);
        args.setWhereArgs(whereArgs);
        this.update(args);
    }

    @Override
    protected SettingDb readEntry(Cursor cursor, int offset) {
        SettingDb entity = new SettingDb(cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0)), cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1), cursor.isNull(offset + 2) ? null : Integer.valueOf(cursor.getInt(offset + 2)), cursor.isNull(offset + 3) ? null : Integer.valueOf(cursor.getInt(offset + 3)), cursor.isNull(offset + 4) ? null : Integer.valueOf(cursor.getInt(offset + 4)), cursor.isNull(offset + 5) ? null : Integer.valueOf(cursor.getInt(offset + 5)), cursor.isNull(offset + 6) ? null : Integer.valueOf(cursor.getInt(offset + 6)), cursor.isNull(offset + 7) ? null : Long.valueOf(cursor.getLong(offset + 7)), cursor.isNull(offset + 8) ? null : Long.valueOf(cursor.getLong(offset + 8)));
        return entity;
    }

    @Override
    public void bindValues(SQLiteStatement stmt, SettingDb entity) {
        Long disturbEnd;
        Long disturbStart;
        Integer disturbMode;
        Integer receiverMode;
        Integer remindVibrate;
        Integer remindVoice;
        Integer remindType;
        String account;
        stmt.clearBindings();
        Long id2 = entity.getId();
        if (id2 != null) {
            stmt.bindLong(1, id2.longValue());
        }
        if ((account = entity.getAccount()) != null) {
            stmt.bindString(2, account);
        }
        if ((remindType = Integer.valueOf(entity.getRemindType())) != null) {
            stmt.bindLong(3, (long)remindType.intValue());
        }
        if ((remindVoice = Integer.valueOf(entity.getRemindVoice())) != null) {
            stmt.bindLong(4, (long)remindVoice.intValue());
        }
        if ((remindVibrate = Integer.valueOf(entity.getRemindVibrate())) != null) {
            stmt.bindLong(5, (long)remindVibrate.intValue());
        }
        if ((receiverMode = Integer.valueOf(entity.getReceiverMode())) != null) {
            stmt.bindLong(6, (long)receiverMode.intValue());
        }
        if ((disturbMode = Integer.valueOf(entity.getDisturbMode())) != null) {
            stmt.bindLong(7, (long)disturbMode.intValue());
        }
        if ((disturbStart = Long.valueOf(entity.getDisturbStart())) != null) {
            stmt.bindLong(8, disturbStart.longValue());
        }
        if ((disturbEnd = Long.valueOf(entity.getDisturbEnd())) != null) {
            stmt.bindLong(9, disturbEnd.longValue());
        }
    }

    private SQLiteDatabase getDatabase() {
        SQLiteDatabase db = DatabaseManager.getInstance().getDatabase();
        if (db == null) {
            throw new IllegalAccessError("open database failed.");
        }
        return db;
    }

    private static class SingletonInstance {
        private static final SettingEntityDao mInstance = new SettingEntityDao();

        private SingletonInstance() {
        }
    }
}

