/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.common.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.Toast;
import com.xdja.im.base.di.scope.Scoped;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.UiKitOptions;
import javax.inject.Inject;

public class CommonTool {
    private static Resources resources;
    private static Toast toast;

    @Inject
    public CommonTool(@Scoped(value="application") Context context) {
        resources = context.getResources();
        toast = Toast.makeText((Context)context, (CharSequence)"", (int)1);
    }

    public static void showToast(String content) {
        try {
            if (toast == null) {
                toast = Toast.makeText((Context)ImUiKit.getInstance().getContext(), (CharSequence)"", (int)1);
            }
            toast.setText((CharSequence)content);
            toast.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void showToast(int resId) {
        try {
            if (toast == null) {
                toast = Toast.makeText((Context)ImUiKit.getInstance().getContext(), (CharSequence)"", (int)1);
            }
            toast.setText(resId);
            toast.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getString(int resId) {
        try {
            if (resources == null) {
                resources = ImUiKit.getInstance().getContext().getResources();
            }
            return resources.getString(resId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static Drawable getDrawable(int resId) {
        if (resources == null) {
            resources = ImUiKit.getInstance().getContext().getResources();
        }
        return resources.getDrawable(resId);
    }

    public static int dp2px(Context context, int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static boolean isChangeFontScale() {
        UiKitOptions options = ImUiKit.getInstance().getOptions();
        if (options != null) {
            return options.isChangeFontScale();
        }
        return false;
    }

    public static int getPlatformType() {
        return ImUiKit.getInstance().getComponent().configCache().getDevice().getPlatformType();
    }

    public static int getDeviceType() {
        return ImUiKit.getInstance().getComponent().configCache().getDevice().getDeviceType();
    }

    public static int getExtType() {
        return ImUiKit.getInstance().getComponent().configCache().getDevice().getExtType();
    }

    public static int getHasForward() {
        return ImUiKit.getInstance().getComponent().configCache().getDevice().getHasForward();
    }
}

