/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.common.utils;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.support.v4.content.FileProvider;
import android.text.TextUtils;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.file.MimeUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.io.File;

public class SystemHelper {
    public static void openFile(Activity activity, String filePath) {
        String type;
        String suffix = filePath.substring(filePath.lastIndexOf(".") + 1).toLowerCase();
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            CommonTool.showToast(R.string.im_uikit_file_not_exist);
            return;
        }
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        if (TextUtils.isEmpty((CharSequence)suffix)) {
            type = "*/*";
        } else {
            type = MimeUtils.getMimeTypeWithExtension(suffix.toLowerCase());
            if (TextUtils.isEmpty((CharSequence)type)) {
                type = "*/*";
            }
        }
        if (!TextUtils.isEmpty((CharSequence)type) && !"*/*".equals(type)) {
            try {
                if (Build.VERSION.SDK_INT >= 24) {
                    Uri uri = FileProvider.getUriForFile((Context)activity, (String)(activity.getPackageName() + ".provider"), (File)new File(filePath));
                    intent.setDataAndType(uri, type);
                    intent.setFlags(3);
                } else {
                    intent.setDataAndType(Uri.fromFile((File)new File(filePath)), type);
                    intent.setFlags(0x10000000);
                }
                activity.startActivity(intent);
            }
            catch (ActivityNotFoundException e) {
                LogUtil.e("ERROR: Open file failed . " + e.getMessage());
                CommonTool.showToast(R.string.im_uikit_history_file_none_tool);
            }
            catch (Exception e) {
                LogUtil.e("ERROR: Open file failed . " + e.getMessage());
                CommonTool.showToast(R.string.im_uikit_file_open_failed);
            }
        } else if ("*/*".equals(type)) {
            LogUtil.w("ERROR:No tool operate this file. " + filePath);
            CommonTool.showToast(R.string.im_uikit_history_file_none_tool);
        }
    }
}

