/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.common.utils.compressor;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ImageUtil {
    public Bitmap getBitmap(String imgPath) {
        BitmapFactory.Options newOpts = new BitmapFactory.Options();
        newOpts.inJustDecodeBounds = false;
        newOpts.inPurgeable = true;
        newOpts.inInputShareable = true;
        newOpts.inSampleSize = 1;
        newOpts.inPreferredConfig = Bitmap.Config.RGB_565;
        return BitmapFactory.decodeFile((String)imgPath, (BitmapFactory.Options)newOpts);
    }

    public void storeImage(Bitmap bitmap, String outPath) throws FileNotFoundException {
    }

    public static Bitmap ratio(String imgPath, float pixelW, float pixelH) {
        BitmapFactory.Options newOpts = new BitmapFactory.Options();
        newOpts.inJustDecodeBounds = true;
        newOpts.inPreferredConfig = Bitmap.Config.RGB_565;
        Bitmap bitmap = BitmapFactory.decodeFile((String)imgPath, (BitmapFactory.Options)newOpts);
        newOpts.inJustDecodeBounds = false;
        int w = newOpts.outWidth;
        int h = newOpts.outHeight;
        float hh = pixelH;
        float ww = pixelW;
        int be = 1;
        if (w > h && (float)w > ww) {
            be = (int)((float)newOpts.outWidth / ww);
        } else if (w < h && (float)h > hh) {
            be = (int)((float)newOpts.outHeight / hh);
        }
        if (be <= 0) {
            be = 1;
        }
        newOpts.inSampleSize = be;
        bitmap = BitmapFactory.decodeFile((String)imgPath, (BitmapFactory.Options)newOpts);
        return bitmap;
    }

    public Bitmap ratio(Bitmap image, float pixelW, float pixelH) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        image.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)os);
        if (os.toByteArray().length / 1024 > 1024) {
            os.reset();
            image.compress(Bitmap.CompressFormat.JPEG, 50, (OutputStream)os);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        BitmapFactory.Options newOpts = new BitmapFactory.Options();
        newOpts.inJustDecodeBounds = true;
        newOpts.inPreferredConfig = Bitmap.Config.RGB_565;
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)newOpts);
        newOpts.inJustDecodeBounds = false;
        int w = newOpts.outWidth;
        int h = newOpts.outHeight;
        float hh = pixelH;
        float ww = pixelW;
        int be = 1;
        if (w > h && (float)w > ww) {
            be = (int)((float)newOpts.outWidth / ww);
        } else if (w < h && (float)h > hh) {
            be = (int)((float)newOpts.outHeight / hh);
        }
        if (be <= 0) {
            be = 1;
        }
        newOpts.inSampleSize = be;
        is = new ByteArrayInputStream(os.toByteArray());
        bitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)newOpts);
        return bitmap;
    }

    public void compressAndGenImage(Bitmap image, String outPath, int maxSize) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int options = 100;
        image.compress(Bitmap.CompressFormat.JPEG, options, (OutputStream)os);
        while (os.toByteArray().length / 1024 > maxSize) {
            os.reset();
            image.compress(Bitmap.CompressFormat.JPEG, options -= 10, (OutputStream)os);
        }
        FileOutputStream fos = new FileOutputStream(outPath);
        fos.write(os.toByteArray());
        fos.flush();
        fos.close();
    }

    public void compressAndGenImage(String imgPath, String outPath, int maxSize, boolean needsDelete) throws IOException {
        File file;
        this.compressAndGenImage(this.getBitmap(imgPath), outPath, maxSize);
        if (needsDelete && (file = new File(imgPath)).exists()) {
            file.delete();
        }
    }

    public void ratioAndGenThumb(Bitmap image, String outPath, float pixelW, float pixelH) throws FileNotFoundException {
        Bitmap bitmap = this.ratio(image, pixelW, pixelH);
        this.storeImage(bitmap, outPath);
    }

    public void ratioAndGenThumb(String imgPath, String outPath, float pixelW, float pixelH, boolean needsDelete) throws FileNotFoundException {
        File file;
        Bitmap bitmap = ImageUtil.ratio(imgPath, pixelW, pixelH);
        this.storeImage(bitmap, outPath);
        if (needsDelete && (file = new File(imgPath)).exists()) {
            file.delete();
        }
    }
}

