/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.core.proxy;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.widget.Toast;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.common.database.dao.MeetInfoEntityDao;
import com.xdja.im.common.database.helper.MXSettingHelper;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.core.callback.ClearSessionDataCallback;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.event.IMProxyMessageEvent;
import com.xdja.im.core.model.event.IMProxySessionEvent;
import com.xdja.im.core.model.message.MeetInfo;
import com.xdja.im.core.model.message.TalkCustomBean;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkNotifyBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.param.SessionParam;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.core.proxy.ModuleProxy;
import com.xdja.im.core.service.KitService;
import com.xdja.im.core.utils.ToolUtils;
import com.xdja.im.lib.share.model.ShareBean;
import com.xdja.im.lib.share.util.ShareUtils;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.notification.NotificationUtil;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.util.ArrayList;
import java.util.List;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;

public class IMModuleProxyImpl
implements ModuleProxy {
    private IMModuleProxyImpl() {
    }

    public static IMModuleProxyImpl getInstance() {
        return SingletonInstance.mInstance;
    }

    @Override
    public void initIMProxy() {
        LogUtil.d("Start IM Kit service.");
        Context context = ImUiKit.getInstance().getContext();
        if (context == null) {
            LogUtil.e("Start Kit Service failed, context is null.");
            return;
        }
        try {
            Intent intent = new Intent();
            intent.setClass(context, KitService.class);
            intent.setAction("android.intent.action.RESPOND_VIA_MESSAGE");
            intent.setPackage(context.getPackageName());
            context.startService(intent);
        }
        catch (Exception e) {
            LogUtil.w("Start service failed.");
        }
    }

    @Override
    public void releaseProxy() {
        Context context = ImUiKit.getInstance().getContext();
        if (context == null) {
            LogUtil.e("Stop Kit Service failed, context is null.");
            return;
        }
        try {
            Intent intent = new Intent();
            intent.setClass(context, KitService.class);
            intent.setAction("android.intent.action.RESPOND_VIA_MESSAGE");
            intent.setPackage(context.getPackageName());
            context.stopService(intent);
        }
        catch (Exception e) {
            LogUtil.w("Stop service failed.");
        }
    }

    @Override
    public void sendNotifyMessage(String sessionId, int sessionType, TalkNotifyBean bean) {
        if (bean == null) {
            LogUtil.w("ERROR: talk notify bean is null.");
            return;
        }
        boolean isGroup = sessionType == 2;
        ImUiKit.getInstance().getComponent().proxyRepository().sendNotifyTextMessage(bean.getContent(), bean.getTo(), isGroup, new Subscriber<TalkMessageBean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("ERROR: Send notify message failed. " + e.getMessage());
            }

            public void onNext(TalkMessageBean talkMessageBean) {
                LogUtil.d("Send notify message successfully.");
                IMProxyMessageEvent.ReceiveNewMessageEvent event = new IMProxyMessageEvent.ReceiveNewMessageEvent();
                ArrayList<TalkMessageBean> list = new ArrayList<TalkMessageBean>();
                list.add(talkMessageBean);
                event.setTalkMessageList(list);
                event.setMsgAccount(talkMessageBean.getTo());
                BusProvider.getInstance().post(event);
            }
        });
    }

    @Override
    public void sendCustomTextMessage(String sessionId, int sessionType, TalkCustomBean bean) {
        if (bean == null) {
            LogUtil.w("ERROR: Send custom message failed, bean is null.");
            return;
        }
        boolean isGroup = sessionType == 2;
        TalkMessageBean talkMessageBean = new TalkMessageBean();
        talkMessageBean.setTo(sessionId);
        talkMessageBean.setGroupMsg(isGroup);
        talkMessageBean.setMessageType(101);
        talkMessageBean.setContent(bean.getContent());
        ImUiKit.getInstance().getComponent().proxyRepository().sendCustomMessage(talkMessageBean, new Subscriber<TalkMessageBean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("ERROR: Send custom message failed, " + e.getMessage());
            }

            public void onNext(TalkMessageBean talkMessageBean) {
                LogUtil.d("Send custom message successfully.");
            }
        });
    }

    private void clearSessionParamData(String sessionFlag) {
        ImUiKit.getInstance().getComponent().diskDataStore().deleteSessionParam(sessionFlag, new Subscriber<Boolean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("ERROR: Clear session data failed." + e.getMessage());
            }

            public void onNext(Boolean aBoolean) {
                IMProxyMessageEvent.RefreshMessageListEvent event = new IMProxyMessageEvent.RefreshMessageListEvent();
                event.setNeedClearInput(true);
                BusProvider.getInstance().post(event);
            }
        });
    }

    private void clearAllSessionParamsData() {
        ImUiKit.getInstance().getComponent().diskDataStore().deleteAllSessionParams(new Subscriber<Boolean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("ERROR: Clear all session data failed." + e.getMessage());
            }

            public void onNext(Boolean aBoolean) {
                IMProxySessionEvent.RefreshSessionListEvent event = new IMProxySessionEvent.RefreshSessionListEvent();
                BusProvider.getInstance().post(event);
            }
        });
    }

    @Override
    public void clearSessionData(final String sessionId, int chatType) {
        if (TextUtils.isEmpty((CharSequence)sessionId)) {
            LogUtil.e("Session id is null error.");
            return;
        }
        if (ImUiKit.getInstance().getComponent() == null && ImUiKit.getInstance().getComponent().proxyRepository() == null) {
            LogUtil.e("getComponent is null error.");
            return;
        }
        final String sessionFlag = ToolUtils.getSessionTag(sessionId, chatType);
        ImUiKit.getInstance().getComponent().proxyRepository().clearAllSessionData(sessionFlag, new Subscriber<Integer>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("ERROR: Clear message list failed." + e.getMessage());
            }

            public void onNext(Integer integer) {
                IMProxySessionEvent.ClearUnReadMsgEvent event = new IMProxySessionEvent.ClearUnReadMsgEvent();
                event.setTalkId(sessionId);
                BusProvider.getInstance().post(event);
                IMModuleProxyImpl.this.clearSessionParamData(sessionFlag);
                Toast.makeText((Context)ImUiKit.getInstance().getContext(), (CharSequence)"\u804a\u5929\u8bb0\u5f55\u6e05\u9664\u6210\u529f", (int)1).show();
            }
        });
    }

    @Override
    public void clearSessionData(final String sessionId, int chatType, final ClearSessionDataCallback callback) {
        if (TextUtils.isEmpty((CharSequence)sessionId)) {
            LogUtil.e("Session id is null error.");
            return;
        }
        if (ImUiKit.getInstance().getComponent() == null && ImUiKit.getInstance().getComponent().proxyRepository() == null) {
            LogUtil.e("getComponent is null error.");
            return;
        }
        final String sessionFlag = ToolUtils.getSessionTag(sessionId, chatType);
        ImUiKit.getInstance().getComponent().proxyRepository().clearAllSessionData(sessionFlag, new Subscriber<Integer>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("ERROR: Clear message list failed." + e.getMessage());
                callback.clearSessionDataFail();
            }

            public void onNext(Integer integer) {
                IMProxySessionEvent.ClearUnReadMsgEvent event = new IMProxySessionEvent.ClearUnReadMsgEvent();
                event.setTalkId(sessionId);
                BusProvider.getInstance().post(event);
                IMModuleProxyImpl.this.clearSessionParamData(sessionFlag);
                callback.clearSessionDataSuccess();
            }
        });
    }

    @Override
    public void clearAllSessionData() {
        ImUiKit.getInstance().getComponent().proxyRepository().clearAllData(new Subscriber<Integer>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("ERROR: Clear all message failed." + e.getMessage());
            }

            public void onNext(Integer integer) {
                IMProxySessionEvent.DeleteSessionEvent event = new IMProxySessionEvent.DeleteSessionEvent();
                BusProvider.getInstance().post(event);
                IMModuleProxyImpl.this.clearAllSessionParamsData();
            }
        });
    }

    @Override
    public void clearCacheData() {
        ImUiKit.getInstance().getComponent().proxyRepository().clearAllCacheData(new Subscriber<Integer>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("ERROR: Clear all message failed." + e.getMessage());
            }

            public void onNext(Integer integer) {
            }
        });
    }

    @Override
    public void setNoDisturbMode(String sessionId, int sessionType, final boolean isDisturb) {
        if (TextUtils.isEmpty((CharSequence)sessionId)) {
            LogUtil.e("Session id is null error.");
            return;
        }
        final String sessionFlag = ToolUtils.getSessionTag(sessionId, sessionType);
        if (isDisturb) {
            ImUiKit.getInstance().getComponent().cloudDataStore().saveNoDisturb2Cloud(sessionFlag, sessionId, sessionType, new Subscriber<Boolean>(){

                public void onCompleted() {
                }

                public void onError(Throwable e) {
                }

                public void onNext(Boolean aBoolean) {
                    if (aBoolean.booleanValue()) {
                        IMModuleProxyImpl.this.setLocalNoDisturbMode(sessionFlag, isDisturb);
                    }
                }
            });
        } else {
            ImUiKit.getInstance().getComponent().cloudDataStore().deleteNoDisturbAtCloud(sessionFlag, sessionId, sessionType, new Subscriber<Boolean>(){

                public void onCompleted() {
                }

                public void onError(Throwable e) {
                }

                public void onNext(Boolean aBoolean) {
                    if (aBoolean.booleanValue()) {
                        IMModuleProxyImpl.this.setLocalNoDisturbMode(sessionFlag, isDisturb);
                    }
                }
            });
        }
    }

    private void setLocalNoDisturbMode(String sessionFlag, boolean isDisturb) {
        ImUiKit.getInstance().getComponent().diskDataStore().setSessionDisturb(sessionFlag, isDisturb, new Subscriber<Boolean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("ERROR: Set disturb failed." + e.getMessage());
            }

            public void onNext(Boolean aBoolean) {
                IMProxySessionEvent.RefreshSessionListEvent event = new IMProxySessionEvent.RefreshSessionListEvent();
                BusProvider.getInstance().post(event);
            }
        });
    }

    @Override
    public void setSessionTop(String sessionId, int sessionType, final boolean isTop) {
        if (TextUtils.isEmpty((CharSequence)sessionId)) {
            LogUtil.e("Session id is null error.");
            return;
        }
        final String sessionFlag = ToolUtils.getSessionTag(sessionId, sessionType);
        if (isTop) {
            ImUiKit.getInstance().getComponent().cloudDataStore().setCloudSessionTop(sessionFlag, new Subscriber<Boolean>(){

                public void onCompleted() {
                }

                public void onError(Throwable e) {
                    LogUtil.e("ERROR: set session top error." + e.getMessage());
                }

                public void onNext(Boolean aBoolean) {
                    IMModuleProxyImpl.this.setLocalTopState(aBoolean, sessionFlag, isTop);
                }
            });
        } else {
            ImUiKit.getInstance().getComponent().cloudDataStore().deleteSettingTopAtCloud(sessionFlag, new Subscriber<Boolean>(){

                public void onCompleted() {
                }

                public void onError(Throwable e) {
                }

                public void onNext(Boolean aBoolean) {
                    IMModuleProxyImpl.this.setLocalTopState(aBoolean, sessionFlag, isTop);
                }
            });
        }
    }

    private void setLocalTopState(boolean aBoolean, String sessionFlag, boolean isTop) {
        if (aBoolean) {
            ImUiKit.getInstance().getComponent().diskDataStore().setSessionTop(sessionFlag, isTop, new Subscriber<Boolean>(){

                public void onCompleted() {
                }

                public void onError(Throwable e) {
                    LogUtil.e("ERROR: Set session top failed." + e.getMessage());
                }

                public void onNext(Boolean aBoolean) {
                    IMProxySessionEvent.RefreshSessionListEvent event = new IMProxySessionEvent.RefreshSessionListEvent();
                    BusProvider.getInstance().post(event);
                }
            });
        }
    }

    @Override
    public void setReceiveMode(String sessionId, int sessionType, boolean isOpen) {
        if (TextUtils.isEmpty((CharSequence)sessionId)) {
            LogUtil.e("Session id is null error.");
            return;
        }
        String sessionFlag = ToolUtils.getSessionTag(sessionId, sessionType);
        ImUiKit.getInstance().getComponent().diskDataStore().setReceiveMode(sessionFlag, isOpen, new Subscriber<Boolean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("ERROR: Set receive mode failed." + e.getMessage());
            }

            public void onNext(Boolean aBoolean) {
                LogUtil.d("Set receive mode successfully.");
            }
        });
    }

    @Override
    public SessionParam getSessionParam(String sessionId, int sessionType) {
        String sessionFlag = ToolUtils.getSessionTag(sessionId, sessionType);
        return MXSettingHelper.getSessionParam(sessionFlag);
    }

    @Override
    public void notify(final TalkSessionBean sessionBean, final int newMsgCnt, final boolean isDisturb, final List<TalkMessageBean> messageBeanList) {
        IMUiKitProxyImpl.getInstance().getAccount(sessionBean.getTalkerAccount(), sessionBean.getTalkType(), new Subscriber<AccountBean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("ERROR: Notify get account failed.");
            }

            public void onNext(AccountBean accountBean) {
                String account = sessionBean.getTalkerAccount();
                String talkId = sessionBean.getTalkFlag();
                String imgUrl = accountBean.getAvatarUrl();
                String userName = accountBean.getDisplayName();
                int talkType = sessionBean.getTalkType();
                int msgCount = newMsgCnt;
                NotificationUtil.getInstance().remindMessage(account, imgUrl, userName, talkId, talkType, msgCount, sessionBean.getLastTime(), isDisturb, messageBeanList);
            }
        });
    }

    @Override
    public void notifyMeet(MeetInfo meetInfo) {
        Observable.just((Object)meetInfo).map((Func1)new Func1<MeetInfo, MeetInfo>(){

            public MeetInfo call(MeetInfo meetInfo) {
                MeetInfo meetInfo1 = MeetInfoEntityDao.getInstance().get(meetInfo.getTaklFlag());
                if (meetInfo1 != null) {
                    MeetInfoEntityDao.getInstance().update(meetInfo);
                } else {
                    MeetInfoEntityDao.getInstance().insert(meetInfo);
                }
                LogUtil.d("imuikit notifyMeet call:", meetInfo.toString());
                return meetInfo;
            }
        }).subscribe((Subscriber)new Subscriber<MeetInfo>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                e.printStackTrace();
                LogUtil.d("imuikit notifyMeet onError:", e.toString());
            }

            public void onNext(MeetInfo meetInfo) {
                IMProxyMessageEvent.ChatMeetRefreshStateHintEvent event = new IMProxyMessageEvent.ChatMeetRefreshStateHintEvent();
                event.setMeetInfo(meetInfo);
                BusProvider.getInstance().post(event);
                LogUtil.d("imuikit notifyMeet onNext:", meetInfo.toString());
            }
        });
    }

    @Override
    public void sendShareInfo(int type, List<ShareBean> list) {
        IMProxyMessageEvent.ShareContactRefreshEvent event = new IMProxyMessageEvent.ShareContactRefreshEvent();
        event.setType(type);
        event.setList(list);
        BusProvider.getInstance().post(event);
    }

    @Override
    public void forwardThirdContent(Activity activity, String content) {
        TalkMessageBean talkMessageBean = new TalkMessageBean();
        talkMessageBean.setContent(content);
        talkMessageBean.setMessageType(201);
        Intent intent = ShareUtils.buildForwardIntent(activity, talkMessageBean);
        if (intent == null) {
            Toast.makeText((Context)activity, (CharSequence)"\u8bf7\u5148\u6253\u5f00\u6216\u4e0b\u8f7d\u6587\u4ef6", (int)0).show();
        } else {
            activity.startActivity(intent);
        }
    }

    @Override
    public void deleteThirdContent(final TalkMessageBean messageBean) {
        if (messageBean != null) {
            final long id2 = messageBean.getId();
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(id2);
            ImUiKit.getInstance().getComponent().proxyRepository().deleteMessages(ids, new Subscriber<Integer>(){

                public void onCompleted() {
                }

                public void onError(Throwable e) {
                    LogUtil.e("Delete message error, " + e.getMessage());
                    CommonTool.showToast(R.string.im_uikit_delete_msg_failed);
                }

                public void onNext(Integer integer) {
                    LogUtil.d("Delete message id " + id2 + ", result:" + integer);
                    IMModuleProxyImpl.this.postDeleteMessageEvent(messageBean);
                }
            });
        }
    }

    private int postDeleteMessageEvent(TalkMessageBean talkMessageBean) {
        try {
            IMProxyMessageEvent.DeleteMessageEvent messageEvent = new IMProxyMessageEvent.DeleteMessageEvent();
            messageEvent.setMsgAccount(talkMessageBean.getFrom());
            messageEvent.setTalkMessageBean(talkMessageBean);
            BusProvider.getInstance().post(messageEvent);
            return 1;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private static class SingletonInstance {
        private static final IMModuleProxyImpl mInstance = new IMModuleProxyImpl();

        private SingletonInstance() {
        }
    }
}

