/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.core.push;

import android.content.Context;
import com.xdja.im.core.push.PushController;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.pushsdk.PushClient;
import java.util.ArrayList;

public class PushControllerImp
implements PushController {
    public static final String TOPIC_IM = "/im";
    public static String clientId;
    public static String subTopic;
    private ArrayList<String> mTopics;

    private PushControllerImp() {
    }

    public static PushControllerImp getInstance() {
        return SingletonInstance.mInstance;
    }

    @Override
    public boolean startPush(String appId, String userId, String key) {
        Context context = ImUiKit.getInstance().getContext();
        if (context == null) {
            LogUtil.e("ERROR: client id is null." + clientId);
            return false;
        }
        subTopic = appId + "/" + userId + TOPIC_IM;
        LogUtil.d("subTopic:" + subTopic);
        int result = PushClient.init((Context)context, (String)appId, (String)userId, (String)key);
        this.subTopics(context);
        return result == 0;
    }

    @Override
    public boolean releasePush() {
        LogUtil.d("releaseProxy push...");
        Context context = ImUiKit.getInstance().getContext();
        if (context == null) {
            LogUtil.e("Release push failed. context is null.");
            return false;
        }
        PushClient.unsubscribe((Context)context, this.mTopics);
        int release = PushClient.release((Context)context);
        return release == 0;
    }

    private void subTopics(Context context) {
        this.mTopics = new ArrayList();
        this.mTopics.add(subTopic);
        PushClient.subTopic((Context)context, this.mTopics);
    }

    private static class SingletonInstance {
        private static final PushControllerImp mInstance = new PushControllerImp();

        private SingletonInstance() {
        }
    }
}

