/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.core.repository.impl;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.widget.ListAdapter;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.common.cache.interf.UserCache;
import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.common.utils.PermissionUtils;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.account.AccountDesc;
import com.xdja.im.core.model.event.IMProxySessionEvent;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.core.model.message.file.NormalFileInfo;
import com.xdja.im.core.model.message.file.VoiceFileInfo;
import com.xdja.im.core.model.param.SessionParam;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.core.repository.interf.ChatListCallBack;
import com.xdja.im.core.repository.interf.ProxyRepository;
import com.xdja.im.core.repository.interf.datasource.DiskDataStore;
import com.xdja.im.lib.action.bean.OptionBean;
import com.xdja.im.lib.action.uitls.OptionParser;
import com.xdja.im.lib.album.bean.ImageThumbBean;
import com.xdja.im.lib.camera.bean.PhotoThumbBean;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.filemanage.util.ActomaController;
import com.xdja.im.lib.filemanage.util.DateUtils;
import com.xdja.im.lib.filemanage.util.IMFileUtils;
import com.xdja.im.lib.filemanage.util.ToolUtil;
import com.xdja.im.lib.video.bean.VideoItem;
import com.xdja.im.uikit.notification.NotificationUtil;
import com.xdja.im.uikit.ui.adapter.ChatListAdapter;
import com.xdja.im.uikit.ui.presenter.ChatListPresenter;
import com.xdja.im.uikit.ui.view.vu.ChatListVu;
import com.xdja.im.uikit.utils.AtAccountNickMap;
import com.xdja.im.uikit.utils.AtPreferencesUtils;
import com.xdja.im.uikit.utils.DataConvertUtils;
import com.xdja.im.uikit.utils.ObjectUtil;
import com.xdja.im.uikit.utils.file.TranslateInfoUtil;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public class ChatListCallBackImpl
implements ChatListCallBack {
    private String mTalkId;
    private int mTalkType;
    private static final int PAGE_SIZE = 15;
    private boolean isLimit = false;
    private boolean isHasDraft;
    private List<TalkMessageBean> mMessageList = new ArrayList<TalkMessageBean>();
    private ChatListAdapter mAdapter;
    private int[] mCancelBottomPopMenuIdArray;
    private ChatListVu vu;
    private ChatListPresenter presenter;
    private ProxyRepository proxyRepository;
    private DiskDataStore diskDataStore;
    private UserCache userCache;
    private int number = 0;
    private TalkMessageBean firstNewMessage;
    private MyHandler mHandler;

    @Inject
    public ChatListCallBackImpl(ProxyRepository proxyRepository, DiskDataStore diskDataStore, UserCache userCache) {
        this.proxyRepository = proxyRepository;
        this.diskDataStore = diskDataStore;
        this.userCache = userCache;
    }

    @Override
    public String getTalkId() {
        return this.mTalkId;
    }

    @Override
    public int getTalkType() {
        return this.mTalkType;
    }

    @Override
    public List<TalkMessageBean> getListTalkMessageBean() {
        return this.mMessageList;
    }

    @Override
    public int[] getCancelBottomPopMenuIdArray() {
        return this.mCancelBottomPopMenuIdArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initChatPram(Bundle arguments, ChatListVu vu, ChatListPresenter presenter) {
        this.vu = vu;
        this.presenter = presenter;
        if (arguments != null) {
            try {
                this.mCancelBottomPopMenuIdArray = arguments.getIntArray("cancel_bottom_pop_menu_id_array");
                this.mHandler = new MyHandler(presenter.getActivity());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.firstNewMessage = null;
                this.number = 0;
                this.mTalkId = arguments.getString("talkerId");
                this.mTalkType = arguments.getInt("talkType", 1);
            }
        }
    }

    @Override
    public void setTitle() {
        this.vu.setToolBarAddVisibility(0);
        this.vu.setToolBarVisibility(0);
        if (this.mTalkType == 1) {
            IMUiKitProxyImpl.getInstance().getAccount(this.mTalkId, 1, new Subscriber<AccountBean>(){

                public void onCompleted() {
                }

                public void onError(Throwable e) {
                }

                public void onNext(AccountBean accountBean) {
                    ChatListCallBackImpl.this.vu.setTitle(accountBean.getDisplayName());
                    ChatListCallBackImpl.this.vu.setToolBarAddVisibility(0);
                }
            });
        } else {
            IMUiKitProxyImpl.getInstance().getAccount(this.mTalkId, 2, new Subscriber<AccountBean>(){

                public void onCompleted() {
                }

                public void onError(Throwable e) {
                }

                public void onNext(AccountBean accountBean) {
                    String displayName = accountBean.getDisplayName();
                    AccountDesc accountDesc = accountBean.getAccountDesc();
                    if (accountDesc != null && accountDesc.getMemberNum() > 0) {
                        displayName = displayName + " (" + accountDesc.getMemberNum() + ")";
                        ChatListCallBackImpl.this.vu.setToolBarAddVisibility(0);
                    } else {
                        ChatListCallBackImpl.this.vu.setToolBarAddVisibility(4);
                    }
                    ChatListCallBackImpl.this.vu.setTitle(displayName);
                }
            });
        }
    }

    @Override
    @TargetApi(value=16)
    public void requestPermissions(Activity context) {
        if (!PermissionUtils.hasSelfPermissions((Context)context, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE")) {
            PermissionUtils.requestPermissions(context, new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"}, 1);
        }
    }

    @Override
    public ChatListAdapter buildAdapter() {
        if (this.mAdapter == null) {
            this.mAdapter = new ChatListAdapter(this.presenter, this.mMessageList, this.vu.getListView(), this.proxyRepository);
            this.vu.getListView().setAdapter((ListAdapter)this.mAdapter);
        }
        return this.mAdapter;
    }

    @Override
    public void notifyDataSetChanged() {
        try {
            if (this.mAdapter == null) {
                this.buildAdapter();
            }
            this.mAdapter.notifyDataSetChanged();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getAccount() {
        return this.userCache.get().getAccount();
    }

    @Override
    public void clearAdapter() {
        if (this.mAdapter != null) {
            this.mAdapter = null;
        }
        if (this.mMessageList != null && this.mMessageList.size() > 0) {
            this.mMessageList.clear();
        }
    }

    @Override
    public void getUnReadMsg() {
        LogUtil.d("getUnReadMsg_time:" + System.currentTimeMillis());
        this.proxyRepository.getUnReadMsgCount(this.getTalkFlag(), new Subscriber<Integer>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                e.printStackTrace();
            }

            public void onNext(Integer integer) {
                LogUtil.d("getUnReadMsg_onNext:" + System.currentTimeMillis());
                ChatListCallBackImpl.this.number = integer;
                ChatListCallBackImpl.this.ifShowUnReadBtn();
            }
        });
        this.loadFirstNewMessage();
        this.loadMessageList(0L);
    }

    private void loadFirstNewMessage() {
        LogUtil.d("loadFirstNewMessage_time:" + System.currentTimeMillis());
        this.proxyRepository.getNoReadFirstNewMessage(this.getTalkFlag()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<TalkMessageBean>(){

            public void onCompleted() {
                ChatListCallBackImpl.this.clearUnReadMsgCount();
            }

            public void onError(Throwable e) {
                e.printStackTrace();
            }

            public void onNext(TalkMessageBean talkMessageBean) {
                LogUtil.d("loadFirstNewMessage_onNext:" + System.currentTimeMillis());
                ChatListCallBackImpl.this.firstNewMessage = talkMessageBean;
                ChatListCallBackImpl.this.ifShowUnReadBtn();
            }
        });
    }

    @Override
    public void loadMessageList(final long msgId) {
        LogUtil.d("Start load message msgId " + msgId);
        LogUtil.d("loadMessageList(final long msgId)_time:" + System.currentTimeMillis());
        this.proxyRepository.getMessageList(this.mTalkId, this.mTalkType, msgId, 15, new Subscriber<List<TalkMessageBean>>(){

            public void onCompleted() {
                if (ChatListCallBackImpl.this.vu.isRefreshing()) {
                    ChatListCallBackImpl.this.vu.stopRefresh();
                }
            }

            public void onError(Throwable e) {
                LogUtil.e("load message error:" + e.getMessage());
                ChatListCallBackImpl.this.buildAdapter().notifyDataSetChanged();
                if (ChatListCallBackImpl.this.vu.isRefreshing()) {
                    ChatListCallBackImpl.this.vu.stopRefresh();
                }
            }

            public void onNext(List<TalkMessageBean> talkMessageList) {
                if (talkMessageList == null) {
                    return;
                }
                LogUtil.d(talkMessageList.toString());
                if (msgId == 0L) {
                    ChatListCallBackImpl.this.mMessageList.clear();
                }
                if (talkMessageList.size() > 0) {
                    ChatListCallBackImpl.this.mMessageList.addAll(0, talkMessageList);
                }
                ChatListCallBackImpl.this.buildAdapter().notifyDataSetChanged();
                LogUtil.d("Load message is refreshing " + ChatListCallBackImpl.this.vu.isRefreshing());
                if (ChatListCallBackImpl.this.vu.isRefreshing()) {
                    if (talkMessageList.size() > 0) {
                        ChatListCallBackImpl.this.vu.setListSelection(talkMessageList.size() - 1);
                    }
                } else {
                    if (ChatListCallBackImpl.this.mMessageList.size() > 0) {
                        ChatListCallBackImpl.this.vu.setListSelection(ChatListCallBackImpl.this.mMessageList.size() - 1);
                    }
                    ChatListCallBackImpl.this.vu.restoreActionState();
                }
                LogUtil.d("loadMessageList(final long msgId)_onNext:" + System.currentTimeMillis());
                ChatListCallBackImpl.this.ifShowUnReadBtn();
            }
        });
    }

    @Override
    public void loadMessageList(final long msgId, int PAGE_SIZE) {
        LogUtil.d("loadMessageList_time:" + System.currentTimeMillis());
        this.proxyRepository.getMessageList(this.mTalkId, this.mTalkType, msgId, PAGE_SIZE, new Subscriber<List<TalkMessageBean>>(){

            public void onCompleted() {
                if (ChatListCallBackImpl.this.vu.isRefreshing()) {
                    ChatListCallBackImpl.this.vu.stopRefresh();
                }
            }

            public void onError(Throwable e) {
                LogUtil.e("load message error:" + e.getMessage());
                ChatListCallBackImpl.this.buildAdapter().notifyDataSetChanged();
                if (ChatListCallBackImpl.this.vu.isRefreshing()) {
                    ChatListCallBackImpl.this.vu.stopRefresh();
                }
            }

            public void onNext(List<TalkMessageBean> talkMessageList) {
                if (talkMessageList == null) {
                    return;
                }
                LogUtil.d(talkMessageList.toString());
                if (msgId == 0L) {
                    ChatListCallBackImpl.this.mMessageList.clear();
                }
                if (talkMessageList.size() > 0) {
                    ChatListCallBackImpl.this.mMessageList.addAll(0, talkMessageList);
                }
                ChatListCallBackImpl.this.buildAdapter().notifyDataSetChanged();
                LogUtil.d("Load message is refreshing " + ChatListCallBackImpl.this.vu.isRefreshing());
                if (ChatListCallBackImpl.this.vu.isRefreshing()) {
                    if (talkMessageList.size() > 0) {
                        ChatListCallBackImpl.this.vu.setListSelection(talkMessageList.size() - 1);
                    }
                } else {
                    if (ChatListCallBackImpl.this.mMessageList.size() > 0) {
                        ChatListCallBackImpl.this.vu.setListSelection(ChatListCallBackImpl.this.mMessageList.size() - 1);
                    }
                    ChatListCallBackImpl.this.vu.restoreActionState();
                }
                LogUtil.d("loadMessageList_onNext:" + System.currentTimeMillis());
                ChatListCallBackImpl.this.ifShowUnReadBtn();
            }
        });
    }

    private synchronized void ifShowUnReadBtn() {
        if (this.firstNewMessage != null && this.number > 0 && this.mMessageList.size() > 0) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    int indexFirst = ChatListCallBackImpl.this.vu.getListView().getFirstVisiblePosition();
                    int indexLast = ChatListCallBackImpl.this.vu.getListView().getLastVisiblePosition();
                    int messageIndex = 0;
                    messageIndex = ChatListCallBackImpl.this.mMessageList.contains(ChatListCallBackImpl.this.firstNewMessage) ? ChatListCallBackImpl.this.mMessageList.indexOf(ChatListCallBackImpl.this.firstNewMessage) : -1;
                    if (messageIndex < indexFirst || messageIndex == -1 || messageIndex > indexLast) {
                        if (ChatListCallBackImpl.this.number > 0) {
                            ChatListCallBackImpl.this.vu.addButtonView(ChatListCallBackImpl.this.number);
                        } else {
                            ChatListCallBackImpl.this.vu.removeButtonView();
                        }
                    } else {
                        ChatListCallBackImpl.this.vu.removeButtonView();
                    }
                }
            }, 500L);
        }
    }

    @Override
    public void downRefreshList() {
        long msgId = 0L;
        if (!this.mMessageList.isEmpty()) {
            msgId = this.mMessageList.get(0).getId();
        }
        this.firstNewMessage = null;
        this.number = 0;
        LogUtil.d("do refresh, msgId :" + msgId);
        this.loadMessageList(msgId);
    }

    @Override
    public void startLoadOptions(final Context context) {
        Observable.just((Object)"").subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<String, Observable<OptionBean>>(){

            public Observable<OptionBean> call(String s) {
                try {
                    List<OptionBean> options = OptionParser.getOptions(context);
                    return Observable.from(options);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return Observable.error((Throwable)e);
                }
            }
        }).filter((Func1)new Func1<OptionBean, Boolean>(){

            public Boolean call(OptionBean optionBean) {
                if (ChatListCallBackImpl.this.inCancelArray(optionBean.getId())) {
                    return false;
                }
                if (ChatListCallBackImpl.this.mTalkType == 2) {
                    return optionBean.getType() != 1;
                }
                if (ChatListCallBackImpl.this.mTalkType == 1) {
                    return optionBean.getType() != 2;
                }
                return true;
            }
        }).toList().observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<List<OptionBean>>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("ERROR: Load options data error." + e.getMessage());
            }

            public void onNext(List<OptionBean> optionBeen) {
                LogUtil.d("ChatOptions:" + optionBeen.toString());
                ChatListCallBackImpl.this.vu.setOptions(optionBeen);
            }
        });
    }

    private boolean inCancelArray(int srcId) {
        if (this.mCancelBottomPopMenuIdArray == null) {
            return false;
        }
        for (int id2 : this.mCancelBottomPopMenuIdArray) {
            if (id2 != srcId) continue;
            return true;
        }
        return false;
    }

    @Override
    public void notifyUpdateLastSession() {
        String draftContent = this.vu.getInputContent();
        LogUtil.d("Draft input content:" + draftContent);
        if (draftContent != null && !TextUtils.isEmpty((CharSequence)draftContent.trim())) {
            this.updateDraftContent(draftContent);
        } else {
            if (!this.mMessageList.isEmpty()) {
                TalkSessionBean updateSessionBean = new TalkSessionBean();
                TalkMessageBean lastMessageBean = this.mMessageList.get(this.mMessageList.size() - 1);
                updateSessionBean.setContent(lastMessageBean.getContent());
                updateSessionBean.setLastTime(lastMessageBean.getShowTime());
                updateSessionBean.setLastMsg(lastMessageBean);
                this.sendNotifyUpdateEvent(updateSessionBean);
            }
            LogUtil.d("Has draft:" + this.isHasDraft);
            if (this.isHasDraft) {
                this.updateDraftContent(draftContent);
            }
        }
    }

    @Override
    public void sendNotifyUpdateEvent(TalkSessionBean bean) {
        bean.setTalkFlag(this.getTalkFlag());
        IMProxySessionEvent.RefreshSessionEvent event = new IMProxySessionEvent.RefreshSessionEvent();
        event.setSessionBean(bean);
        event.setUpdateData(true);
        BusProvider.getInstance().post(event);
    }

    private String getTalkFlag() {
        return this.mTalkId + "_" + this.mTalkType;
    }

    @Override
    public void getDraftContent() {
        this.diskDataStore.getDraftContent(this.getTalkFlag(), new Subscriber<String>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("ERROR: Get draft content failed.");
            }

            public void onNext(String s) {
                ChatListCallBackImpl.this.isHasDraft = !TextUtils.isEmpty((CharSequence)s);
                ChatListCallBackImpl.this.vu.setInputContent(s);
            }
        });
    }

    @Override
    public void updateDraftContent(final String draftContent) {
        this.proxyRepository.getProxyConfig("diff").subscribe((Subscriber)new Subscriber<String>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("ERROR: Sync time difference failed." + e.getMessage());
                long draftTime = System.currentTimeMillis();
                if (draftContent != null && !TextUtils.isEmpty((CharSequence)draftContent.trim())) {
                    ChatListCallBackImpl.this.saveDraft(draftContent, draftTime);
                } else {
                    ChatListCallBackImpl.this.clearDraft(draftTime);
                }
            }

            @RequiresApi(api=17)
            public void onNext(String s) {
                long draftTime = 0L;
                if (!TextUtils.isEmpty((CharSequence)s) && !s.equals("0")) {
                    try {
                        draftTime = (SystemClock.elapsedRealtimeNanos() + Long.parseLong(s)) / 1000000L;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                draftTime = draftTime > 0L ? draftTime : System.currentTimeMillis();
                LogUtil.d("Draft: content:" + draftContent + ", time:" + draftTime);
                if (draftContent != null && !TextUtils.isEmpty((CharSequence)draftContent.trim())) {
                    ChatListCallBackImpl.this.saveDraft(draftContent, draftTime);
                } else {
                    ChatListCallBackImpl.this.clearDraft(draftTime);
                }
            }
        });
    }

    @Override
    public void saveDraft(final String draftContent, final long draftTime) {
        this.diskDataStore.getDraftContent(this.getTalkFlag(), new Subscriber<String>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
            }

            public void onNext(String s) {
                if (!TextUtils.isEmpty((CharSequence)draftContent)) {
                    ChatListCallBackImpl.this.diskDataStore.saveDraftContent(ChatListCallBackImpl.this.getTalkFlag(), draftContent, draftTime, new Subscriber<Boolean>(){

                        public void onCompleted() {
                        }

                        public void onError(Throwable e) {
                            LogUtil.e("ERROR: save draft failed.");
                        }

                        public void onNext(Boolean aBoolean) {
                            LogUtil.d("Save draft successfully.");
                            TalkSessionBean updateSessionBean = new TalkSessionBean();
                            SessionParam param = new SessionParam();
                            param.setDraftContent(draftContent);
                            param.setDraftTime(draftTime);
                            updateSessionBean.setParam(param);
                            ChatListCallBackImpl.this.sendNotifyUpdateEvent(updateSessionBean);
                        }
                    });
                }
            }
        });
    }

    @Override
    public void clearDraft(long draftTime) {
        this.diskDataStore.clearDraftContent(this.getTalkFlag(), draftTime, new Subscriber<Boolean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("ERROR: Clear draft failed. " + e.getMessage());
            }

            public void onNext(Boolean aBoolean) {
                LogUtil.d("Clear draft successfully.");
            }
        });
        TalkSessionBean updateSessionBean = new TalkSessionBean();
        if (!this.mMessageList.isEmpty()) {
            TalkMessageBean lastMessageBean = this.mMessageList.get(this.mMessageList.size() - 1);
            updateSessionBean.setContent(lastMessageBean.getContent());
            updateSessionBean.setLastTime(lastMessageBean.getShowTime());
            updateSessionBean.setLastMsg(lastMessageBean);
        } else {
            SessionParam param = new SessionParam();
            param.setDraftContent("");
            param.setDraftTime(0L);
            updateSessionBean.setParam(param);
        }
        this.sendNotifyUpdateEvent(updateSessionBean);
    }

    @Override
    public void clearUnReadMsgCount() {
        NotificationUtil.getInstance().clearPNNotification();
        if (this.proxyRepository != null) {
            this.proxyRepository.clearUnReadMsgCount(this.getTalkFlag(), new Subscriber<Integer>(){

                public void onCompleted() {
                }

                public void onError(Throwable e) {
                    LogUtil.d("Error:clear unRead msg flag failed.");
                }

                public void onNext(Integer integer) {
                    LogUtil.d("clear unRead msg flag successfully.");
                }
            });
        }
    }

    @Override
    public void onLongClickAtUser(int type, String groupId, String account, String userName) {
        if (TextUtils.isEmpty((CharSequence)account) || TextUtils.isEmpty((CharSequence)userName)) {
            return;
        }
        if (type != 0 || this.userCache.isMine(account)) {
            LogUtil.d("SetAtTextName account: " + account);
            return;
        }
        this.vu.setAtText("@" + userName + " ", 0);
        AtAccountNickMap.putAccountNick(groupId, account, userName);
    }

    @Override
    public void sendTextMessage(String message) {
        List<String> atAccount = AtAccountNickMap.getAtAccount(message, this.userCache.get().getAccount());
        if (this.mTalkType == 2 && !ObjectUtil.collectionIsEmpty(atAccount)) {
            this.sendAtTextMessage(message, atAccount);
            return;
        }
        LogUtil.d("send text message:" + message);
        this.proxyRepository.sendTextMessage(message, this.mTalkId, this.isLimit, this.mTalkType == 2, new Subscriber<TalkMessageBean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("send text error, ERROR:" + e.getMessage());
            }

            public void onNext(TalkMessageBean talkMessageBean) {
                int index = ChatListCallBackImpl.this.mMessageList.indexOf(talkMessageBean);
                if (index >= 0) {
                    return;
                }
                ChatListCallBackImpl.this.mMessageList.add(talkMessageBean);
                ChatListCallBackImpl.this.buildAdapter().notifyDataSetChanged();
                ChatListCallBackImpl.this.vu.setListSelection(ChatListCallBackImpl.this.mMessageList.size() - 1);
            }
        });
    }

    @Override
    public void sendAtTextMessage(String message, List<String> atAccount) {
        this.proxyRepository.sendAtTextMessage(message, this.mTalkId, this.isLimit, this.mTalkType == 2, atAccount, new Subscriber<TalkMessageBean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                ChatListCallBackImpl.this.clearAtAccount();
                e.printStackTrace();
            }

            public void onNext(TalkMessageBean talkMessageBean) {
                ChatListCallBackImpl.this.clearAtAccount();
                int index = ChatListCallBackImpl.this.mMessageList.indexOf(talkMessageBean);
                if (index >= 0) {
                    return;
                }
                ChatListCallBackImpl.this.mMessageList.add(talkMessageBean);
                ChatListCallBackImpl.this.buildAdapter().notifyDataSetChanged();
                ChatListCallBackImpl.this.vu.setListSelection(ChatListCallBackImpl.this.mMessageList.size() - 1);
            }
        });
    }

    private void clearAtAccount() {
        AtAccountNickMap.clearAccountNick();
        AtAccountNickMap.clearAccount(this.userCache.get().getAccount());
    }

    @Override
    public void sendFileMessage(List<FileInfo> fileList) {
        LogUtil.d("send file message:" + fileList.toString());
        this.proxyRepository.sendFileMessage(this.mTalkId, this.isLimit, this.mTalkType == 2, fileList, new Subscriber<TalkMessageBean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("send file ERROR:" + e.getMessage());
            }

            public void onNext(TalkMessageBean bean) {
                int index = ChatListCallBackImpl.this.mMessageList.indexOf(bean);
                if (index >= 0) {
                    return;
                }
                ChatListCallBackImpl.this.mMessageList.add(bean);
                ChatListCallBackImpl.this.buildAdapter().notifyDataSetChanged();
                ChatListCallBackImpl.this.vu.setListSelection(ChatListCallBackImpl.this.mMessageList.size() - 1);
            }
        });
    }

    @Override
    public void sendVoiceMessage(String path, int seconds) {
        VoiceFileInfo voiceFileInfo = new VoiceFileInfo();
        voiceFileInfo.setAmountOfTime(seconds);
        voiceFileInfo.setFilePath(path);
        voiceFileInfo.setFileName(path.substring(path.lastIndexOf("/") + 1, path.length()));
        voiceFileInfo.setFileSize(FileSizeUtils.getFileSize(path));
        voiceFileInfo.setSuffix("amr");
        voiceFileInfo.setFileType(1);
        ArrayList<FileInfo> fileInfoList = new ArrayList<FileInfo>();
        fileInfoList.add(voiceFileInfo);
        this.sendFileMessage(fileInfoList);
    }

    @Override
    public Intent buildIntent(Context context, OptionBean optionBean) {
        Intent intent = new Intent();
        if (!TextUtils.isEmpty((CharSequence)optionBean.getPkgName())) {
            intent.setClassName(optionBean.getPkgName(), optionBean.getClsName());
            intent.setFlags(0x10000000);
        } else {
            intent.setClassName(context.getPackageName(), optionBean.getClsName());
        }
        Map<String, String> params = optionBean.getParam();
        if (params != null && !params.isEmpty()) {
            for (Map.Entry<String, String> entity : params.entrySet()) {
                intent.putExtra(entity.getKey(), entity.getValue());
            }
        }
        intent.putExtra("talkerId", this.mTalkId);
        intent.putExtra("talkType", this.mTalkType);
        return intent;
    }

    @Override
    public void startToOptionView(Activity context, int position, OptionBean optionBean) {
        LogUtil.d("startToOptionView:" + optionBean.toString());
        Intent intent = this.buildIntent((Context)context, optionBean);
        try {
            if (optionBean.getRequestCode() > 0) {
                context.startActivityForResult(intent, optionBean.getRequestCode());
            } else {
                context.startActivity(intent);
            }
            this.vu.restoreActionState();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void handleAlbumResult(Intent data) {
        ArrayList thumbBeen = data.getParcelableArrayListExtra("album_pic_select");
        if (thumbBeen == null || thumbBeen.isEmpty()) {
            LogUtil.e("ERROR: thumb list is null or empty.");
            return;
        }
        ArrayList<FileInfo> imageFileInfoList = new ArrayList<FileInfo>();
        for (ImageThumbBean bean : thumbBeen) {
            FileInfo fileInfo = DataConvertUtils.mapImageFileInfo(bean);
            if (fileInfo == null) continue;
            imageFileInfoList.add(fileInfo);
        }
        this.sendFileMessage(imageFileInfoList);
    }

    @Override
    public void handleCameraResult(Intent data) {
        PhotoThumbBean thumbBean = (PhotoThumbBean)data.getParcelableExtra("album_photo");
        if (thumbBean == null) {
            LogUtil.e("ERROR: thumb list is null or empty.");
            return;
        }
        ArrayList<FileInfo> photoFileInfos = new ArrayList<FileInfo>();
        FileInfo photoFileInfo = DataConvertUtils.mapPhotoFileInfo(thumbBean);
        if (photoFileInfo != null) {
            photoFileInfos.add(photoFileInfo);
        }
        this.sendFileMessage(photoFileInfos);
    }

    @Override
    public void handleVideoRecorderResult(Intent data) {
        VideoItem videoItem = (VideoItem)data.getParcelableExtra("im_uikit_video_recorder");
        if (videoItem == null) {
            LogUtil.e("ERROR: videoItem is null.");
            return;
        }
        FileInfo videoFileInfo = DataConvertUtils.mapVideoFileInfo(videoItem);
        ArrayList<FileInfo> videoFileInfoList = new ArrayList<FileInfo>();
        videoFileInfoList.add(videoFileInfo);
        this.sendFileMessage(videoFileInfoList);
    }

    @Override
    public void handleFileResult(Intent data) {
        ArrayList fileItemList = data.getParcelableArrayListExtra("file_select");
        if (fileItemList == null || fileItemList.isEmpty()) {
            LogUtil.e("ERROR: file list is null or empty.");
            return;
        }
        ArrayList<FileInfo> fileInfoList = new ArrayList<FileInfo>();
        ArrayList<FileInfo> videoFileInfoList = new ArrayList<FileInfo>();
        ArrayList<FileInfo> imageFileInfoList = new ArrayList<FileInfo>();
        for (FileItem info : fileItemList) {
            FileInfo fileInfo = new FileInfo();
            fileInfo.setFilePath(info.getFilePath());
            fileInfo.setFileName(info.getFileName());
            fileInfo.setFileSize(info.getFileSize());
            String name = info.getFileName();
            String suffix = ToolUtil.getLastString(name, ".");
            if (!TextUtils.isEmpty((CharSequence)suffix)) {
                fileInfo.setSuffix(suffix);
            }
            fileInfo.setFileType(info.getFileType());
            boolean isImage = IMFileUtils.isImageFileType(name);
            boolean isVideo = IMFileUtils.isVideoFileType(name);
            if (isImage) {
                ImageFileInfo imageFileInfo = DataConvertUtils.mapImagePicFileInfo(fileInfo);
                if (imageFileInfo == null) continue;
                imageFileInfoList.add(imageFileInfo);
                continue;
            }
            if (isVideo) {
                FileInfo videoFileInfo = DataConvertUtils.mapVideoFileInfo(fileInfo);
                if (videoFileInfo == null) continue;
                videoFileInfo.setFileType(2);
                videoFileInfoList.add(videoFileInfo);
                continue;
            }
            fileInfoList.add(fileInfo);
        }
        if (imageFileInfoList.size() != 0) {
            this.sendFileMessage(imageFileInfoList);
        }
        if (videoFileInfoList.size() != 0) {
            this.sendFileMessage(videoFileInfoList);
        }
        if (fileInfoList.size() != 0) {
            this.sendFileMessage(fileInfoList);
        }
    }

    @Override
    public void handleFileLoadResult(Intent data) {
        Bundle bundle = data.getExtras();
        if (bundle == null) {
            LogUtil.e("ERROR: hand file load result, bundle is null.");
            return;
        }
        long msgId = bundle.getLong("messageId", -1L);
        int state = bundle.getInt("fileState", 1);
        long translateSize = bundle.getLong("fileTranslateSize", 0L);
        int position = this.mathMessage(msgId);
        if (position < 0) {
            LogUtil.w("Result file downloadFile code, position:" + position);
            return;
        }
        TalkMessageBean bean = this.mMessageList.get(position);
        NormalFileInfo fileInfo = (NormalFileInfo)bean.getFileInfo();
        if (fileInfo != null) {
            fileInfo.setTranslateSize(translateSize);
            fileInfo.setFileState(state);
            this.buildAdapter().updateItem(position, bean);
        }
    }

    @Override
    public int mathMessage(long messageId) {
        int size = this.mMessageList.size();
        for (int i = size - 1; i >= 0; --i) {
            if (messageId != this.mMessageList.get(i).getId()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void updateFileInfo(int position, FileInfo fileInfo) {
        if (position < 0 || position > this.mMessageList.size()) {
            return;
        }
        TalkMessageBean talkMessageBean = this.mMessageList.get(position);
        if (talkMessageBean != null) {
            talkMessageBean.setFileInfo(fileInfo);
            this.buildAdapter().updateItem(position, talkMessageBean);
        }
    }

    @Override
    public void updateFileTranslateSize() {
        for (TalkMessageBean bean : this.mMessageList) {
            FileInfo fileInfo = bean.getFileInfo();
            if (fileInfo == null || bean.getMessageType() != 4 && bean.getMessageType() != 2 || bean.getFileInfo() == null || bean.getFileInfo().getTranslateSize() == 0L || bean.getFileInfo().getTranslateSize() == bean.getFileInfo().getFileSize()) continue;
            TranslateInfoUtil.putInfo(bean.getId(), fileInfo.getTranslateSize());
        }
    }

    @Override
    public void changeMsgState(TalkMessageBean bean) {
        int position = this.mathMessage(bean.getId());
        if (position < 0) {
            LogUtil.e("ERROR: Change Msg State, position:" + position);
            return;
        }
        TalkMessageBean messageBean = this.mMessageList.get(position);
        if (messageBean != null) {
            messageBean.setMessageState(bean.getMessageState());
            messageBean.setFailCode(bean.getFailCode());
            messageBean.setContent(bean.getContent());
            this.buildAdapter().updateItem(position, messageBean);
        }
    }

    @Override
    public void addNewMessageToList(List<TalkMessageBean> talkMessageList) {
        this.mMessageList.addAll(talkMessageList);
        this.buildAdapter().notifyDataSetChanged();
        int firstVisiblePosition = this.vu.getListView().getFirstVisiblePosition();
        int lastVisiblePosition = this.vu.getListView().getLastVisiblePosition();
        if (this.mMessageList.size() > 15) {
            if (lastVisiblePosition <= this.mMessageList.size() - 1 && lastVisiblePosition > this.mMessageList.size() - 1 - 15) {
                this.vu.setListSelection(this.mMessageList.size() - 1);
            } else {
                this.vu.setListSelection(firstVisiblePosition + 1);
            }
        } else {
            this.vu.setListSelection(this.mMessageList.size() - 1);
        }
    }

    @Override
    public void setAtType() {
        if (this.mTalkType == 2) {
            AtPreferencesUtils.getWrapper(ActomaController.getAppConfigContext(), "at").setPreferenceBooleanValue(this.mTalkId, false);
        }
    }

    @Override
    public void setNoReadNumber() {
        if (this.mMessageList.contains(this.firstNewMessage)) {
            int index = this.mMessageList.indexOf(this.firstNewMessage);
            this.mMessageList.get(index).setRemind(true);
            this.mAdapter.updateItem(index, this.firstNewMessage);
            this.vu.getListView().smoothScrollToPositionFromTop(index, 0);
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    int indexOf = ChatListCallBackImpl.this.mMessageList.indexOf(ChatListCallBackImpl.this.firstNewMessage);
                    ChatListCallBackImpl.this.vu.setListSelection(indexOf);
                }
            }, 500L);
        } else {
            TalkMessageBean messageBean;
            long msgId = 0L;
            if (this.mMessageList.size() > 0 && (messageBean = this.mMessageList.get(0)) != null && messageBean.getId() >= 0L) {
                msgId = messageBean.getId();
            }
            this.loadMessageList(msgId, 30, this.number, this.firstNewMessage);
        }
    }

    public void loadMessageList(long msgId, int PAGE_SIZE, int number, TalkMessageBean newTalkMessageBean) {
        this.proxyRepository.getMessageList(this.mTalkId, this.mTalkType, msgId, PAGE_SIZE, new Subscriber<List<TalkMessageBean>>(){

            public void onCompleted() {
                if (ChatListCallBackImpl.this.vu.isRefreshing()) {
                    ChatListCallBackImpl.this.vu.stopRefresh();
                }
            }

            public void onError(Throwable e) {
                LogUtil.e("load message error:" + e.getMessage());
                ChatListCallBackImpl.this.buildAdapter().notifyDataSetChanged();
                if (ChatListCallBackImpl.this.vu.isRefreshing()) {
                    ChatListCallBackImpl.this.vu.stopRefresh();
                }
            }

            public void onNext(List<TalkMessageBean> talkMessageList) {
                ChatListCallBackImpl.this.msgListSort(talkMessageList);
                ChatListCallBackImpl.this.buildAdapter().notifyDataSetChanged();
                ChatListCallBackImpl.this.setNoReadNumber();
            }
        });
    }

    private void msgListSort(List<TalkMessageBean> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        if (this.mMessageList.isEmpty()) {
            this.mMessageList.addAll(list);
            return;
        }
        if (list.get(list.size() - 1).getShowTime() < this.mMessageList.get(0).getShowTime()) {
            this.mMessageList.addAll(0, list);
        } else if (list.get(0).getShowTime() > this.mMessageList.get(this.mMessageList.size() - 1).getShowTime()) {
            this.mMessageList.addAll(list);
        } else {
            for (int i = 0; i < list.size(); ++i) {
                int result = this.equaled(list.get(i), 0);
                if (result == -1) continue;
                if (result > -1 && result < this.mMessageList.size() - 1) {
                    this.mMessageList.add(result, list.get(i));
                    continue;
                }
                this.mMessageList.add(list.get(i));
            }
        }
    }

    private int equaled(TalkMessageBean msg, int index) {
        if (index < this.mMessageList.size()) {
            if (msg.getId() == this.mMessageList.get(index).getId()) {
                return -1;
            }
            if (msg.getShowTime() < this.mMessageList.get(index).getShowTime()) {
                return index;
            }
            return this.equaled(msg, ++index);
        }
        return index;
    }

    @Override
    public void syncServerTime() {
        this.proxyRepository.getProxyConfig("diff").subscribe((Subscriber)new Subscriber<String>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                DateUtils.setServerTime(String.valueOf(0));
                LogUtil.d(" Sync server time error!");
            }

            @RequiresApi(api=17)
            public void onNext(String s) {
                DateUtils.setServerTime(s);
                LogUtil.d(" Sync server time OK!");
            }
        });
    }

    public static class MyHandler
    extends Handler {
        private final WeakReference<Activity> mActivity;

        public MyHandler(Activity activity) {
            this.mActivity = new WeakReference<Activity>(activity);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
        }
    }
}

