/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.core.repository.impl;

import android.text.TextUtils;
import com.google.gson.Gson;
import com.xdja.im.common.cache.interf.CardCache;
import com.xdja.im.common.cache.interf.UserCache;
import com.xdja.im.core.model.message.mapper.DataMapper;
import com.xdja.im.core.model.param.SessionParam;
import com.xdja.im.core.repository.interf.UserOperateRepository;
import com.xdja.im.core.repository.interf.datasource.CloudDataStore;
import com.xdja.im.core.repository.interf.datasource.DiskDataStore;
import com.xdja.im.core.utils.ToolUtils;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.entity.KeyValuePair;
import com.xdja.im.uikit.entity.NoDisturbConfig;
import com.xdja.im.uikit.entity.SettingTopConfig;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.schedulers.Schedulers;

public class UserOperateImpl
implements UserOperateRepository {
    final String SETTER_KEY_ROAM_SETTING = "roamSetting";
    final String SETTER_KEY_USER_ACCOUNT = "userAccount";
    final String KEY_LOCAL_STATE = "localDbState";
    private CloudDataStore cloudDataStore;
    private DiskDataStore diskDataStore;
    private UserCache userCache;
    private CardCache cardCache;
    private DataMapper dataMapper;
    private Gson gson;

    @Inject
    public UserOperateImpl(CloudDataStore cloudDataStore, DiskDataStore diskDataStore, UserCache userCache, CardCache cardCache, DataMapper dataMapper, Gson gson) {
        this.cloudDataStore = cloudDataStore;
        this.diskDataStore = diskDataStore;
        this.userCache = userCache;
        this.cardCache = cardCache;
        this.dataMapper = dataMapper;
        this.gson = gson;
    }

    @Override
    public void getAllSessionParams(Subscriber<List<SessionParam>> subscriber) {
        final String account = this.userCache.get().getAccount();
        if (TextUtils.isEmpty((CharSequence)account)) {
            LogUtil.e("Report push clientId error.");
            return;
        }
        this.diskDataStore.queryIntegerSharePref("localDbState").subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<Boolean, Observable<List<SessionParam>>>(){

            public Observable<List<SessionParam>> call(Boolean aBoolean) {
                return Observable.zip(UserOperateImpl.this.cloudDataStore.getNoDisturbSettingsAtCloud(account), UserOperateImpl.this.cloudDataStore.getSettingTopSettingsAtCloud(account), (Func2)new Func2<List<NoDisturbConfig>, List<SettingTopConfig>, List<SessionParam>>(){

                    public List<SessionParam> call(List<NoDisturbConfig> noDisturbConfigs, List<SettingTopConfig> settingTopConfigs) {
                        ArrayList<SessionParam> results = new ArrayList<SessionParam>();
                        int noDisturbSize = noDisturbConfigs.size();
                        for (int i = 0; i < noDisturbSize; ++i) {
                            SessionParam rConfig = new SessionParam();
                            NoDisturbConfig config = noDisturbConfigs.get(i);
                            SettingTopConfig sConfig = new SettingTopConfig();
                            String sessionFlag = ToolUtils.getSessionTag(config.getSessionId(), config.getSessionType());
                            sConfig.setSessionId(sessionFlag);
                            rConfig.setSessionFlag(sessionFlag);
                            rConfig.setDisturb(true);
                            if (settingTopConfigs.contains(sConfig)) {
                                int index = settingTopConfigs.indexOf(sConfig);
                                rConfig.setTop(true);
                                settingTopConfigs.remove(index);
                            } else {
                                rConfig.setTop(false);
                            }
                            results.add(rConfig);
                        }
                        int settingSize = settingTopConfigs.size();
                        if (settingSize >= 0) {
                            for (int i = 0; i < settingSize; ++i) {
                                SessionParam rConfig = new SessionParam();
                                SettingTopConfig config = settingTopConfigs.get(i);
                                rConfig.setSessionFlag(config.getSessionId());
                                rConfig.setDisturb(false);
                                rConfig.setTop(true);
                                results.add(rConfig);
                            }
                        }
                        return results;
                    }
                }).flatMap((Func1)new Func1<List<SessionParam>, Observable<List<SessionParam>>>(){

                    public Observable<List<SessionParam>> call(List<SessionParam> sessionConfigs) {
                        return UserOperateImpl.this.diskDataStore.saveSettingTopAndNodisturb2Local(sessionConfigs);
                    }
                });
            }
        }).flatMap((Func1)new Func1<List<SessionParam>, Observable<List<SessionParam>>>(){

            public Observable<List<SessionParam>> call(final List<SessionParam> configs) {
                KeyValuePair<String, Integer> keyValuePair = new KeyValuePair<String, Integer>();
                keyValuePair.setKey("localDbState");
                keyValuePair.setValue(1);
                return UserOperateImpl.this.diskDataStore.saveIntKeyValuePairs(keyValuePair).flatMap((Func1)new Func1<Boolean, Observable<List<SessionParam>>>(){

                    public Observable<List<SessionParam>> call(Boolean aBoolean) {
                        if (aBoolean.booleanValue()) {
                            return Observable.just((Object)configs);
                        }
                        return Observable.error((Throwable)new Throwable(ImUiKit.getInstance().getContext().getString(R.string.im_uikit_conversation_data_save_fail)));
                    }
                });
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }
}

