/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.core.repository.impl.datasource;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.xdja.im.base.di.scope.Scoped;
import com.xdja.im.common.cache.interf.ConfigCache;
import com.xdja.im.common.cache.interf.UserCache;
import com.xdja.im.common.network.ApiFactoryMe;
import com.xdja.im.common.network.body.ReportBody;
import com.xdja.im.core.repository.interf.datasource.CloudDataStore;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.entity.NoDisturbConfig;
import com.xdja.im.uikit.entity.NoDisturbSetter;
import com.xdja.im.uikit.entity.SessionTopSetter;
import com.xdja.im.uikit.entity.SettingTopConfig;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.utils.sys.NetworkUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import okhttp3.ResponseBody;
import retrofit2.Response;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public class CloudDataStoreImpl
implements CloudDataStore {
    private Context context;
    private ApiFactoryMe apiFactory;
    private UserCache userCache;
    private ConfigCache configCache;

    @Inject
    public CloudDataStoreImpl(@Scoped(value="application") Context context, ApiFactoryMe apiFactory, UserCache userCache, ConfigCache configCache) {
        this.context = context;
        this.apiFactory = apiFactory;
        this.userCache = userCache;
        this.configCache = configCache;
    }

    @Override
    public void reportPushClientId(String appId, Subscriber<Boolean> subscriber) {
        String account = this.userCache.get().getAccount();
        String clientId = this.userCache.get().getClientId();
        int type = this.configCache.getDevice().getDeviceType();
        if (TextUtils.isEmpty((CharSequence)account) || TextUtils.isEmpty((CharSequence)clientId)) {
            LogUtil.e("Report push clientId error.");
            return;
        }
        ReportBody body = new ReportBody(account, type, clientId, appId);
        LogUtil.d("ReportBody:" + body.toString());
        this.apiFactory.getUserSettingApi().loginReport(body).subscribeOn(Schedulers.newThread()).map((Func1)new Func1<Object, Boolean>(){

            public Boolean call(Object response) {
                return true;
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }

    @Override
    public void setCloudSessionTop(String sessionId, Subscriber<Boolean> subscriber) {
        String account = this.userCache.get().getAccount();
        if (TextUtils.isEmpty((CharSequence)account)) {
            LogUtil.e("Report push clientId error.");
            return;
        }
        SessionTopSetter setter = new SessionTopSetter();
        setter.setAccount(account);
        setter.setSessionId(sessionId);
        Observable.just((Object)setter).observeOn(Schedulers.newThread()).map((Func1)new Func1<SessionTopSetter, Response<ResponseBody>>(){

            public Response<ResponseBody> call(SessionTopSetter setter) {
                Response response = null;
                try {
                    response = CloudDataStoreImpl.this.apiFactory.getUserSettingApi().saveSessionTopSettings(setter).execute();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return response;
            }
        }).map((Func1)new Func1<Response<ResponseBody>, Boolean>(){

            public Boolean call(Response<ResponseBody> response) {
                return Boolean.TRUE;
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }

    @Override
    public void deleteSettingTopAtCloud(String sessionId, Subscriber<Boolean> subscriber) {
        String account = this.userCache.get().getAccount();
        if (TextUtils.isEmpty((CharSequence)account)) {
            LogUtil.e("Report push clientId error.");
            return;
        }
        final SessionTopSetter setter = new SessionTopSetter();
        setter.setAccount(account);
        setter.setSessionId(sessionId);
        Observable.just((Object)setter).observeOn(Schedulers.newThread()).map((Func1)new Func1<SessionTopSetter, Response<ResponseBody>>(){

            public Response<ResponseBody> call(SessionTopSetter sessionTopSetter) {
                Response response = null;
                try {
                    response = CloudDataStoreImpl.this.apiFactory.getUserSettingApi().deleteSessionTopSettings(setter).execute();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return response;
            }
        }).map((Func1)new Func1<Response<ResponseBody>, Boolean>(){

            public Boolean call(Response<ResponseBody> response) {
                return Boolean.TRUE;
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }

    @Override
    public Observable<List<SettingTopConfig>> getSettingTopSettingsAtCloud(@NonNull String account) {
        if (NetworkUtil.isNetworkConnected(ImUiKit.getInstance().getContext())) {
            return this.apiFactory.getUserSettingApi().getSettingTopSettings(account).subscribeOn(Schedulers.newThread()).map((Func1)new Func1<List<String>, List<SettingTopConfig>>(){

                public List<SettingTopConfig> call(List<String> strings) {
                    ArrayList<SettingTopConfig> results = new ArrayList<SettingTopConfig>();
                    for (String str : strings) {
                        SettingTopConfig sConfig = new SettingTopConfig();
                        sConfig.setSessionId(str);
                        if (results.size() != 0 && (results.size() == 0 || results.indexOf(sConfig) >= 0)) continue;
                        results.add(sConfig);
                    }
                    return results;
                }
            });
        }
        ArrayList list = new ArrayList();
        return Observable.just(list);
    }

    @Override
    public void saveNoDisturb2Cloud(String sessionFlag, String talkerAccount, int sessionType, Subscriber<Boolean> subscriber) {
        String account = this.userCache.get().getAccount();
        if (TextUtils.isEmpty((CharSequence)account)) {
            LogUtil.e("Report push clientId error.");
            return;
        }
        NoDisturbSetter noDisturbSetter = new NoDisturbSetter();
        noDisturbSetter.setSessionId(talkerAccount);
        noDisturbSetter.setSessionType(sessionType);
        noDisturbSetter.setAccount(account);
        noDisturbSetter.setSessionFlag(sessionFlag);
        Observable.just((Object)noDisturbSetter).observeOn(Schedulers.newThread()).map((Func1)new Func1<NoDisturbSetter, Response<ResponseBody>>(){

            public Response<ResponseBody> call(NoDisturbSetter noDisturbSetter) {
                Response response = null;
                try {
                    response = CloudDataStoreImpl.this.apiFactory.getUserSettingApi().saveNoDisturbSettings(noDisturbSetter).execute();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return response;
            }
        }).map((Func1)new Func1<Response<ResponseBody>, Boolean>(){

            public Boolean call(Response<ResponseBody> response) {
                return Boolean.TRUE;
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }

    @Override
    public void deleteNoDisturbAtCloud(String sessionFlag, String talkerAccount, int sessionType, Subscriber<Boolean> subscriber) {
        String account = this.userCache.get().getAccount();
        if (TextUtils.isEmpty((CharSequence)account)) {
            LogUtil.e("Report push clientId error.");
            return;
        }
        NoDisturbSetter noDisturbSetter = new NoDisturbSetter();
        noDisturbSetter.setSessionId(talkerAccount);
        noDisturbSetter.setAccount(account);
        noDisturbSetter.setSessionFlag(sessionFlag);
        noDisturbSetter.setSessionType(sessionType);
        Observable.just((Object)noDisturbSetter).observeOn(Schedulers.newThread()).map((Func1)new Func1<NoDisturbSetter, Response<ResponseBody>>(){

            public Response<ResponseBody> call(NoDisturbSetter noDisturbSetter) {
                Response response = null;
                try {
                    response = CloudDataStoreImpl.this.apiFactory.getUserSettingApi().deleteNoDisturbSettings(noDisturbSetter).execute();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return response;
            }
        }).map((Func1)new Func1<Response<ResponseBody>, Boolean>(){

            public Boolean call(Response<ResponseBody> response) {
                return Boolean.TRUE;
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }

    @Override
    public Observable<List<NoDisturbConfig>> getNoDisturbSettingsAtCloud(@NonNull String account) {
        if (NetworkUtil.isNetworkConnected(ImUiKit.getInstance().getContext())) {
            return this.apiFactory.getUserSettingApi().getNoDisturbSettings(account).subscribeOn(Schedulers.newThread()).map((Func1)new Func1<List<NoDisturbConfig>, List<NoDisturbConfig>>(){

                public List<NoDisturbConfig> call(List<NoDisturbConfig> noDisturbConfigs) {
                    return noDisturbConfigs;
                }
            });
        }
        ArrayList noDisturbConfigs = new ArrayList();
        return Observable.just(noDisturbConfigs);
    }
}

