/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.core.repository.impl.im;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.xdja.google.gson.Gson;
import com.xdja.im.base.di.scope.Scoped;
import com.xdja.im.base.executor.ThreadExecutor;
import com.xdja.im.base.executor.UIThread;
import com.xdja.im.common.cache.interf.CardCache;
import com.xdja.im.common.cache.interf.ConfigCache;
import com.xdja.im.common.cache.interf.UserCache;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.core.model.custom.CustomMsgInfo;
import com.xdja.im.core.model.message.AtInfo;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.core.model.message.mapper.DataMapper;
import com.xdja.im.core.model.message.mapper.ValueConverter;
import com.xdja.im.core.push.PushControllerImp;
import com.xdja.im.core.repository.interf.ProxyRepository;
import com.xdja.im.core.utils.FilePathUtils;
import com.xdja.im.core.utils.IMFileTools;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.file.bean.FileListType;
import com.xdja.im.lib.filemanage.model.HistoryFileCategory;
import com.xdja.im.lib.filemanage.util.ActomaController;
import com.xdja.im.lib.filemanage.util.DateUtils;
import com.xdja.im.lib.filemanage.util.ModelGenerator;
import com.xdja.im.lib.share.model.WebPageInfo;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.imsdk.ImClient;
import com.xdja.imsdk.callback.CallbackFunction;
import com.xdja.imsdk.callback.IMFileInfoCallback;
import com.xdja.imsdk.callback.IMMessageCallback;
import com.xdja.imsdk.callback.IMSecurityCallback;
import com.xdja.imsdk.callback.IMSessionCallback;
import com.xdja.imsdk.constant.ImSdkFileConstant;
import com.xdja.imsdk.exception.ImSdkException;
import com.xdja.imsdk.model.IMFileInfo;
import com.xdja.imsdk.model.IMMessage;
import com.xdja.imsdk.model.IMSession;
import com.xdja.imsdk.model.InitParam;
import com.xdja.imsdk.model.body.IMFileBody;
import com.xdja.imsdk.model.body.IMMessageBody;
import com.xdja.imsdk.model.body.IMTextBody;
import com.xdja.imsdk.util.ToolUtils;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;
import rx.functions.Func2;

public class IMProxyImpl
implements ProxyRepository {
    @Inject
    ThreadExecutor threadExecutor;
    @Inject
    UIThread uiThread;
    private Context context;
    private ImClient imClient;
    private CardCache cardCache;
    private ConfigCache configCache;
    private UserCache userCache;
    private DataMapper mapper;
    private CallbackFunction callbackFunction;
    private IMFileInfoCallback imFileInfoCallback;
    private IMMessageCallback imMessageCallback;
    private IMSessionCallback imSessionCallback;
    private IMSecurityCallback imSecurityCallback;

    @Inject
    public IMProxyImpl(@Scoped(value="application") Context context, ImClient imClient, CardCache cardCache, ConfigCache configCache, UserCache userCache, DataMapper mapper, CallbackFunction callbackFunction, IMFileInfoCallback imFileInfoCallback, IMMessageCallback imMessageCallback, IMSessionCallback imSessionCallback, IMSecurityCallback imSecurityCallback, CommonTool commonTool) {
        this.context = context;
        this.imClient = imClient;
        this.cardCache = cardCache;
        this.configCache = configCache;
        this.userCache = userCache;
        this.mapper = mapper;
        this.callbackFunction = callbackFunction;
        this.imFileInfoCallback = imFileInfoCallback;
        this.imMessageCallback = imMessageCallback;
        this.imSessionCallback = imSessionCallback;
        this.imSecurityCallback = imSecurityCallback;
    }

    @Override
    public Observable<Integer> initIMProxy() {
        return Observable.just((Object)"").subscribeOn(this.threadExecutor.getScheduler()).flatMap((Func1)new Func1<String, Observable<InitParam>>(){

            public Observable<InitParam> call(String s) {
                InitParam initParam = new InitParam();
                initParam.setAccount(IMProxyImpl.this.userCache.get().getAccount());
                initParam.setTicket(IMProxyImpl.this.userCache.get().getTicket());
                initParam.setTfcardId(IMProxyImpl.this.cardCache.get().getCardId());
                if (IMProxyImpl.this.configCache.getDevice() != null) {
                    initParam.setdType(IMProxyImpl.this.configCache.getDevice().getDeviceType());
                } else {
                    initParam.setdType(1);
                }
                initParam.setCallback(IMProxyImpl.this.callbackFunction);
                initParam.setSecurityCallback(IMProxyImpl.this.imSecurityCallback);
                HashMap<String, String> imProperty = new HashMap<String, String>();
                imProperty.put("server", IMProxyImpl.this.configCache.getServer().getImUrl());
                if (IMProxyImpl.this.configCache.getServer() != null && IMProxyImpl.this.configCache.getServer().getFastDfsUrl() != null) {
                    imProperty.put("file_ad", IMProxyImpl.this.configCache.getServer().getFastDfsUrl().getAddr());
                } else {
                    LogUtil.d("InitFail", "configCache is null");
                }
                imProperty.put("keystore", String.valueOf(R.raw.truststore));
                imProperty.put("path", FilePathUtils.getSdkCacheDir());
                imProperty.put("size", "30");
                imProperty.put("encrypt", "false");
                imProperty.put("bomb", "false");
                imProperty.put("push_client", PushControllerImp.clientId);
                imProperty.put("push_topic", PushControllerImp.subTopic);
                if (IMProxyImpl.this.configCache != null && IMProxyImpl.this.configCache.getServer() != null) {
                    imProperty.put("userid", IMProxyImpl.this.configCache.getServer().getUserId());
                    imProperty.put("user_secret", IMProxyImpl.this.configCache.getServer().getUserSecret());
                }
                initParam.setProperties(imProperty);
                LogUtil.d("InitParam:" + initParam.toString());
                return Observable.just((Object)initParam);
            }
        }).map((Func1)new Func1<InitParam, Integer>(){

            public Integer call(InitParam param) {
                IMProxyImpl.this.imClient.RegisterIMSessionChangeListener(IMProxyImpl.this.context, IMProxyImpl.this.imSessionCallback);
                IMProxyImpl.this.imClient.RegisterIMMessageChangeListener(IMProxyImpl.this.context, IMProxyImpl.this.imMessageCallback);
                IMProxyImpl.this.imClient.RegisterIMFileInfoChangeListener(IMProxyImpl.this.context, IMProxyImpl.this.imFileInfoCallback);
                return IMProxyImpl.this.imClient.Init(param);
            }
        }).observeOn(this.uiThread.getScheduler());
    }

    @Override
    public Observable<Integer> releaseIMProxy() {
        return Observable.just((Object)this.imClient).subscribeOn(this.threadExecutor.getScheduler()).flatMap((Func1)new Func1<ImClient, Observable<Integer>>(){

            public Observable<Integer> call(ImClient imClient) {
                imClient.UnregisterIMSessionChangeListener(IMProxyImpl.this.context);
                imClient.UnregisterIMMessageChangeListener(IMProxyImpl.this.context);
                imClient.UnregisterIMFileInfoChangeListener(IMProxyImpl.this.context);
                return Observable.just((Object)imClient.Release(1));
            }
        }).observeOn(this.uiThread.getScheduler());
    }

    @Override
    public Observable<Boolean> setProxyConfig(Map<String, String> param) {
        return Observable.just(param).subscribeOn(this.threadExecutor.getScheduler()).map((Func1)new Func1<Map<String, String>, Boolean>(){

            public Boolean call(Map<String, String> param) {
                IMProxyImpl.this.imClient.SetConfig(param);
                return true;
            }
        }).observeOn(this.uiThread.getScheduler());
    }

    @Override
    public Observable<String> getProxyConfig(String key) {
        return Observable.just((Object)key).subscribeOn(this.threadExecutor.getScheduler()).flatMap((Func1)new Func1<String, Observable<String>>(){

            public Observable<String> call(String key) {
                try {
                    String config = IMProxyImpl.this.imClient.GetConfig(key);
                    return Observable.just((Object)config);
                }
                catch (ImSdkException e) {
                    return Observable.error((Throwable)e);
                }
            }
        }).observeOn(this.uiThread.getScheduler());
    }

    @Override
    public void getSessionListBeans(final String begin, final int size, final int talkType, Subscriber<List<TalkSessionBean>> subscriber) {
        Observable.just((Object)"").subscribeOn(this.threadExecutor.getScheduler()).flatMap((Func1)new Func1<String, Observable<IMSession>>(){

            public Observable<IMSession> call(String s) {
                try {
                    List sessions = IMProxyImpl.this.imClient.GetIMSessionList(begin, size);
                    return Observable.from((Iterable)sessions);
                }
                catch (ImSdkException e) {
                    return Observable.error((Throwable)e);
                }
            }
        }).filter((Func1)new Func1<IMSession, Boolean>(){

            public Boolean call(IMSession imSession) {
                if (imSession != null && talkType != 0) {
                    return imSession.getSessionType() == talkType;
                }
                return imSession != null;
            }
        }).map((Func1)new Func1<IMSession, TalkSessionBean>(){

            public TalkSessionBean call(IMSession imSession) {
                if (imSession == null) {
                    return null;
                }
                return IMProxyImpl.this.mapper.mapTalkSessionBean(imSession);
            }
        }).observeOn(this.uiThread.getScheduler()).toSortedList().subscribe(subscriber);
    }

    @Override
    public void deleteSession(String sessionFlag, Subscriber<Integer> subscriber) {
        Observable.just((Object)sessionFlag).subscribeOn(this.threadExecutor.getScheduler()).flatMap((Func1)new Func1<String, Observable<Integer>>(){

            public Observable<Integer> call(String sessionFlag) {
                ArrayList<String> ids = new ArrayList<String>();
                ids.add(sessionFlag);
                int code = IMProxyImpl.this.imClient.DeleteIMSession(ids);
                return Observable.just((Object)code);
            }
        }).observeOn(this.uiThread.getScheduler()).subscribe(subscriber);
    }

    @Override
    public void getMessageList(final String talkId, final int talkType, final long begin, final int size, Subscriber<List<TalkMessageBean>> subscriber) {
        Observable.just((Object)"").subscribeOn(this.threadExecutor.getScheduler()).flatMap((Func1)new Func1<String, Observable<IMMessage>>(){

            public Observable<IMMessage> call(String s) {
                try {
                    String talkFlag = ToolUtils.getSessionTag((String)talkId, (int)talkType);
                    List messages = IMProxyImpl.this.imClient.GetIMMessageList(talkFlag, begin, size, false);
                    return Observable.from((Iterable)messages);
                }
                catch (ImSdkException e) {
                    return Observable.error((Throwable)e);
                }
            }
        }).map((Func1)new Func1<IMMessage, TalkMessageBean>(){

            public TalkMessageBean call(IMMessage message) {
                IMFileBody fileBody;
                IMMessageBody body;
                if (message == null) {
                    LogUtil.w("message is null");
                    return null;
                }
                if (message.isFileIMMessage() && !message.isRecalled() && (body = message.getMessageBody()) instanceof IMFileBody && ((fileBody = (IMFileBody)body).isImage() || fileBody.isPic() || fileBody.isMedia() || fileBody.isVideo())) {
                    try {
                        message = IMProxyImpl.this.imClient.getIMMessageById(message.getIMMessageId());
                    }
                    catch (ImSdkException e) {
                        LogUtil.e("", "Get im msg fail");
                    }
                }
                return IMProxyImpl.this.mapper.mapTalkMessageBean(message);
            }
        }).toSortedList().observeOn(this.uiThread.getScheduler()).subscribe(subscriber);
    }

    @Override
    public void getTalkMessage(long msgId, Subscriber<TalkMessageBean> subscriber) {
        Observable.just((Object)msgId).subscribeOn(this.threadExecutor.getScheduler()).flatMap((Func1)new Func1<Long, Observable<TalkMessageBean>>(){

            public Observable<TalkMessageBean> call(Long msgId) {
                try {
                    IMMessage imMessage = IMProxyImpl.this.imClient.getIMMessageById(Long.valueOf(msgId).longValue());
                    TalkMessageBean talkMessageBean = IMProxyImpl.this.mapper.mapTalkMessageBean(imMessage);
                    return Observable.just((Object)talkMessageBean);
                }
                catch (ImSdkException e) {
                    e.printStackTrace();
                    return Observable.error((Throwable)new Exception("Get message info failed."));
                }
            }
        }).observeOn(this.uiThread.getScheduler()).subscribe(subscriber);
    }

    @Override
    public void deleteMessages(List<Long> msgids, Subscriber<Integer> subscriber) {
        Observable.just(msgids).subscribeOn(this.threadExecutor.getScheduler()).flatMap((Func1)new Func1<List<Long>, Observable<Integer>>(){

            public Observable<Integer> call(List<Long> msgIds) {
                int code = IMProxyImpl.this.imClient.DeleteIMMessage(msgIds);
                if (code != 0) {
                    return Observable.error((Throwable)new Exception("Delete msg failed, msgId:" + msgIds.toString() + ",code:" + code));
                }
                return Observable.just((Object)code);
            }
        }).observeOn(this.uiThread.getScheduler()).subscribe(subscriber);
    }

    @Override
    public void getUnReadMsgCount(String talkId, Subscriber<Integer> subscriber) {
        Observable.just((Object)talkId).subscribeOn(this.threadExecutor.getScheduler()).flatMap((Func1)new Func1<String, Observable<Integer>>(){

            public Observable<Integer> call(String talkId) {
                try {
                    Map map = IMProxyImpl.this.imClient.GetRemindIMMessageCount(talkId);
                    return Observable.just(map.get("normal_new"));
                }
                catch (ImSdkException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }).observeOn(this.uiThread.getScheduler()).subscribe(subscriber);
    }

    @Override
    public Observable<TalkMessageBean> getNoReadFirstNewMessage(final String flag) {
        return Observable.just((Object)this.imClient).flatMap((Func1)new Func1<ImClient, Observable<TalkMessageBean>>(){

            public Observable<TalkMessageBean> call(ImClient imClient) {
                try {
                    IMMessage imMessage = imClient.GetFirstNewMessage(flag);
                    TalkMessageBean talkMessageBean = IMProxyImpl.this.mapper.mapMessage(imMessage);
                    return Observable.just((Object)talkMessageBean);
                }
                catch (ImSdkException e) {
                    return Observable.error((Throwable)e);
                }
            }
        });
    }

    @Override
    public void clearUnReadMsgCount(String talkId, Subscriber<Integer> subscriber) {
        Observable.just((Object)talkId).subscribeOn(this.threadExecutor.getScheduler()).flatMap((Func1)new Func1<String, Observable<Integer>>(){

            public Observable<Integer> call(String talkId) {
                int i = IMProxyImpl.this.imClient.SetRemind(talkId, 0);
                return Observable.just((Object)i);
            }
        }).observeOn(this.uiThread.getScheduler()).subscribe(subscriber);
    }

    @Override
    public void clearAllData(Subscriber<Integer> subscriber) {
        Observable.just((Object)"").subscribeOn(this.threadExecutor.getScheduler()).flatMap((Func1)new Func1<String, Observable<Integer>>(){

            public Observable<Integer> call(String s) {
                int i = IMProxyImpl.this.imClient.ClearAllLocalData();
                return Observable.just((Object)i);
            }
        }).observeOn(this.uiThread.getScheduler()).subscribe(subscriber);
    }

    @Override
    public void clearAllSessionData(String sessionFlag, Subscriber<Integer> subscriber) {
        Observable.just((Object)sessionFlag).subscribeOn(this.threadExecutor.getScheduler()).flatMap((Func1)new Func1<String, Observable<Integer>>(){

            public Observable<Integer> call(String sessionFlag) {
                int i = IMProxyImpl.this.imClient.ClearIMSessionAllIMMessage(sessionFlag);
                return Observable.just((Object)i);
            }
        }).observeOn(this.uiThread.getScheduler()).subscribe(subscriber);
    }

    @Override
    public void clearAllCacheData(Subscriber<Integer> subscriber) {
        Observable.just((Object)"").subscribeOn(this.threadExecutor.getScheduler()).flatMap((Func1)new Func1<String, Observable<Integer>>(){

            public Observable<Integer> call(String sessionFlag) {
                int i = IMProxyImpl.this.imClient.ClearCache();
                return Observable.just((Object)i);
            }
        }).observeOn(this.uiThread.getScheduler()).subscribe(subscriber);
    }

    @Override
    public void getAllUnReadMsgCount(Subscriber<Integer> subscriber) {
        Observable.just((Object)this.imClient).subscribeOn(this.threadExecutor.getScheduler()).flatMap((Func1)new Func1<ImClient, Observable<Integer>>(){

            public Observable<Integer> call(ImClient imClient) {
                return Observable.just((Object)imClient.GetAllRemindIMMessageCount());
            }
        }).observeOn(this.uiThread.getScheduler()).subscribe(subscriber);
    }

    @Override
    public void sendMessage(TalkMessageBean talkMessageBean, Subscriber<TalkMessageBean> subscriber) {
    }

    @Override
    public void reSendMessage(TalkMessageBean talkMessageBean, Subscriber<Integer> subscriber) {
        Observable.just((Object)talkMessageBean.getId()).subscribeOn(this.threadExecutor.getScheduler()).flatMap((Func1)new Func1<Long, Observable<Integer>>(){

            public Observable<Integer> call(Long aLong) {
                return Observable.just((Object)IMProxyImpl.this.imClient.ResendIMMessage(aLong.longValue()));
            }
        }).observeOn(this.uiThread.getScheduler()).subscribe(subscriber);
    }

    @Override
    public void sendTextMessage(final @NonNull String content, final @NonNull String to, final boolean isShan, final boolean isGroup, Subscriber<TalkMessageBean> subscriber) {
        Observable.just((Object)content).subscribeOn(this.threadExecutor.getScheduler()).flatMap((Func1)new Func1<String, Observable<IMMessage>>(){

            public Observable<IMMessage> call(String s) {
                IMMessage imMessage = new IMMessage();
                imMessage.setCardId(IMProxyImpl.this.cardCache.get().getCardId().toLowerCase());
                imMessage.setTimeToLive(isShan ? 9000 : 0);
                imMessage.setIMMessageTime(System.currentTimeMillis());
                imMessage.setMessageBody((IMMessageBody)new IMTextBody(content));
                imMessage.setFrom(IMProxyImpl.this.userCache.get().getAccount());
                imMessage.setTo(to);
                imMessage.setType(1 + (isGroup ? 4 : 0) + (isShan ? 8 : 0));
                return Observable.just((Object)imMessage);
            }
        }).flatMap((Func1)new Func1<IMMessage, Observable<TalkMessageBean>>(){

            public Observable<TalkMessageBean> call(IMMessage imMessage) {
                try {
                    imMessage = IMProxyImpl.this.imClient.SendIMMessage(imMessage);
                    TalkMessageBean talkMessageBean = IMProxyImpl.this.mapper.mapTalkMessageBean(imMessage);
                    return Observable.just((Object)talkMessageBean);
                }
                catch (ImSdkException e) {
                    return Observable.error((Throwable)e);
                }
            }
        }).observeOn(this.uiThread.getScheduler()).subscribe(subscriber);
    }

    @Override
    public void sendAtTextMessage(final @NonNull String content, final @NonNull String to, final boolean isShan, boolean isGroup, final List<String> atAccount, Subscriber<TalkMessageBean> subscriber) {
        Observable.just((Object)content).subscribeOn(this.threadExecutor.getScheduler()).flatMap((Func1)new Func1<String, Observable<IMMessage>>(){

            public Observable<IMMessage> call(String s) {
                IMMessage imMessage = new IMMessage();
                imMessage.setCardId(IMProxyImpl.this.cardCache.get().getCardId().toLowerCase());
                imMessage.setTimeToLive(isShan ? 9000 : 0);
                imMessage.setIMMessageTime(System.currentTimeMillis());
                imMessage.setMessageBody((IMMessageBody)IMProxyImpl.this.mapper.mapAtBody(new AtInfo(atAccount, content)));
                imMessage.setFrom(IMProxyImpl.this.userCache.get().getAccount());
                imMessage.setTo(to);
                imMessage.setType(261 + (isShan ? 8 : 0));
                return Observable.just((Object)imMessage);
            }
        }).flatMap((Func1)new Func1<IMMessage, Observable<TalkMessageBean>>(){

            public Observable<TalkMessageBean> call(IMMessage imMessage) {
                try {
                    imMessage = IMProxyImpl.this.imClient.SendIMMessage(imMessage);
                    TalkMessageBean talkMessageBean = IMProxyImpl.this.mapper.mapMessage(imMessage);
                    return Observable.just((Object)talkMessageBean);
                }
                catch (ImSdkException e) {
                    return Observable.error((Throwable)e);
                }
            }
        }).observeOn(this.uiThread.getScheduler()).subscribe(subscriber);
    }

    @Override
    public void recallMessages(final long talkId, final int action, Subscriber<Integer> subscriber) {
        Observable.just((Object)this.imClient).subscribeOn(this.threadExecutor.getScheduler()).flatMap((Func1)new Func1<ImClient, Observable<Integer>>(){

            public Observable<Integer> call(ImClient imClient) {
                return Observable.just((Object)imClient.RecallIMMessage(talkId, action));
            }
        }).observeOn(this.uiThread.getScheduler()).subscribe(subscriber);
    }

    @Override
    public void sendNotifyTextMessage(final @NonNull String content, final @NonNull String to, final boolean isGroup, Subscriber<TalkMessageBean> subscriber) {
        Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<IMMessage>(){

            public void call(Subscriber<? super IMMessage> subscriber) {
                IMMessage imMessage = new IMMessage();
                imMessage.setCardId(IMProxyImpl.this.cardCache.get().getCardId().toLowerCase());
                imMessage.setIMMessageTime(System.currentTimeMillis());
                imMessage.setMessageBody((IMMessageBody)new IMTextBody(content));
                imMessage.setFrom(IMProxyImpl.this.userCache.get().getAccount());
                imMessage.setTo(to);
                imMessage.setType(isGroup ? 32773 : 32769);
                subscriber.onNext((Object)imMessage);
            }
        }).subscribeOn(this.threadExecutor.getScheduler()).flatMap((Func1)new Func1<IMMessage, Observable<TalkMessageBean>>(){

            public Observable<TalkMessageBean> call(IMMessage imMessage) {
                try {
                    imMessage = IMProxyImpl.this.imClient.SendIMMessage(imMessage);
                    TalkMessageBean talkMessageBean = IMProxyImpl.this.mapper.mapTalkMessageBean(imMessage);
                    return Observable.just((Object)talkMessageBean);
                }
                catch (ImSdkException e) {
                    return Observable.error((Throwable)e);
                }
            }
        }).observeOn(this.uiThread.getScheduler()).subscribe(subscriber);
    }

    @Override
    public void sendCustomMessage(TalkMessageBean talkMessageBean, Subscriber<TalkMessageBean> subscriber) {
        Observable.just((Object)talkMessageBean).subscribeOn(this.threadExecutor.getScheduler()).map((Func1)new Func1<TalkMessageBean, IMMessage>(){

            public IMMessage call(TalkMessageBean talkMessageBean) {
                return IMProxyImpl.this.mapper.mapIMMessage(talkMessageBean);
            }
        }).flatMap((Func1)new Func1<IMMessage, Observable<TalkMessageBean>>(){

            public Observable<TalkMessageBean> call(IMMessage message) {
                if (message == null) {
                    return Observable.error((Throwable)new IllegalArgumentException("message is null."));
                }
                try {
                    IMMessage imMessage = IMProxyImpl.this.imClient.IMMessageListAddCust("", message);
                    TalkMessageBean talkMessageBean = IMProxyImpl.this.mapper.mapTalkMessageBean(imMessage);
                    return Observable.just((Object)talkMessageBean);
                }
                catch (ImSdkException e) {
                    return Observable.error((Throwable)e);
                }
            }
        }).observeOn(this.uiThread.getScheduler()).subscribe(subscriber);
    }

    @Override
    public void sendFileMessage(final @NonNull String to, final boolean isShan, final boolean isGroup, List<FileInfo> fileInfoList, Subscriber<TalkMessageBean> subscriber) {
        Observable.from(fileInfoList).subscribeOn(this.threadExecutor.getScheduler()).flatMap((Func1)new Func1<FileInfo, Observable<IMMessage>>(){

            public Observable<IMMessage> call(FileInfo fileInfo) {
                IMMessage imMessage = new IMMessage();
                imMessage.setCardId(IMProxyImpl.this.cardCache.get().getCardId().toLowerCase());
                imMessage.setTimeToLive(isShan ? 9000 : 0);
                imMessage.setIMMessageTime(System.currentTimeMillis());
                imMessage.setFrom(IMProxyImpl.this.userCache.get().getAccount());
                imMessage.setTo(to);
                imMessage.setMessageBody((IMMessageBody)IMProxyImpl.this.mapper.mapFileBody(fileInfo));
                imMessage.setType(2 + (isGroup ? 4 : 0) + (isShan ? 8 : 0));
                return Observable.just((Object)imMessage);
            }
        }).flatMap((Func1)new Func1<IMMessage, Observable<TalkMessageBean>>(){

            public Observable<TalkMessageBean> call(IMMessage imMessage) {
                try {
                    imMessage = IMProxyImpl.this.imClient.SendIMMessage(imMessage);
                    TalkMessageBean talkMessageBean = IMProxyImpl.this.mapper.mapTalkMessageBean(imMessage);
                    return Observable.just((Object)talkMessageBean);
                }
                catch (ImSdkException e) {
                    return Observable.error((Throwable)e);
                }
            }
        }).observeOn(this.uiThread.getScheduler()).subscribe(subscriber);
    }

    @Override
    public Observable<List<FileInfo>> getImageFileList(List<ImageFileInfo> pictureList, final int type) {
        return Observable.from(pictureList).concatMap((Func1)new Func1<ImageFileInfo, Observable<FileInfo>>(){

            public Observable<FileInfo> call(ImageFileInfo pictureInfo) {
                String account = IMProxyImpl.this.userCache.get().getAccount();
                if (TextUtils.isEmpty((CharSequence)account)) {
                    return Observable.error((Throwable)new NullPointerException("user account is NULL."));
                }
                Observable<FileInfo> fileInfo = null;
                fileInfo = type == 1 ? ModelGenerator.createPictureFileInfo(pictureInfo, account) : ModelGenerator.createImageFileInfo(pictureInfo, account);
                if (fileInfo == null) {
                    return Observable.error((Throwable)new Exception("create thumbnail failed."));
                }
                return fileInfo;
            }
        }).toList();
    }

    @Override
    public void downloadFile(List<FileInfo> fileInfo, Subscriber<Integer> subscriber) {
        Observable.just(fileInfo).subscribeOn(this.threadExecutor.getScheduler()).flatMap((Func1)new Func1<List<FileInfo>, Observable<Integer>>(){

            public Observable<Integer> call(List<FileInfo> fileInfoList) {
                ArrayList<IMFileInfo> files = new ArrayList<IMFileInfo>();
                for (int i = 0; i < fileInfoList.size(); ++i) {
                    files.add(IMProxyImpl.this.mapper.mapIMFileInfo(fileInfoList.get(i)));
                }
                int code = IMProxyImpl.this.imClient.ReceiveFileStart(files);
                return Observable.just((Object)code);
            }
        }).observeOn(this.uiThread.getScheduler()).subscribe(subscriber);
    }

    @Override
    public void pauseFileSending(FileInfo fileInfo, Subscriber<Integer> subscriber) {
        Observable.just((Object)fileInfo).subscribeOn(this.threadExecutor.getScheduler()).map((Func1)new Func1<FileInfo, IMFileInfo>(){

            public IMFileInfo call(FileInfo fileInfo) {
                if (fileInfo == null) {
                    return null;
                }
                return IMProxyImpl.this.mapper.mapIMFileInfo(fileInfo);
            }
        }).flatMap((Func1)new Func1<IMFileInfo, Observable<Integer>>(){

            public Observable<Integer> call(IMFileInfo imFileInfo) {
                return Observable.just((Object)IMProxyImpl.this.imClient.SendFilePause(imFileInfo));
            }
        }).observeOn(this.uiThread.getScheduler()).subscribe(subscriber);
    }

    @Override
    public void resumeFileSend(FileInfo fileInfo, Subscriber<Integer> subscriber) {
        Observable.just((Object)fileInfo).subscribeOn(this.threadExecutor.getScheduler()).map((Func1)new Func1<FileInfo, IMFileInfo>(){

            public IMFileInfo call(FileInfo fileInfo) {
                if (fileInfo == null) {
                    return null;
                }
                return IMProxyImpl.this.mapper.mapIMFileInfo(fileInfo);
            }
        }).flatMap((Func1)new Func1<IMFileInfo, Observable<Integer>>(){

            public Observable<Integer> call(IMFileInfo file) {
                return Observable.just((Object)IMProxyImpl.this.imClient.SendFileResume(file));
            }
        }).observeOn(this.uiThread.getScheduler()).subscribe(subscriber);
    }

    @Override
    public void pauseFileReceiving(FileInfo fileInfo, Subscriber<Integer> subscriber) {
        Observable.just((Object)fileInfo).subscribeOn(this.threadExecutor.getScheduler()).map((Func1)new Func1<FileInfo, IMFileInfo>(){

            public IMFileInfo call(FileInfo fileInfo) {
                if (fileInfo == null) {
                    return null;
                }
                return IMProxyImpl.this.mapper.mapIMFileInfo(fileInfo);
            }
        }).flatMap((Func1)new Func1<IMFileInfo, Observable<Integer>>(){

            public Observable<Integer> call(IMFileInfo file) {
                return Observable.just((Object)IMProxyImpl.this.imClient.ReceiveFilePause(file));
            }
        }).observeOn(this.uiThread.getScheduler()).subscribe(subscriber);
    }

    @Override
    public void resumeFileReceive(FileInfo fileInfo, Subscriber<Integer> subscriber) {
        Observable.just((Object)fileInfo).subscribeOn(this.threadExecutor.getScheduler()).map((Func1)new Func1<FileInfo, IMFileInfo>(){

            public IMFileInfo call(FileInfo fileInfo) {
                if (fileInfo == null) {
                    return null;
                }
                return IMProxyImpl.this.mapper.mapIMFileInfo(fileInfo);
            }
        }).flatMap((Func1)new Func1<IMFileInfo, Observable<Integer>>(){

            public Observable<Integer> call(IMFileInfo file) {
                return Observable.just((Object)IMProxyImpl.this.imClient.ReceiveFileResume(file));
            }
        }).observeOn(this.uiThread.getScheduler()).subscribe(subscriber);
    }

    @Override
    public void getSessionFileList(@NonNull String talkId, final int begin, final int size, Subscriber<List<TalkMessageBean>> subscriber) {
        Observable.just((Object)talkId).subscribeOn(this.threadExecutor.getScheduler()).flatMap((Func1)new Func1<String, Observable<IMMessage>>(){

            public Observable<IMMessage> call(String talkId) {
                try {
                    return Observable.from((Iterable)IMProxyImpl.this.imClient.GetFileList(talkId, ImSdkFileConstant.FileGetType.CUR_ALL_MEDIA, begin, size));
                }
                catch (ImSdkException e) {
                    e.printStackTrace();
                    return Observable.error((Throwable)e);
                }
            }
        }).map((Func1)new Func1<IMMessage, TalkMessageBean>(){

            public TalkMessageBean call(IMMessage imMessage) {
                return IMProxyImpl.this.mapper.mapTalkMessageBean(imMessage);
            }
        }).filter((Func1)new Func1<TalkMessageBean, Boolean>(){

            public Boolean call(TalkMessageBean talkMessageBean) {
                FileInfo fileInfo = talkMessageBean.getFileInfo();
                if (fileInfo == null || !talkMessageBean.isMine() && fileInfo.getFileState() != 2) {
                    return false;
                }
                return true;
            }
        }).toList().observeOn(this.uiThread.getScheduler()).subscribe(subscriber);
    }

    @Override
    public void queryRecentAndLocalFile(final FileListType tabType, Subscriber<Map<String, List<FileItem>>> subscriber) {
        Observable.just((Object)((Object)tabType)).subscribeOn(this.threadExecutor.getScheduler()).flatMap((Func1)new Func1<FileListType, Observable<Map<String, List<FileItem>>>>(){

            public Observable<Map<String, List<FileItem>>> call(FileListType fileListType) {
                HashMap<String, List<FileItem>> localFileMap = new HashMap<String, List<FileItem>>();
                try {
                    switch (tabType) {
                        case VIDEO: {
                            localFileMap.putAll(IMFileTools.queryLocalAudios());
                            localFileMap.putAll(IMFileTools.queryLocalVideos());
                            break;
                        }
                        case PHOTO: {
                            localFileMap.putAll(IMFileTools.queryLocalImages());
                            break;
                        }
                        case DOCUMENT: {
                            localFileMap.putAll(IMFileTools.queryLocalDocuments());
                            break;
                        }
                        case APK: {
                            localFileMap.putAll(IMFileTools.queryLocalApplication());
                            break;
                        }
                        case OTHER: {
                            localFileMap.putAll(IMFileTools.queryOtherFiles());
                            break;
                        }
                        case RECENT: {
                            localFileMap.putAll(IMFileTools.getLastFileList(IMProxyImpl.this.imClient.GetFileList("")));
                        }
                    }
                    return Observable.just(localFileMap);
                }
                catch (Exception e) {
                    return Observable.error((Throwable)new Throwable("Obtain msg error!"));
                }
            }
        }).observeOn(this.uiThread.getScheduler()).subscribe(subscriber);
    }

    @Override
    public void queryLocalFile(int tabType, Subscriber<Map<String, List<FileItem>>> subscriber) {
        Observable.just((Object)tabType).subscribeOn(this.threadExecutor.getScheduler()).flatMap((Func1)new Func1<Integer, Observable<Map<String, List<FileItem>>>>(){

            public Observable<Map<String, List<FileItem>>> call(Integer fileListType) {
                HashMap<String, List<FileItem>> localFileMap = new HashMap<String, List<FileItem>>();
                try {
                    switch (fileListType) {
                        case 1: {
                            localFileMap.putAll(IMFileTools.queryLocalAudios());
                            localFileMap.putAll(IMFileTools.queryLocalVideos());
                            break;
                        }
                        case 3: {
                            localFileMap.putAll(IMFileTools.queryLocalImages());
                            break;
                        }
                        case 5: {
                            localFileMap.putAll(IMFileTools.queryLocalDocuments());
                            break;
                        }
                        case 4: {
                            localFileMap.putAll(IMFileTools.queryLocalApplication());
                            break;
                        }
                        case 11: {
                            localFileMap.putAll(IMFileTools.queryOtherFiles());
                        }
                    }
                    return Observable.just(localFileMap);
                }
                catch (Exception e) {
                    return Observable.error((Throwable)new Throwable("Obtain msg error!"));
                }
            }
        }).observeOn(this.uiThread.getScheduler()).subscribe(subscriber);
    }

    @Override
    public Observable<Map<HistoryFileCategory, List<TalkMessageBean>>> getAllHistoryFileInfoWithTalkId(final String talkId, final int type) {
        return Observable.just((Object)this.imClient).flatMap((Func1)new Func1<ImClient, Observable<Map<HistoryFileCategory, List<TalkMessageBean>>>>(){

            public Observable<Map<HistoryFileCategory, List<TalkMessageBean>>> call(ImClient imClient) {
                LinkedHashMap resultMaps = new LinkedHashMap();
                try {
                    ImSdkFileConstant.FileGetType getType = ValueConverter.changeObtainFileType(type);
                    List messages = imClient.GetFileList(talkId, getType, 0, 0);
                    int length = messages.size();
                    if (length == 0) {
                        return Observable.just(resultMaps);
                    }
                    for (int i = 0; i < length; ++i) {
                        List<TalkMessageBean> valueLists;
                        IMMessage message = (IMMessage)messages.get(i);
                        TalkMessageBean messageBean = IMProxyImpl.this.mapper.mapMessage(message);
                        HistoryFileCategory category = IMProxyImpl.this.getDataCategory(message.getIMMessageTime());
                        if (resultMaps.containsKey(category)) {
                            valueLists = (List)resultMaps.get(category);
                        } else {
                            valueLists = new ArrayList();
                            category.setTime(messageBean.getShowTime());
                        }
                        messageBean.setCategoryId(category.getCategoryId());
                        valueLists.add(messageBean);
                        resultMaps.put(category, valueLists);
                    }
                }
                catch (ImSdkException e) {
                    return Observable.error((Throwable)e);
                }
                return Observable.just(resultMaps);
            }
        });
    }

    private HistoryFileCategory getDataCategory(long messageTime) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd", Locale.getDefault());
        Calendar calendar = Calendar.getInstance(Locale.getDefault());
        calendar.setTimeInMillis(messageTime);
        int msgYear = calendar.get(1);
        int msgDay = calendar.get(6);
        calendar.setTimeInMillis(DateUtils.obtainCurrentTime());
        int curYear = calendar.get(1);
        int curDay = calendar.get(6);
        int timeDistance = 0;
        if (curYear != msgYear) {
            for (int i = Math.min(curYear, msgYear); i < Math.max(curYear, msgYear); ++i) {
                if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {
                    timeDistance += 366;
                    continue;
                }
                timeDistance += 365;
            }
            timeDistance = timeDistance - msgDay + curDay;
        } else {
            timeDistance = curDay - msgDay;
        }
        String categoryId = "";
        categoryId = timeDistance == 0 ? ActomaController.getAppConfigContext().getString(R.string.im_uikit_today) : (timeDistance == 1 ? ActomaController.getAppConfigContext().getString(R.string.im_uikit_yesterday) : (timeDistance > 1 && timeDistance <= 7 ? ActomaController.getAppConfigContext().getString(R.string.im_uikit_one_week) : (timeDistance > 7 && timeDistance <= 30 ? ActomaController.getAppConfigContext().getString(R.string.im_uikit_week_ago) : (timeDistance > 30 ? ActomaController.getAppConfigContext().getString(R.string.im_uikit_month_ago) : dateFormat.format(messageTime)))));
        HistoryFileCategory dataCategory = new HistoryFileCategory();
        dataCategory.setCategoryId(categoryId);
        return dataCategory;
    }

    @Override
    public void changeMessageState(final TalkMessageBean talkMessageBean, int mState, Subscriber<Integer> subscriber) {
        Observable.just((Object)mState).subscribeOn(this.threadExecutor.getScheduler()).map((Func1)new Func1<Integer, Integer>(){

            public Integer call(Integer integer) {
                return ValueConverter.talkMsgStateConvert(integer);
            }
        }).flatMap((Func1)new Func1<Integer, Observable<Integer>>(){

            public Observable<Integer> call(Integer msgState) {
                if (talkMessageBean == null) {
                    return Observable.error((Throwable)new Exception(""));
                }
                IMMessage message = IMProxyImpl.this.mapper.mapIMMessage(talkMessageBean);
                return Observable.just((Object)IMProxyImpl.this.imClient.IMMessageStateChange(message, msgState.intValue()));
            }
        }).observeOn(this.uiThread.getScheduler()).subscribe(subscriber);
    }

    @Override
    public void saveFile(File srcFile, final String savePath, final String fileName, Subscriber<String> subscriber) {
        Observable.just((Object)srcFile).subscribeOn(this.threadExecutor.getScheduler()).map((Func1)new Func1<File, String>(){

            public String call(File srcFile) {
                boolean ret = FileUtils.saveFile(srcFile, savePath, fileName);
                if (!ret) {
                    Observable.error((Throwable)new IOException("Save file failed."));
                }
                return savePath + fileName;
            }
        }).observeOn(this.uiThread.getScheduler()).subscribe(subscriber);
    }

    @Override
    public void saveCustomIMMessage(CustomMsgInfo msginfo, Subscriber<IMMessage> subscriber) {
        Observable.zip((Observable)Observable.just((Object)msginfo).subscribeOn(this.threadExecutor.getScheduler()).map((Func1)new Func1<CustomMsgInfo, String>(){

            public String call(CustomMsgInfo msgInfo) {
                int type = msgInfo.getType();
                int sessionType = 1;
                if (type == 1 || type == 3 || type == 5) {
                    sessionType = 1;
                } else if (type == 2 || type == 4) {
                    sessionType = 2;
                }
                String sessiongTag = "";
                if (IMProxyImpl.this.userCache != null) {
                    sessiongTag = IMProxyImpl.this.userCache.isMine(msgInfo.getFromAtNo()) ? ToolUtils.getSessionTag((String)msgInfo.getToAtNo(), (int)sessionType) : (sessionType == 2 ? ToolUtils.getSessionTag((String)msgInfo.getToAtNo(), (int)sessionType) : ToolUtils.getSessionTag((String)msgInfo.getFromAtNo(), (int)sessionType));
                }
                return sessiongTag;
            }
        }), (Observable)Observable.just((Object)msginfo).subscribeOn(this.threadExecutor.getScheduler()).map((Func1)new Func1<CustomMsgInfo, IMMessage>(){

            public IMMessage call(CustomMsgInfo msgInfo) {
                IMMessage message = new IMMessage();
                Gson gson = new Gson();
                String info = gson.toJson((Object)msgInfo);
                IMTextBody body = new IMTextBody(info);
                message.setFrom(msgInfo.getFromAtNo());
                message.setTo(msgInfo.getToAtNo());
                int type = msgInfo.getType();
                if (type == 1 || type == 3 || type == 5) {
                    message.setType(65537);
                } else if (type == 2 || type == 4) {
                    message.setType(65541);
                }
                if (!(IMProxyImpl.this.userCache.get().getAccount().equals(msgInfo.getFromAtNo()) || msgInfo.getState() != 4 && msgInfo.getState() != 6)) {
                    message.setState(1);
                } else {
                    message.setState(0);
                }
                message.setMessageBody((IMMessageBody)body);
                return message;
            }
        }), (Func2)new Func2<String, IMMessage, IMMessage>(){

            public IMMessage call(String session, IMMessage imMessage) {
                try {
                    return IMProxyImpl.this.imClient.IMMessageListAddCust(session, imMessage);
                }
                catch (ImSdkException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }).observeOn(this.uiThread.getScheduler()).subscribe(subscriber);
    }

    @Override
    public void sendWebMessage(final @NonNull String to, final boolean isShan, final boolean isGroup, WebPageInfo webPageInfo, Subscriber<TalkMessageBean> subscriber) {
        Observable.just((Object)webPageInfo).subscribeOn(this.threadExecutor.getScheduler()).flatMap((Func1)new Func1<WebPageInfo, Observable<IMMessage>>(){

            public Observable<IMMessage> call(WebPageInfo webPageInfo) {
                IMMessage imMessage = new IMMessage();
                imMessage.setCardId(IMProxyImpl.this.cardCache.get().getCardId().toLowerCase());
                imMessage.setTimeToLive(isShan ? 9000 : 0);
                imMessage.setIMMessageTime(System.currentTimeMillis());
                imMessage.setFrom(IMProxyImpl.this.userCache.get().getAccount());
                imMessage.setTo(to);
                imMessage.setMessageBody((IMMessageBody)IMProxyImpl.this.mapper.mapWebBody(webPageInfo));
                imMessage.setType(64 + (isGroup ? 4 : 0) + (isShan ? 8 : 0));
                return Observable.just((Object)imMessage);
            }
        }).flatMap((Func1)new Func1<IMMessage, Observable<TalkMessageBean>>(){

            public Observable<TalkMessageBean> call(IMMessage imMessage) {
                try {
                    imMessage = IMProxyImpl.this.imClient.SendIMMessage(imMessage);
                    TalkMessageBean talkMessageBean = IMProxyImpl.this.mapper.mapTalkMessageBean(imMessage);
                    return Observable.just((Object)talkMessageBean);
                }
                catch (ImSdkException e) {
                    return Observable.error((Throwable)e);
                }
            }
        }).observeOn(this.uiThread.getScheduler()).subscribe(subscriber);
    }
}

