/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.core.service;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.support.annotation.Nullable;
import com.squareup.otto.Subscribe;
import com.xdja.im.base.di.component.DaggerUserComponent;
import com.xdja.im.base.di.component.RepositoryComponent;
import com.xdja.im.base.di.component.UserComponent;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.common.database.helper.MXSettingHelper;
import com.xdja.im.core.model.event.IMProxyEvent;
import com.xdja.im.core.model.event.IMProxyMessageEvent;
import com.xdja.im.core.model.event.IMProxySessionEvent;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.proxy.IMModuleProxyImpl;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.core.repository.interf.ProxyRepository;
import com.xdja.im.core.repository.interf.datasource.CloudDataStore;
import com.xdja.im.core.utils.DataCache;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.utils.log.LogUtil;
import dagger.Lazy;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import rx.Subscriber;

public class KitService
extends Service {
    @Inject
    Lazy<ProxyRepository> proxyRepository;
    @Inject
    Lazy<CloudDataStore> cloudDataStore;
    private AtomicInteger initIsDone;

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onCreate() {
        super.onCreate();
        LogUtil.d("KitServer start...");
        UserComponent mComponent = null;
        RepositoryComponent component = ImUiKit.getInstance().getComponent();
        if (component != null) {
            mComponent = DaggerUserComponent.builder().repositoryComponent(component).build();
        }
        if (mComponent == null) {
            LogUtil.e("ERROR: Component instance is null.");
            this.stopSelf();
            return;
        }
        mComponent.inject(this);
        BusProvider.getInstance().register((Object)this);
        this.initIsDone = new AtomicInteger(0);
        this.initProxy();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (this.getInitState() == 0 && "im.action.state".equals(intent.getAction())) {
            this.initMxProxy();
        }
        return 2;
    }

    public void onDestroy() {
        super.onDestroy();
        LogUtil.d("KitServer destroy...");
        try {
            BusProvider.getInstance().unregister((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.releaseProxy();
        DataCache.getInstance().clearAll();
    }

    public void initProxy() {
        this.initImProxy();
        this.initMxProxy();
    }

    private void initImProxy() {
        LogUtil.d("Start init im proxy.");
        if (this.proxyRepository == null || this.proxyRepository.get() == null) {
            LogUtil.e("ERROR: Init im proxy failed. mInstance is null.");
            return;
        }
        ((ProxyRepository)this.proxyRepository.get()).initIMProxy().subscribe((Subscriber)new Subscriber<Integer>(){

            public void onCompleted() {
                LogUtil.d("initProxy onCompleted");
            }

            public void onError(Throwable e) {
                LogUtil.d("initProxy onError:" + e.getMessage());
            }

            public void onNext(Integer integer) {
                if (integer == 0) {
                    LogUtil.d("Init imProxy successfully.");
                } else {
                    LogUtil.d("Init imProxy failed, failCode:" + integer);
                }
            }
        });
    }

    private void initMxProxy() {
        LogUtil.d("Start init mx proxy.");
        this.setInitIsDone(1);
        if (this.cloudDataStore == null) {
            LogUtil.e("ERROR: Init mx proxy failed. mInstance is null.");
            return;
        }
        ((CloudDataStore)this.cloudDataStore.get()).reportPushClientId(this.getPackageName(), new Subscriber<Boolean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("Report push client failed." + e.getMessage());
                KitService.this.setInitIsDone(0);
            }

            public void onNext(Boolean b) {
                LogUtil.d("Report push client successfully.");
                KitService.this.setInitIsDone(2);
            }
        });
    }

    public void releaseProxy() {
        LogUtil.d("Start release im proxy.");
        this.setInitIsDone(0);
        if (this.proxyRepository == null) {
            LogUtil.e("ERROR: Release im proxy failed. mInstance is null.");
            return;
        }
        ((ProxyRepository)this.proxyRepository.get()).releaseIMProxy().subscribe((Subscriber)new Subscriber<Integer>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
            }

            public void onNext(Integer integer) {
                LogUtil.d("Release im proxy " + integer);
            }
        });
    }

    private void getAllUnReadMessageCount() {
        ((ProxyRepository)this.proxyRepository.get()).getAllUnReadMsgCount(new Subscriber<Integer>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("Get unread message count failed. " + e.getMessage());
            }

            public void onNext(Integer integer) {
                if (integer > 0) {
                    IMUiKitProxyImpl.getInstance().updateUnReadMessageCount(integer);
                }
            }
        });
    }

    private int getInitState() {
        if (this.initIsDone != null) {
            return this.initIsDone.get();
        }
        return 0;
    }

    private void setInitIsDone(int state) {
        if (this.initIsDone != null) {
            this.initIsDone.set(state);
        }
    }

    @Subscribe
    public void onInitFinished(IMProxyEvent.OnInitFinishedEvent event) {
        LogUtil.d("EVENT: onInitFinished");
        this.getAllUnReadMessageCount();
        IMProxySessionEvent.RefreshSessionListEvent refreshMessageListEvent = new IMProxySessionEvent.RefreshSessionListEvent();
        BusProvider.getInstance().post(refreshMessageListEvent);
    }

    @Subscribe
    public void onInitFailed(IMProxyEvent.OnInitFailedEvent event) {
        LogUtil.d("EVENT: onInitFailed");
        LogUtil.e("ERROR: init sdk failed.");
    }

    @Subscribe
    public void onNewMsgComeEvent(IMProxyMessageEvent.NewMsgComeEvent event) {
        LogUtil.d("EVENT: NewMsgComeEvent");
        TalkSessionBean sessionBean = event.getListBean();
        List<TalkMessageBean> msgLists = event.getBeans();
        boolean isDisturb = MXSettingHelper.isSessionDisturb(sessionBean.getTalkFlag());
        boolean isResult = IMUiKitProxyImpl.getInstance().notify(sessionBean, msgLists.size(), isDisturb);
        if (!isResult) {
            IMModuleProxyImpl.getInstance().notify(sessionBean, msgLists.size(), isDisturb, msgLists);
        }
    }
}

