/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.album.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.provider.MediaStore;
import android.text.TextUtils;
import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.core.utils.FilePathUtils;
import com.xdja.im.lib.album.ImagePickerManager;
import com.xdja.im.lib.album.bean.ImageItem;
import com.xdja.im.lib.album.bean.ImageThumbBean;
import com.xdja.im.lib.album.utils.ThumbnailUtils;
import com.xdja.im.lib.filemanage.util.ToolUtil;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.gif.GifDecoder;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import rx.Observable;
import rx.functions.Func1;
import rx.functions.Func3;
import rx.schedulers.Schedulers;

public class DataTools {
    public static List<ImageItem> loadImageData(Context context) {
        Uri mImageUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        ContentResolver mContentResolver = context.getContentResolver();
        String[] projection = new String[]{"_id", "_display_name", "_data", "_size", "width", "height"};
        String sortOrder = "date_modified desc";
        Cursor cursor = mContentResolver.query(mImageUri, projection, null, null, sortOrder);
        ArrayList<ImageItem> localPicInfoList = new ArrayList<ImageItem>();
        if (cursor != null) {
            while (cursor.moveToNext()) {
                ImageItem info;
                int width = cursor.getInt(cursor.getColumnIndex("width"));
                int height = cursor.getInt(cursor.getColumnIndex("height"));
                String path = cursor.getString(cursor.getColumnIndex("_data"));
                String name = cursor.getString(cursor.getColumnIndex("_display_name"));
                int size = cursor.getInt(cursor.getColumnIndex("_size"));
                if (!FileUtils.isFileExists(path)) continue;
                if (width > 0 && height > 0) {
                    ImageItem info2 = new ImageItem(name, path, size, width, height, 0);
                    if (localPicInfoList.contains(info2)) continue;
                    localPicInfoList.add(info2);
                    continue;
                }
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
                if (options.outWidth <= 0 || options.outHeight <= 0 || localPicInfoList.contains(info = new ImageItem(name, path, size, options.outWidth, options.outHeight, 0))) continue;
                localPicInfoList.add(info);
            }
            cursor.close();
        }
        return localPicInfoList;
    }

    public static Observable<List<ImageThumbBean>> createImageThumb(List<ImageItem> imageList) {
        return Observable.from(imageList).concatMap((Func1)new Func1<ImageItem, Observable<ImageThumbBean>>(){

            public Observable<ImageThumbBean> call(ImageItem imageItem) {
                return DataTools.createThumbNails(imageItem);
            }
        }).toList();
    }

    public static Observable<ImageThumbBean> createThumbNails(final ImageItem imageItem) {
        if (!FileUtils.isFileExists(imageItem.getPath())) {
            return Observable.error((Throwable)new IllegalArgumentException("File not exist(" + imageItem.getPath() + ")"));
        }
        String suffix = imageItem.getPath().substring(imageItem.getPath().lastIndexOf(".") + 1).toLowerCase();
        if ("gif".equalsIgnoreCase(suffix)) {
            return DataTools.createGifImageFileInfo(imageItem, false);
        }
        String imageRootPath = ImagePickerManager.getInstance().getConfig().getCachePath();
        if (TextUtils.isEmpty((CharSequence)imageRootPath)) {
            imageRootPath = FilePathUtils.getImagePath();
        }
        String baseFileName = UUID.randomUUID().toString();
        final String thumbName = "th_" + baseFileName;
        final String hdThumbName = "th_" + baseFileName + "_hd";
        return Observable.zip(DataTools.createHDThumbnail(imageItem.getPath(), new File(imageRootPath, hdThumbName)), DataTools.createThumbnail(imageItem.getPath(), new File(imageRootPath, thumbName)), DataTools.createRawFilePath(imageItem.getPath(), new File(imageRootPath, baseFileName), imageItem.isOriginal()), (Func3)new Func3<String, String, String, ImageThumbBean>(){

            public ImageThumbBean call(String hdPath, String thumbPath, String rawPath) {
                ImageThumbBean thumbBean = new ImageThumbBean();
                thumbBean.setThumbName(thumbName);
                thumbBean.setThumbPath(thumbPath);
                thumbBean.setThumbSize(FileSizeUtils.getFileSize(thumbPath));
                thumbBean.setHdThumbName(hdThumbName);
                thumbBean.setHdThumbPath(hdPath);
                thumbBean.setHdThumbSize(FileSizeUtils.getFileSize(hdPath));
                if (imageItem.isOriginal()) {
                    thumbBean.setRawName(imageItem.getName());
                    thumbBean.setRawPath(rawPath);
                    thumbBean.setRawSize(FileSizeUtils.getFileSize(rawPath));
                }
                return thumbBean;
            }
        });
    }

    private static Observable<String> createHDThumbnail(final String originalPath, File thumbFile) {
        return Observable.just((Object)originalPath).subscribeOn(Schedulers.newThread()).map((Func1)new Func1<String, String>(){

            public String call(String path) {
                return originalPath;
            }
        });
    }

    private static Observable<String> createThumbnail(final String originalPath, final File thumbFile) {
        return Observable.just((Object)originalPath).subscribeOn(Schedulers.newThread()).map((Func1)new Func1<String, String>(){

            public String call(String path) {
                String suffix = path.substring(path.lastIndexOf(".") + 1).toLowerCase();
                if (!TextUtils.isEmpty((CharSequence)suffix)) {
                    if (suffix.equals("gif")) {
                        GifDecoder gifDecoder = new GifDecoder();
                        File file = new File(originalPath);
                        try {
                            byte[] bytes = gifDecoder.getByte(file);
                            gifDecoder.read(bytes);
                            gifDecoder.setFrameIndex(0);
                            Bitmap bitmap = gifDecoder.getNextFrame();
                            return ThumbnailUtils.saveBitmap(bitmap, 20, thumbFile);
                        }
                        catch (Exception exception) {}
                    } else {
                        return ThumbnailUtils.createImageThumbnail(path, 1, thumbFile);
                    }
                }
                return null;
            }
        });
    }

    private static Observable<String> createRawFilePath(String originalPath, File filePath, boolean isOriginalPic) {
        return Observable.just((Object)originalPath).subscribeOn(Schedulers.io()).map((Func1)new Func1<String, String>(){

            public String call(String originalPath) {
                return originalPath;
            }
        });
    }

    public static Observable<ImageThumbBean> createGifImageFileInfo(final ImageItem imageItem, final boolean isFile) {
        if (imageItem == null) {
            return null;
        }
        final String imageFilePath = imageItem.getPath();
        try {
            File file = new File(imageFilePath);
            if (!file.exists()) {
                return Observable.error((Throwable)new IllegalArgumentException("File not exist"));
            }
        }
        catch (Exception e) {
            LogUtil.e("", e);
        }
        String imageRootPath = ImagePickerManager.getInstance().getConfig().getCachePath();
        final String baseFileName = UUID.randomUUID().toString();
        final String thumbName = "th_" + baseFileName;
        final String hdThumbName = "th_" + baseFileName + "_hd";
        return Observable.zip(DataTools.createRawFilePath(imageFilePath, new File(imageRootPath, baseFileName), imageItem.isOriginal()), DataTools.createGifFirstFrameFilePath(imageFilePath, new File(imageRootPath, thumbName)), DataTools.createRawFilePath(imageFilePath, new File(imageRootPath, baseFileName), imageItem.isOriginal()), (Func3)new Func3<String, String, String, ImageThumbBean>(){

            public ImageThumbBean call(String hdThumbFilePath, String thumbFilePath, String rawFilePath) {
                if (TextUtils.isEmpty((CharSequence)hdThumbFilePath) || TextUtils.isEmpty((CharSequence)rawFilePath)) {
                    return null;
                }
                if (TextUtils.isEmpty((CharSequence)thumbFilePath)) {
                    thumbFilePath = rawFilePath;
                }
                if (isFile) {
                    ImageFileInfo imageFileInfo = new ImageFileInfo();
                    imageFileInfo.setFileName(thumbName);
                    imageFileInfo.setFilePath(thumbFilePath);
                    imageFileInfo.setFileSize(ToolUtil.getFileSize(thumbFilePath));
                    imageFileInfo.setTranslateSize(0L);
                    imageFileInfo.setSuffix("gif");
                    FileInfo fileExtraInfo = new FileInfo();
                    fileExtraInfo.setFileName(baseFileName);
                    fileExtraInfo.setFilePath(imageFilePath);
                    fileExtraInfo.setFileSize(ToolUtil.getFileSize(hdThumbFilePath));
                    fileExtraInfo.setTranslatePercent(0);
                    imageFileInfo.setOriginal(false);
                    imageFileInfo.setHdFileInfo(fileExtraInfo);
                    ImageThumbBean thumbBean = new ImageThumbBean();
                    thumbBean.setThumbName(thumbName);
                    thumbBean.setThumbPath(thumbFilePath);
                    thumbBean.setThumbSize(FileSizeUtils.getFileSize(thumbFilePath));
                    thumbBean.setHdThumbName(hdThumbName);
                    thumbBean.setHdThumbPath(hdThumbFilePath);
                    thumbBean.setHdThumbSize(FileSizeUtils.getFileSize(hdThumbFilePath));
                    thumbBean.setRawName(imageItem.getName());
                    thumbBean.setRawPath(rawFilePath);
                    thumbBean.setRawSize(FileSizeUtils.getFileSize(rawFilePath));
                    return thumbBean;
                }
                ImageFileInfo imageFileInfo = new ImageFileInfo();
                imageFileInfo.setFileName(thumbName);
                imageFileInfo.setFilePath(thumbFilePath);
                imageFileInfo.setFileSize(ToolUtil.getFileSize(thumbFilePath));
                imageFileInfo.setTranslateSize(0L);
                imageFileInfo.setSuffix("gif");
                FileInfo fileExtraInfo = new FileInfo();
                fileExtraInfo.setFileName(baseFileName);
                fileExtraInfo.setFilePath(imageFilePath);
                fileExtraInfo.setFileSize(ToolUtil.getFileSize(hdThumbFilePath));
                fileExtraInfo.setTranslatePercent(0);
                imageFileInfo.setOriginal(false);
                imageFileInfo.setHdFileInfo(fileExtraInfo);
                ImageThumbBean thumbBean = new ImageThumbBean();
                thumbBean.setThumbName(thumbName);
                thumbBean.setThumbPath(thumbFilePath);
                thumbBean.setThumbSize(FileSizeUtils.getFileSize(thumbFilePath));
                thumbBean.setHdThumbName(hdThumbName);
                thumbBean.setHdThumbPath(hdThumbFilePath);
                thumbBean.setHdThumbSize(FileSizeUtils.getFileSize(hdThumbFilePath));
                thumbBean.setRawName(imageItem.getName());
                thumbBean.setRawPath(rawFilePath);
                thumbBean.setRawSize(FileSizeUtils.getFileSize(rawFilePath));
                return thumbBean;
            }
        });
    }

    public static Observable<String> createGifFirstFrameFilePath(String originalPath, final File thumbFile) {
        return Observable.just((Object)originalPath).subscribeOn(Schedulers.io()).map((Func1)new Func1<String, String>(){

            public String call(String originalPath) {
                GifDecoder gifDecoder = new GifDecoder();
                File file = new File(originalPath);
                try {
                    byte[] bytes = gifDecoder.getByte(file);
                    gifDecoder.read(bytes);
                    gifDecoder.setFrameIndex(0);
                    Bitmap bitmap = gifDecoder.getNextFrame();
                    return com.xdja.imsdk.util.ThumbnailUtils.saveBitmap((Bitmap)bitmap, (int)20, (File)thumbFile);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
    }
}

