/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.camera.utils;

import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.lib.camera.CameraManager;
import com.xdja.im.lib.camera.bean.PhotoItem;
import com.xdja.im.lib.camera.bean.PhotoThumbBean;
import com.xdja.im.lib.camera.utils.ThumbnailUtils;
import java.io.File;
import java.util.UUID;
import rx.Observable;
import rx.functions.Func1;
import rx.functions.Func3;
import rx.schedulers.Schedulers;

public class DataTools {
    public static Observable<PhotoThumbBean> createImageThumb(PhotoItem photo) {
        return Observable.just((Object)photo).flatMap((Func1)new Func1<PhotoItem, Observable<PhotoThumbBean>>(){

            public Observable<PhotoThumbBean> call(PhotoItem photo) {
                return DataTools.createThumbNails(photo);
            }
        });
    }

    private static Observable<PhotoThumbBean> createThumbNails(final PhotoItem photo) {
        String photoRootPath = CameraManager.getInstance().getConfig().getCachePath();
        String baseFileName = UUID.randomUUID().toString();
        final String thumbName = "th_" + baseFileName;
        final String hdThumbName = "th_" + baseFileName + "_hd";
        return Observable.zip(DataTools.createHDThumbnail(photo.getFilePath(), new File(photoRootPath, hdThumbName)), DataTools.createThumbnail(photo.getFilePath(), new File(photoRootPath, thumbName)), DataTools.createRawFilePath(photo.getFilePath(), new File(photoRootPath, baseFileName), false), (Func3)new Func3<String, String, String, PhotoThumbBean>(){

            public PhotoThumbBean call(String hdPath, String thumbPath, String rawPath) {
                PhotoThumbBean photoBean = new PhotoThumbBean();
                photoBean.setThumbName(thumbName);
                photoBean.setThumbPath(thumbPath);
                photoBean.setThumbSize(FileSizeUtils.getFileSize(thumbPath));
                photoBean.setHdThumbName(hdThumbName);
                photoBean.setHdThumbPath(hdPath);
                photoBean.setHdThumbSize(FileSizeUtils.getFileSize(hdPath));
                if (photo.isbOriginal()) {
                    photoBean.setRawName(photo.getFileName());
                    photoBean.setRawPath(rawPath);
                    photoBean.setRawSize(FileSizeUtils.getFileSize(rawPath));
                }
                return photoBean;
            }
        });
    }

    private static Observable<String> createHDThumbnail(String originalPath, final File thumbFile) {
        return Observable.just((Object)originalPath).subscribeOn(Schedulers.newThread()).map((Func1)new Func1<String, String>(){

            public String call(String path) {
                return ThumbnailUtils.createImageThumbnail(path, 2, thumbFile);
            }
        });
    }

    private static Observable<String> createThumbnail(String originalPath, final File thumbFile) {
        return Observable.just((Object)originalPath).subscribeOn(Schedulers.newThread()).map((Func1)new Func1<String, String>(){

            public String call(String path) {
                return ThumbnailUtils.createImageThumbnail(path, 1, thumbFile);
            }
        });
    }

    private static Observable<String> createRawFilePath(String originalPath, File filePath, boolean isOriginalPic) {
        return Observable.just((Object)originalPath).subscribeOn(Schedulers.io()).map((Func1)new Func1<String, String>(){

            public String call(String originalPath) {
                return originalPath;
            }
        });
    }
}

