/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.file.bean;

import com.xdja.im.lib.file.bean.FileItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileCollections {
    private static final Map<String, FileItem> mLocalFileInfo = new HashMap<String, FileItem>();
    private long mSelectedFileSize = 0L;

    private FileCollections() {
    }

    public static FileCollections getInstance() {
        return SingletonInstance.mInstance;
    }

    private FileItem getFileFromCache(String key) {
        return mLocalFileInfo.get(key);
    }

    public void putFileToSelectedCache(String key, FileItem fileInfo) {
        if (fileInfo != null) {
            this.mSelectedFileSize += fileInfo.getFileSize();
            mLocalFileInfo.put(key, fileInfo);
        }
    }

    public void removeToSelectedCache(String key) {
        FileItem fileInfo = this.getFileFromCache(key);
        if (fileInfo != null) {
            this.mSelectedFileSize -= fileInfo.getFileSize();
        }
        mLocalFileInfo.remove(key);
    }

    public List<FileItem> getAllSelectFiles() {
        ArrayList<FileItem> fileInfoList = new ArrayList<FileItem>();
        for (String key : mLocalFileInfo.keySet()) {
            fileInfoList.add(mLocalFileInfo.get(key));
        }
        return fileInfoList;
    }

    public int getSelectedFileCount() {
        return mLocalFileInfo.size();
    }

    public long getSelectedFileSize() {
        return this.mSelectedFileSize;
    }

    public void clearCache() {
        this.mSelectedFileSize = 0L;
        mLocalFileInfo.clear();
    }

    private static class SingletonInstance {
        private static final FileCollections mInstance = new FileCollections();

        private SingletonInstance() {
        }
    }
}

