/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import com.xdja.im.lib.filemanage.adapter.FileGroupViewHolder;
import com.xdja.im.lib.filemanage.adapter.ViewHolder;
import com.xdja.im.uikit.R;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseFileListAdapter<VH extends ViewHolder>
extends BaseExpandableListAdapter {
    static final int TYPE_VERTICAL = 0;
    public static final int TYPE_HORIZONTICAL = 1;
    private List<String> mGroupItems = new ArrayList<String>();

    BaseFileListAdapter(List<String> groupItems) {
        this.mGroupItems = groupItems;
    }

    public int getGroupCount() {
        return this.mGroupItems.size();
    }

    public abstract int getChildrenCount(int var1);

    public Object getGroup(int groupPosition) {
        return this.mGroupItems.get(groupPosition);
    }

    public abstract Object getChild(int var1, int var2);

    protected abstract VH onCreateChildViewHolder(ViewGroup var1, int var2);

    protected abstract void onBindChildViewHolder(VH var1, int var2, int var3);

    public long getGroupId(int groupPosition) {
        return groupPosition;
    }

    public long getChildId(int groupPosition, int childPosition) {
        return childPosition;
    }

    public boolean hasStableIds() {
        return false;
    }

    public boolean isChildSelectable(int groupPosition, int childPosition) {
        return true;
    }

    private FileGroupViewHolder onCreateGroupViewHolder(ViewGroup parent) {
        View convertView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.im_uikit_file_list_item_group, parent, false);
        return new FileGroupViewHolder(convertView);
    }

    private void onBindGroupViewHolder(FileGroupViewHolder holder, int position) {
        if (holder != null) {
            holder.bindData(this.getGroup(position).toString());
        }
    }

    public View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
        FileGroupViewHolder holder;
        if (convertView == null) {
            holder = this.onCreateGroupViewHolder(parent);
            convertView = holder.getConvertView();
            convertView.setTag((Object)holder);
        } else {
            holder = (FileGroupViewHolder)convertView.getTag();
        }
        this.onBindGroupViewHolder(holder, groupPosition);
        return convertView;
    }

    public View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
        ViewHolder<Object> holder;
        if (convertView == null) {
            holder = this.onCreateChildViewHolder(parent, 0);
            convertView = holder.getConvertView();
            convertView.setTag(holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        this.onBindChildViewHolder(holder, groupPosition, childPosition);
        return convertView;
    }
}

