/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.adapter;

import android.app.Activity;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListView;
import com.xdja.im.lib.filemanage.commend.Command;
import com.xdja.im.lib.filemanage.view.AdapterVu;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.util.List;

public abstract class BaseRecyclerViewAdapter<P extends Command, D>
extends RecyclerView.Adapter<CustomViewHolder>
implements View.OnClickListener,
View.OnLongClickListener {
    private LayoutInflater inflater;

    public CustomViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        AdapterVu<P, D> adapterVu = null;
        View convertView = null;
        if (this.inflater == null) {
            this.inflater = (LayoutInflater)parent.getContext().getSystemService("layout_inflater");
        }
        try {
            Class<AdapterVu<P, D>> viewClazz = this.getVuClassByViewType(viewType);
            if (viewClazz != null) {
                adapterVu = viewClazz.newInstance();
                adapterVu.setCommand(this.getCommand());
                adapterVu.setActivity(this.getActivity());
                adapterVu.init(this.inflater, parent);
                convertView = adapterVu.getView();
                convertView.setOnClickListener((View.OnClickListener)this);
                convertView.setOnLongClickListener((View.OnLongClickListener)this);
                convertView.setTag(adapterVu);
                adapterVu.onViewCreated();
            }
        }
        catch (IllegalAccessException ex) {
            LogUtil.e("", ex.getMessage());
        }
        catch (InstantiationException ex) {
            LogUtil.e("", ex.getMessage());
        }
        return new CustomViewHolder(convertView);
    }

    public void onBindViewHolder(CustomViewHolder holder, int position) {
        if (holder != null) {
            AdapterVu adapterVu = (AdapterVu)holder.itemView.getTag();
            adapterVu.bindDataSource(position, this.getDataSource(position));
        }
    }

    public abstract D getDataSource(int var1);

    public abstract P getCommand();

    protected abstract List<Class<? extends AdapterVu<P, D>>> getVuClasses();

    protected abstract Class<? extends AdapterVu<P, D>> getVuClassByViewType(int var1);

    protected Activity getActivity() {
        return null;
    }

    protected ListView getListView() {
        return null;
    }

    protected abstract void clickChildLeaf(View var1, int var2);

    protected abstract void collapseOrExpand(int var1);

    public class CustomViewHolder
    extends RecyclerView.ViewHolder {
        public CustomViewHolder(View itemView) {
            super(itemView);
        }
    }
}

