/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.adapter;

import android.app.Activity;
import android.content.Context;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.CheckBox;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.core.model.event.IMProxyEvent;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.filemanage.adapter.BaseRecyclerViewAdapter;
import com.xdja.im.lib.filemanage.commend.ILastPhotoAndVideoAdapterCommand;
import com.xdja.im.lib.filemanage.model.GridItemBean;
import com.xdja.im.lib.filemanage.model.HistoryFileCategory;
import com.xdja.im.lib.filemanage.util.FileInfoCollection;
import com.xdja.im.lib.filemanage.util.NodeUtils;
import com.xdja.im.lib.filemanage.util.XToast;
import com.xdja.im.lib.filemanage.view.AdapterVu;
import com.xdja.im.lib.filemanage.view.ViewLastGridTitleItem;
import com.xdja.im.lib.filemanage.view.ViewLastPhotoItem;
import com.xdja.im.lib.filemanage.view.ViewLastVideoItem;
import com.xdja.im.uikit.R;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LastPhotoAndVideoAdapter
extends BaseRecyclerViewAdapter<ILastPhotoAndVideoAdapterCommand, GridItemBean>
implements ILastPhotoAndVideoAdapterCommand {
    private static final int PARENT_DIR = 0;
    private static final int CHILD_LEAF = 1;
    private static final int CHILD_LEAF_VIDEO = 2;
    private static final int MIN_CLICK_DELAY_TIME = 500;
    private BusProvider busProvider;
    private Map<HistoryFileCategory, List<TalkMessageBean>> dataMaps;
    private List<GridItemBean> dataSources;
    private Activity activity;
    private long lastClickTime = 0L;
    private CommonSpanSizeLookup spanSizeLookup;
    private RecyclerView recyclerView;
    private List<Class<? extends AdapterVu<ILastPhotoAndVideoAdapterCommand, GridItemBean>>> vuClasses;

    public LastPhotoAndVideoAdapter(BusProvider busProvider, Map<HistoryFileCategory, List<TalkMessageBean>> datas) {
        this.busProvider = busProvider;
        this.dataMaps = datas;
        this.dataSources = NodeUtils.convertData(datas);
    }

    public void setDataSources(Map<HistoryFileCategory, List<TalkMessageBean>> datas) {
        this.dataMaps = datas;
        this.dataSources = NodeUtils.convertData(datas);
    }

    @Override
    public GridItemBean getDataSource(int position) {
        return this.dataSources != null && this.dataSources.size() > 0 ? this.dataSources.get(position) : null;
    }

    @Override
    public ILastPhotoAndVideoAdapterCommand getCommand() {
        return this;
    }

    @Override
    protected List<Class<? extends AdapterVu<ILastPhotoAndVideoAdapterCommand, GridItemBean>>> getVuClasses() {
        if (this.vuClasses == null) {
            this.vuClasses = new ArrayList<Class<? extends AdapterVu<ILastPhotoAndVideoAdapterCommand, GridItemBean>>>();
            this.vuClasses.add(ViewLastGridTitleItem.class);
            this.vuClasses.add(ViewLastPhotoItem.class);
            this.vuClasses.add(ViewLastVideoItem.class);
        }
        return this.vuClasses;
    }

    public int getItemViewType(int position) {
        if (this.dataSources.get(position).isLeaf()) {
            TalkMessageBean dataTalk = (TalkMessageBean)this.dataSources.get(position).getValue();
            FileInfo fileInfo = dataTalk.getFileInfo();
            if (fileInfo.getFileType() == 2) {
                return 2;
            }
            if (fileInfo.getFileType() == 3) {
                return 1;
            }
        }
        return 0;
    }

    @Override
    protected void clickChildLeaf(View view, int position) {
        CheckBox checkBox = null;
        switch (this.getItemViewType(position)) {
            case 1: {
                checkBox = (CheckBox)view.findViewById(R.id.chx_img_file_select);
                break;
            }
            case 2: {
                checkBox = (CheckBox)view.findViewById(R.id.chx_video_file_select);
                break;
            }
        }
        if (checkBox != null) {
            if (FileInfoCollection.getInstance().getSelectedFileCount() >= 9 && !checkBox.isChecked()) {
                new XToast((Context)this.activity).display(String.format(this.activity.getString(R.string.im_uikit_select_file_hint), 9));
                return;
            }
            checkBox.setChecked(!checkBox.isChecked());
        }
    }

    @Override
    protected void collapseOrExpand(int position) {
        GridItemBean bean = this.dataSources.get(position);
        HistoryFileCategory title = (HistoryFileCategory)bean.getValue();
        List<TalkMessageBean> childLists = bean.getChildList();
        List<TalkMessageBean> originChilds = this.dataMaps.get(title);
        if (bean.isExpand()) {
            for (TalkMessageBean fInfo : childLists) {
                GridItemBean<TalkMessageBean> deleteBean = new GridItemBean<TalkMessageBean>();
                deleteBean.setValue(fInfo);
                this.dataSources.remove(deleteBean);
            }
            bean.setExpand(!bean.isExpand());
            this.notifyItemRangeRemoved(position + 1, childLists.size());
        } else {
            ArrayList addChildItem = new ArrayList();
            for (TalkMessageBean fInfo : originChilds) {
                GridItemBean<TalkMessageBean> addBean = new GridItemBean<TalkMessageBean>();
                addBean.setValue(fInfo);
                addBean.setChildList(null);
                addChildItem.add(addBean);
            }
            this.dataSources.addAll(position + 1, addChildItem);
            bean.setExpand(!bean.isExpand());
            this.notifyItemRangeInserted(position + 1, addChildItem.size());
        }
        this.notifyItemChanged(position);
    }

    public int getItemCount() {
        return this.dataSources != null ? this.dataSources.size() : 0;
    }

    public void setActivity(Activity activity) {
        this.activity = activity;
    }

    @Override
    public Activity getActivity() {
        return this.activity;
    }

    public void onClick(View v) {
        int position = this.recyclerView.getChildAdapterPosition(v);
        if (position < 0 || position >= this.dataSources.size()) {
            return;
        }
        switch (this.getItemViewType(position)) {
            case 0: {
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.lastClickTime <= 500L) break;
                this.lastClickTime = currentTime;
                this.collapseOrExpand(position);
                break;
            }
            case 1: 
            case 2: {
                this.clickChildLeaf(v, position);
                break;
            }
        }
    }

    public boolean onLongClick(View v) {
        return false;
    }

    private CommonSpanSizeLookup getSpanSizeLookup() {
        if (this.spanSizeLookup == null) {
            this.spanSizeLookup = new CommonSpanSizeLookup();
        }
        return this.spanSizeLookup;
    }

    public void setLayoutManager(int col) {
        GridLayoutManager layoutManager = new GridLayoutManager((Context)this.activity, col);
        layoutManager.setSpanSizeLookup((GridLayoutManager.SpanSizeLookup)this.getSpanSizeLookup());
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
    }

    public void setRecyclerView(RecyclerView recyclerView) {
        this.recyclerView = recyclerView;
    }

    @Override
    protected Class<? extends AdapterVu<ILastPhotoAndVideoAdapterCommand, GridItemBean>> getVuClassByViewType(int itemViewType) {
        Class<? extends AdapterVu<ILastPhotoAndVideoAdapterCommand, GridItemBean>> clazz = null;
        switch (itemViewType) {
            case 1: {
                clazz = this.getVuClasses().get(1);
                break;
            }
            case 0: {
                clazz = this.getVuClasses().get(0);
                break;
            }
            case 2: {
                clazz = this.getVuClasses().get(2);
            }
        }
        return clazz;
    }

    @Override
    public void toRefreshSelectHint(FileItem localFileInfo) {
        IMProxyEvent.FileSelectedEvent event = new IMProxyEvent.FileSelectedEvent(localFileInfo);
        this.busProvider.post(event);
    }

    private class CommonSpanSizeLookup
    extends GridLayoutManager.SpanSizeLookup {
        private CommonSpanSizeLookup() {
        }

        public int getSpanSize(int position) {
            int viewType = LastPhotoAndVideoAdapter.this.getItemViewType(position);
            if (viewType == 0) {
                return 4;
            }
            return 1;
        }
    }
}

