/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.util;

import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.filemanage.model.LocalPictureInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FileInfoCollection {
    private static Map<String, LocalPictureInfo> localPicInfo;
    private static final Map<String, FileItem> mFileItem;
    private long mSelectedFileSize = 0L;

    private FileInfoCollection() {
    }

    public static FileInfoCollection getInstance() {
        return SingletonInstance.mInstance;
    }

    public static synchronized Map<String, LocalPictureInfo> getLocalPicInfo() {
        if (localPicInfo == null) {
            localPicInfo = new LinkedHashMap<String, LocalPictureInfo>();
        }
        return localPicInfo;
    }

    private FileItem getFileFromCache(String key) {
        return mFileItem.get(key);
    }

    public void putFileToSelectedCache(String key, FileItem fileInfo) {
        if (fileInfo != null) {
            this.mSelectedFileSize += fileInfo.getFileSize();
            mFileItem.put(key, fileInfo);
        }
    }

    public void removeToSelectedCache(String key) {
        FileItem fileInfo = this.getFileFromCache(key);
        if (fileInfo != null) {
            this.mSelectedFileSize -= fileInfo.getFileSize();
        }
        mFileItem.remove(key);
    }

    public List<FileItem> getAllSelectFiles() {
        ArrayList<FileItem> fileInfoList = new ArrayList<FileItem>();
        for (String key : mFileItem.keySet()) {
            fileInfoList.add(mFileItem.get(key));
        }
        return fileInfoList;
    }

    public int getSelectedFileCount() {
        return mFileItem.size();
    }

    public long getSelectedFileSize() {
        return this.mSelectedFileSize;
    }

    public void clearCache() {
        this.mSelectedFileSize = 0L;
        mFileItem.clear();
    }

    static {
        mFileItem = new HashMap<String, FileItem>();
    }

    private static class SingletonInstance {
        private static final FileInfoCollection mInstance = new FileInfoCollection();

        private SingletonInstance() {
        }
    }
}

