/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.util;

import android.text.TextUtils;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.lib.filemanage.util.ActomaController;
import com.xdja.im.lib.filemanage.util.ToolUtil;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.imsdk.util.FileUtils;
import com.xdja.imsdk.util.ThumbnailUtils;
import com.xdja.imsdk.util.ToolUtils;
import java.io.File;
import java.util.UUID;
import rx.Observable;
import rx.functions.Func1;
import rx.functions.Func3;
import rx.schedulers.Schedulers;

public class ModelGenerator {
    public static Observable<FileInfo> createImageFileInfo(final ImageFileInfo pictureInfo, String account) {
        if (pictureInfo == null || TextUtils.isEmpty((CharSequence)account)) {
            return null;
        }
        if ("gif".equalsIgnoreCase(pictureInfo.getSuffix())) {
            return ModelGenerator.createGifImageFileInfo(pictureInfo, account, false);
        }
        String imageFilePath = pictureInfo.getFilePath();
        try {
            File file = new File(imageFilePath);
            if (!file.exists()) {
                return Observable.error((Throwable)new Throwable(ActomaController.getAppConfigContext().getString(R.string.im_uikit_file_not_exist)));
            }
        }
        catch (Exception e) {
            LogUtil.e("", e);
        }
        String imageRootPath = ModelGenerator.getRootFilePath(account);
        String baseFileName = UUID.randomUUID().toString();
        String thumbName = "th_" + baseFileName;
        String hdThumbName = "th_" + baseFileName + "_hd";
        return Observable.zip(ModelGenerator.createHDThumbnail(pictureInfo.getFilePath(), new File(imageRootPath, hdThumbName)), ModelGenerator.createThumbnail(pictureInfo.getFilePath(), new File(imageRootPath, thumbName)), ModelGenerator.createRawFilePath(pictureInfo.getFilePath(), new File(imageRootPath, baseFileName), true), (Func3)new Func3<String, String, String, FileInfo>(){

            public ImageFileInfo call(String hdThumbFilePath, String thumbFilePath, String rawFilePath) {
                return pictureInfo;
            }
        });
    }

    public static Observable<FileInfo> createPictureFileInfo(final ImageFileInfo pictureInfo, String account) {
        if (pictureInfo == null || TextUtils.isEmpty((CharSequence)account)) {
            return null;
        }
        if ("gif".equalsIgnoreCase(pictureInfo.getSuffix())) {
            return ModelGenerator.createGifImageFileInfo(pictureInfo, account, true);
        }
        String imageFilePath = pictureInfo.getFilePath();
        try {
            File file = new File(imageFilePath);
            if (!file.exists()) {
                return Observable.error((Throwable)new Throwable(ActomaController.getAppConfigContext().getString(R.string.im_uikit_file_not_exist)));
            }
        }
        catch (Exception e) {
            LogUtil.e("", e);
        }
        String imageRootPath = ModelGenerator.getRootFilePath(account);
        final String baseFileName = UUID.randomUUID().toString();
        final String thumbName = "th_" + baseFileName;
        final String hdThumbName = "th_" + baseFileName + "_hd";
        return Observable.zip(ModelGenerator.createHDThumbnail(pictureInfo.getFilePath(), new File(imageRootPath, hdThumbName)), ModelGenerator.createThumbnail(pictureInfo.getFilePath(), new File(imageRootPath, thumbName)), ModelGenerator.createRawFilePath(pictureInfo.getFilePath(), new File(imageRootPath, baseFileName), true), (Func3)new Func3<String, String, String, FileInfo>(){

            public ImageFileInfo call(String hdThumbFilePath, String thumbFilePath, String rawFilePath) {
                if (TextUtils.isEmpty((CharSequence)hdThumbFilePath) || TextUtils.isEmpty((CharSequence)thumbFilePath) || TextUtils.isEmpty((CharSequence)rawFilePath)) {
                    return null;
                }
                ImageFileInfo imageFileInfo = new ImageFileInfo();
                imageFileInfo.setFileName(thumbName);
                imageFileInfo.setFilePath(thumbFilePath);
                imageFileInfo.setFileSize(ToolUtil.getFileSize(thumbFilePath));
                imageFileInfo.setTranslateSize(0L);
                String suffix = ToolUtil.getLastString(rawFilePath, ".");
                if (!ToolUtils.isImageSuffix((String)suffix)) {
                    suffix = ".jpeg".substring(1);
                }
                imageFileInfo.setSuffix(suffix);
                FileInfo fileExtraInfo = new FileInfo();
                fileExtraInfo.setFileName(hdThumbName);
                fileExtraInfo.setFilePath(hdThumbFilePath);
                fileExtraInfo.setFileSize(ToolUtil.getFileSize(hdThumbFilePath));
                FileInfo rawExtraInfo = new FileInfo();
                rawExtraInfo.setFileName(baseFileName);
                rawExtraInfo.setFilePath(rawFilePath);
                rawExtraInfo.setFileSize(pictureInfo.getFileSize());
                imageFileInfo.setOriginal(true);
                imageFileInfo.setFileType(3);
                imageFileInfo.setHdFileInfo(fileExtraInfo);
                imageFileInfo.setRawFileInfo(rawExtraInfo);
                return imageFileInfo;
            }
        });
    }

    public static Observable<String> createHDThumbnail(String originalPath, final File thumbFile) {
        return Observable.just((Object)originalPath).subscribeOn(Schedulers.newThread()).map((Func1)new Func1<String, String>(){

            public String call(String path) {
                return ThumbnailUtils.createImageThumbnail((String)path, (int)2, (File)thumbFile);
            }
        });
    }

    public static Observable<String> createThumbnail(String originalPath, final File thumbFile) {
        return Observable.just((Object)originalPath).subscribeOn(Schedulers.newThread()).map((Func1)new Func1<String, String>(){

            public String call(String path) {
                return ThumbnailUtils.createImageThumbnail((String)path, (int)1, (File)thumbFile);
            }
        });
    }

    public static Observable<String> createRawFilePath(String originalPath, File filePath, boolean isOriginalPic) {
        return Observable.just((Object)originalPath).subscribeOn(Schedulers.io()).map((Func1)new Func1<String, String>(){

            public String call(String originalPath) {
                return originalPath;
            }
        });
    }

    public static Observable<FileInfo> createGifImageFileInfo(final ImageFileInfo pictureInfo, String account, boolean isFile) {
        if (pictureInfo == null || TextUtils.isEmpty((CharSequence)account)) {
            return null;
        }
        String imageFilePath = pictureInfo.getFilePath();
        try {
            File file = new File(imageFilePath);
            if (!file.exists()) {
                return Observable.error((Throwable)new Throwable(ActomaController.getAppConfigContext().getString(R.string.im_uikit_file_not_exist)));
            }
        }
        catch (Exception e) {
            LogUtil.e("", e);
        }
        String imageRootPath = ModelGenerator.getRootFilePath(account);
        String baseFileName = UUID.randomUUID().toString();
        String thumbName = "th_" + baseFileName;
        return Observable.zip(ModelGenerator.createRawFilePath(pictureInfo.getFilePath(), new File(imageRootPath, baseFileName), false), ModelGenerator.createGifFirstFrameFilePath(pictureInfo.getFilePath(), new File(imageRootPath, thumbName)), ModelGenerator.createRawFilePath(pictureInfo.getFilePath(), new File(imageRootPath, baseFileName), true), (Func3)new Func3<String, String, String, FileInfo>(){

            public ImageFileInfo call(String hdThumbFilePath, String thumbFilePath, String rawFilePath) {
                return pictureInfo;
            }
        });
    }

    public static Observable<String> createGifFirstFrameFilePath(String originalPath, File thumbFile) {
        return Observable.just((Object)originalPath).subscribeOn(Schedulers.io()).map((Func1)new Func1<String, String>(){

            public String call(String originalPath) {
                return null;
            }
        });
    }

    public static String getRootFilePath(String account) {
        File imageCacheFile = new File(FileUtils.getImagePath());
        if (!imageCacheFile.isDirectory()) {
            imageCacheFile.deleteOnExit();
        }
        if (!imageCacheFile.exists()) {
            if (imageCacheFile.mkdirs()) {
                return imageCacheFile.getAbsolutePath();
            }
        } else {
            return imageCacheFile.getAbsolutePath();
        }
        return FileUtils.getImagePath();
    }

    public static ImageFileInfo createContentImageFile(String path, String account) {
        if (path == null || TextUtils.isEmpty((CharSequence)account)) {
            return null;
        }
        try {
            String imageRootPath = ModelGenerator.getRootFilePath(account);
            String baseFileName = UUID.randomUUID().toString();
            String thumbName = "th_" + baseFileName;
            String hdThumbName = "th_" + baseFileName + "_hd";
            String hdThumbFilePath = ThumbnailUtils.createImageThumbnail((String)path, (int)2, (File)new File(imageRootPath, hdThumbName));
            String thumbFilePath = ThumbnailUtils.createImageThumbnail((String)path, (int)1, (File)new File(imageRootPath, thumbName));
            ImageFileInfo imageFileInfo = new ImageFileInfo();
            imageFileInfo.setFileName(thumbName);
            imageFileInfo.setFilePath(thumbFilePath);
            imageFileInfo.setFileSize(ToolUtil.getFileSize(thumbFilePath));
            imageFileInfo.setTranslateSize(0L);
            String suffix = ToolUtil.getLastString(path, ".");
            if (!ToolUtils.isImageSuffix((String)suffix)) {
                suffix = ".jpeg".substring(1);
            }
            imageFileInfo.setSuffix(suffix);
            FileInfo fileExtraInfo = new FileInfo();
            fileExtraInfo.setFileName(hdThumbName);
            fileExtraInfo.setFilePath(hdThumbFilePath);
            fileExtraInfo.setFileSize(ToolUtil.getFileSize(hdThumbFilePath));
            FileInfo rawExtraInfo = new FileInfo();
            rawExtraInfo.setFileName(baseFileName);
            imageFileInfo.setOriginal(false);
            imageFileInfo.setHdFileInfo(fileExtraInfo);
            return imageFileInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

