/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.drawable.Drawable;
import android.preference.PreferenceManager;
import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import com.xdja.im.lib.filemanage.util.ActomaController;
import com.xdja.im.uikit.R;

public class TextUtil {
    private static final int PASSWORD_LENGHT = 20;
    private static final int NICKNAME_LENGHT = 16;

    public static Spanned getActomaText(final Context context, @ActomaImage.ActomaImageType int imageType, final int imageMarginTop, final int imageWidth, final int imageHeight, String content) {
        int image;
        if (context == null || TextUtils.isEmpty((CharSequence)content)) {
            return null;
        }
        if (!content.contains("+")) {
            return Html.fromHtml((String)content);
        }
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        boolean style2 = sharedPreferences != null && sharedPreferences.getInt("theme_style-" + ActomaController.getMark(), 0) != 0;
        switch (imageType) {
            case 0: {
                image = style2 ? R.drawable.im_uikit_at_version_light : R.drawable.im_uikit_at_version;
                break;
            }
            case 1: {
                image = style2 ? R.drawable.im_uikit_at_title_light : R.drawable.im_uikit_at_title;
                break;
            }
            case 2: {
                image = style2 ? R.drawable.im_uikit_at_list_light : R.drawable.im_uikit_at_list;
                break;
            }
            case 3: {
                image = style2 ? R.drawable.im_uikit_at_notification_big_light : R.drawable.im_uikit_at_notification_big;
                break;
            }
            case 4: {
                image = style2 ? R.drawable.im_uikit_at_notification_small_light : R.drawable.im_uikit_at_notification_small;
                break;
            }
            case 5: {
                image = style2 ? R.drawable.im_uikit_at_info_light : R.drawable.im_uikit_at_info;
                break;
            }
            case 6: {
                image = style2 ? R.drawable.im_uikit_at_version_big_light : R.drawable.im_uikit_at_version_big;
                break;
            }
            case 7: {
                image = style2 ? R.drawable.im_uikit_at_toast_light : R.drawable.im_uikit_at_toast;
                break;
            }
            case 8: {
                image = style2 ? R.drawable.im_uikit_antong_login_light : R.drawable.im_uikit_antong_login;
                break;
            }
            case 9: {
                image = style2 ? R.drawable.im_uikit_at_version_big_red_light : R.drawable.im_uikit_at_version_big_red;
                break;
            }
            case 10: {
                image = style2 ? R.drawable.im_uikit_at_input_hint_light : R.drawable.im_uikit_at_input_hint;
                break;
            }
            case 11: {
                image = style2 ? R.drawable.im_uikit_at_company_light : R.drawable.im_uikit_at_company;
                break;
            }
            default: {
                image = style2 ? R.drawable.im_uikit_at_list_light : R.drawable.im_uikit_at_list;
            }
        }
        Html.ImageGetter imageGetter = new Html.ImageGetter(){

            public Drawable getDrawable(String source) {
                int id2 = Integer.parseInt(source);
                Drawable d = context.getResources().getDrawable(id2);
                if (d == null) {
                    return null;
                }
                d.setBounds(0, imageMarginTop, imageWidth == 0 ? d.getIntrinsicWidth() : imageWidth, imageHeight == 0 ? d.getMinimumHeight() : imageHeight);
                return d;
            }
        };
        String source = "";
        String imageString = "<img src=\"" + image + "\">";
        String[] split = content.split("\\+");
        if (content.startsWith("+")) {
            source = imageString;
        }
        for (int i = 0; i < split.length; ++i) {
            source = i != split.length - 1 ? source + split[i] + imageString : source + split[i];
        }
        if (content.endsWith("+")) {
            source = source + imageString;
        }
        return Html.fromHtml((String)source, (Html.ImageGetter)imageGetter, null);
    }

    public static class ActomaImage {
        public static final int IMAGE_VERSION = 0;
        public static final int IMAGE_TITLE = 1;
        public static final int IMAGE_LIST = 2;
        public static final int IMAGE_NOTIFICATION_BIG = 3;
        public static final int IMAGE_NOTIFICATION_SMALL = 4;
        public static final int IMAGE_INFO = 5;
        public static final int IMAGE_VERSION_BIG = 6;
        public static final int IMAGE_TOAST = 7;
        public static final int IMAGE_LOGIN = 8;
        public static final int IMAGE_VERSION_BIG_RED = 9;
        public static final int IMAGE_INPUT_HINT = 10;
        public static final int IMAGE_COMPANY_NOT_AT = 11;

        public static @interface ActomaImageType {
        }
    }
}

