/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.historyfile.adapter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.SystemClock;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.CheckBox;
import android.widget.ImageView;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.core.model.event.IMProxyMessageEvent;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.VideoFileInfo;
import com.xdja.im.core.repository.interf.ProxyRepository;
import com.xdja.im.lib.filemanage.adapter.BaseRecyclerViewAdapter;
import com.xdja.im.lib.filemanage.model.GridItemBean;
import com.xdja.im.lib.filemanage.util.DateUtils;
import com.xdja.im.lib.filemanage.util.HistoryFileUtils;
import com.xdja.im.lib.filemanage.util.XToast;
import com.xdja.im.lib.filemanage.view.AdapterVu;
import com.xdja.im.lib.historyfile.command.IHistoryPhotoAndVideoAdapterCommand;
import com.xdja.im.lib.historyfile.ui.HistoryFileActivityPresenter;
import com.xdja.im.lib.historyfile.util.HistoryModeUtils;
import com.xdja.im.lib.historyfile.vu.ViewHistoryGridTitleItem;
import com.xdja.im.lib.historyfile.vu.ViewHistoryPhotoItem;
import com.xdja.im.lib.historyfile.vu.ViewHistoryVideoItem;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.activity.HistoryFilePreviewActivity;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.view.CircleProgressBar;
import dagger.Lazy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import rx.Subscriber;

public class HistoryPhotoAndVideoAdapter
extends BaseRecyclerViewAdapter<IHistoryPhotoAndVideoAdapterCommand, GridItemBean>
implements IHistoryPhotoAndVideoAdapterCommand {
    private static final int PARENT_DIR = 0;
    private static final int CHILD_LEAF = 1;
    private static final int CHILD_LEAF_VIDEO = 2;
    private static final int MIN_CLICK_DELAY_TIME = 500;
    private BusProvider busProvider;
    private List<GridItemBean> dataSources;
    private Activity activity;
    private long lastClickTime = 0L;
    private CommonSpanSizeLookup spanSizeLookup;
    private RecyclerView recyclerView;
    private String talkFlag;
    private int mCurrentOperate;
    private List<Class<? extends AdapterVu<IHistoryPhotoAndVideoAdapterCommand, GridItemBean>>> vuClasses;
    @Inject
    Lazy<ProxyRepository> proxyRepository;

    public HistoryPhotoAndVideoAdapter(String talkFlag, BusProvider busProvider, List<GridItemBean> dataSources) {
        this.talkFlag = talkFlag;
        this.busProvider = busProvider;
        this.dataSources = dataSources;
    }

    @Override
    public GridItemBean getDataSource(int position) {
        return this.dataSources != null && this.dataSources.size() > 0 ? this.dataSources.get(position) : null;
    }

    @Override
    public IHistoryPhotoAndVideoAdapterCommand getCommand() {
        return this;
    }

    @Override
    public void sendReadReceipt(TalkMessageBean talkMessageBean) {
        ((ProxyRepository)this.proxyRepository.get()).changeMessageState(talkMessageBean, 4, new Subscriber<Integer>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
            }

            public void onNext(Integer integer) {
                if (integer == 0) {
                    LogUtil.d("", "\u6d88\u606f\u5df2\u8bfb\u72b6\u6001\u66f4\u6539\u6210\u529f");
                    for (GridItemBean gridItemBean : HistoryPhotoAndVideoAdapter.this.dataSources) {
                        if (!gridItemBean.isLeaf()) continue;
                        TalkMessageBean bean = (TalkMessageBean)gridItemBean.getValue();
                        bean.setMessageState(4);
                        HistoryPhotoAndVideoAdapter.this.notifyDataSetChanged();
                    }
                } else {
                    LogUtil.d("", "\u6d88\u606f\u5df2\u8bfb\u72b6\u6001\u66f4\u6539\u5931\u8d25");
                }
            }
        });
    }

    @Override
    protected List<Class<? extends AdapterVu<IHistoryPhotoAndVideoAdapterCommand, GridItemBean>>> getVuClasses() {
        if (this.vuClasses == null) {
            this.vuClasses = new ArrayList<Class<? extends AdapterVu<IHistoryPhotoAndVideoAdapterCommand, GridItemBean>>>();
            this.vuClasses.add(ViewHistoryGridTitleItem.class);
            this.vuClasses.add(ViewHistoryPhotoItem.class);
            this.vuClasses.add(ViewHistoryVideoItem.class);
        }
        return this.vuClasses;
    }

    public int getItemViewType(int position) {
        if (this.dataSources.get(position).isLeaf()) {
            TalkMessageBean dataTalk = (TalkMessageBean)this.dataSources.get(position).getValue();
            FileInfo fileInfo = dataTalk.getFileInfo();
            if (fileInfo.getFileType() == 2) {
                return 2;
            }
            if (fileInfo.getFileType() == 3) {
                return 1;
            }
        }
        return 0;
    }

    @Override
    protected void clickChildLeaf(View view, int position) {
        if (this.mCurrentOperate != 0) {
            CheckBox checkBox = null;
            switch (this.getItemViewType(position)) {
                case 1: {
                    checkBox = (CheckBox)view.findViewById(R.id.chx_img_file_select);
                    break;
                }
                case 2: {
                    checkBox = (CheckBox)view.findViewById(R.id.chx_video_file_select);
                    break;
                }
            }
            if (checkBox != null) {
                if (HistoryModeUtils.getInstance().getSelectedFileCount() >= 9 && !checkBox.isChecked() && this.mCurrentOperate != 3) {
                    new XToast((Context)this.getActivity()).display(String.format(this.activity.getString(R.string.im_uikit_select_file_hint), 9));
                    return;
                }
                checkBox.setChecked(!checkBox.isChecked());
            }
        } else {
            TalkMessageBean talkMessageBean = (TalkMessageBean)this.dataSources.get(position).getValue();
            if (!HistoryFileUtils.isFileExist(talkMessageBean)) {
                if (DateUtils.isOverdue(talkMessageBean.getShowTime())) {
                    new XToast((Context)this.activity).display(R.string.im_uikit_history_select_all_overdue);
                    return;
                }
                FileInfo fileInfo = talkMessageBean.getFileInfo();
                if (fileInfo instanceof VideoFileInfo && ((VideoFileInfo)fileInfo).getFileSize() != 0L) {
                    ArrayList<FileInfo> downloadInfos = new ArrayList<FileInfo>();
                    ((VideoFileInfo)fileInfo).setType(3);
                    downloadInfos.add(fileInfo);
                    ((HistoryFileActivityPresenter)this.getActivity()).showDialogDownloadFile(downloadInfos);
                    return;
                }
            }
            Intent intent = new Intent();
            intent.setClass((Context)this.getActivity(), HistoryFilePreviewActivity.class);
            intent.putExtra("talkerId", this.talkFlag);
            intent.putExtra("messageId", talkMessageBean.getId());
            intent.putExtra("isFromFileHistory", true);
            this.getActivity().startActivity(intent);
        }
    }

    @Override
    protected void collapseOrExpand(int position) {
        GridItemBean bean = this.dataSources.get(position);
        List<TalkMessageBean> childLists = bean.getChildList();
        if (childLists == null) {
            return;
        }
        if (bean.isExpand()) {
            for (TalkMessageBean fInfo : childLists) {
                GridItemBean<TalkMessageBean> deleteBean = new GridItemBean<TalkMessageBean>();
                deleteBean.setValue(fInfo);
                this.dataSources.remove(deleteBean);
            }
            bean.setExpand(!bean.isExpand());
            this.notifyItemRangeRemoved(position + 1, childLists.size());
        } else {
            ArrayList addChildItem = new ArrayList();
            for (TalkMessageBean fInfo : childLists) {
                GridItemBean<TalkMessageBean> addBean = new GridItemBean<TalkMessageBean>();
                addBean.setValue(fInfo);
                addBean.setChildList(null);
                addChildItem.add(addBean);
            }
            this.dataSources.addAll(position + 1, addChildItem);
            bean.setExpand(!bean.isExpand());
            this.notifyItemRangeInserted(position + 1, addChildItem.size());
        }
        this.notifyItemChanged(position);
    }

    public int getItemCount() {
        return this.dataSources != null ? this.dataSources.size() : 0;
    }

    public void setActivity(Activity activity) {
        this.activity = activity;
    }

    @Override
    public Activity getActivity() {
        return this.activity;
    }

    public void onClick(View v) {
        int position = this.recyclerView.getChildAdapterPosition(v);
        if (position < 0 || position >= this.dataSources.size()) {
            LogUtil.d("", "error position = " + position);
            return;
        }
        switch (this.getItemViewType(position)) {
            case 0: {
                long currentTime = SystemClock.elapsedRealtime();
                if (currentTime - this.lastClickTime <= 500L) break;
                this.lastClickTime = currentTime;
                this.collapseOrExpand(position);
                break;
            }
            case 1: 
            case 2: {
                this.clickChildLeaf(v, position);
                break;
            }
        }
    }

    public boolean onLongClick(View v) {
        int position = this.recyclerView.getChildAdapterPosition(v);
        if (position < 0 || position >= this.dataSources.size()) {
            LogUtil.d("", "error position = " + position);
            return false;
        }
        switch (this.getItemViewType(position)) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                if (this.mCurrentOperate != 0) break;
                TalkMessageBean talkMessageBean = (TalkMessageBean)this.dataSources.get(position).getValue();
                ArrayList<Long> deleteIds = new ArrayList<Long>();
                deleteIds.add(talkMessageBean.getId());
                ArrayList<TalkMessageBean> deleteBeans = new ArrayList<TalkMessageBean>();
                deleteBeans.add(talkMessageBean);
                ((HistoryFileActivityPresenter)this.getActivity()).showRemoveDialog(deleteIds, deleteBeans);
                return true;
            }
        }
        return false;
    }

    private CommonSpanSizeLookup getSpanSizeLookup() {
        if (this.spanSizeLookup == null) {
            this.spanSizeLookup = new CommonSpanSizeLookup();
        }
        return this.spanSizeLookup;
    }

    public void setLayoutManager(int gridColumn) {
        GridLayoutManager layoutManager = new GridLayoutManager((Context)this.activity, gridColumn);
        layoutManager.setSpanSizeLookup((GridLayoutManager.SpanSizeLookup)this.getSpanSizeLookup());
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
    }

    public void setRecyclerView(RecyclerView recyclerView) {
        this.recyclerView = recyclerView;
    }

    @Override
    protected Class<? extends AdapterVu<IHistoryPhotoAndVideoAdapterCommand, GridItemBean>> getVuClassByViewType(int itemViewType) {
        Class<? extends AdapterVu<IHistoryPhotoAndVideoAdapterCommand, GridItemBean>> clazz = null;
        switch (itemViewType) {
            case 1: {
                clazz = this.getVuClasses().get(1);
                break;
            }
            case 0: {
                clazz = this.getVuClasses().get(0);
                break;
            }
            case 2: {
                clazz = this.getVuClasses().get(2);
            }
        }
        return clazz;
    }

    @Override
    public void toRefreshSelectHint() {
        IMProxyMessageEvent.HistoryRefreshSelectHintEvent event = new IMProxyMessageEvent.HistoryRefreshSelectHintEvent();
        this.busProvider.post(event);
    }

    public void updateMode(int operateAction) {
        this.mCurrentOperate = operateAction;
        Iterator<GridItemBean> iterator = this.dataSources.iterator();
        while (iterator.hasNext()) {
            GridItemBean gridItemBean = iterator.next();
            if (gridItemBean.isLeaf()) {
                TalkMessageBean bean = (TalkMessageBean)gridItemBean.getValue();
                if (this.mCurrentOperate == 2) {
                    if (!HistoryFileUtils.isForwardFileExist(bean)) {
                        iterator.remove();
                        continue;
                    }
                } else if (this.mCurrentOperate == 1 && (HistoryFileUtils.isFileExist(bean) || !HistoryFileUtils.isFileExist(bean) && !bean.isMine() && DateUtils.isOverdue(bean.getShowTime()))) {
                    iterator.remove();
                    continue;
                }
                bean.setFileOperate(this.mCurrentOperate);
                if (this.mCurrentOperate == 0) continue;
                bean.setChecked(false);
                continue;
            }
            List<TalkMessageBean> childList = gridItemBean.getChildList();
            Iterator<TalkMessageBean> it = childList.iterator();
            while (it.hasNext()) {
                TalkMessageBean talkMessageBean = it.next();
                if (this.mCurrentOperate == 2) {
                    if (!HistoryFileUtils.isForwardFileExist(talkMessageBean)) {
                        it.remove();
                        if (!childList.isEmpty()) continue;
                        iterator.remove();
                        continue;
                    }
                } else if (this.mCurrentOperate == 1 && (HistoryFileUtils.isFileExist(talkMessageBean) || !HistoryFileUtils.isFileExist(talkMessageBean) && !talkMessageBean.isMine() && DateUtils.isOverdue(talkMessageBean.getShowTime()))) {
                    it.remove();
                    if (!childList.isEmpty()) continue;
                    iterator.remove();
                    continue;
                }
                talkMessageBean.setFileOperate(this.mCurrentOperate);
                if (this.mCurrentOperate == 0) continue;
                talkMessageBean.setChecked(false);
            }
        }
        this.notifyDataSetChanged();
    }

    public int getLeafPosition(long msgId) {
        int position = -1;
        for (GridItemBean gridItemBean : this.dataSources) {
            TalkMessageBean talkMessageBean;
            ++position;
            if (!gridItemBean.isLeaf() || (talkMessageBean = (TalkMessageBean)gridItemBean.getValue()).getId() != msgId) continue;
            return position;
        }
        return -1;
    }

    public void refreshItem(long msgId, FileInfo fileInfo) {
        int leafPosition = this.getLeafPosition(msgId);
        GridLayoutManager gridLayoutManager = (GridLayoutManager)this.recyclerView.getLayoutManager();
        int firstVisiblePos = gridLayoutManager.findFirstVisibleItemPosition();
        int lastVisblePos = gridLayoutManager.findLastVisibleItemPosition();
        if (leafPosition < 0 || leafPosition >= this.dataSources.size() || leafPosition < firstVisiblePos || lastVisblePos > lastVisblePos) {
            return;
        }
        GridItemBean gridItemBean = this.dataSources.get(leafPosition);
        TalkMessageBean itemBean = (TalkMessageBean)gridItemBean.getValue();
        int aPos = leafPosition - firstVisiblePos;
        View itemView = this.recyclerView.getChildAt(aPos);
        if (itemView == null || itemBean == null) {
            return;
        }
        itemBean.getFileInfo().setTranslatePercent(fileInfo.getTranslatePercent());
        CircleProgressBar cpb = null;
        switch (this.getItemViewType(leafPosition)) {
            case 1: {
                cpb = (CircleProgressBar)itemView.findViewById(R.id.image_down_cpb);
                break;
            }
            case 2: {
                cpb = (CircleProgressBar)itemView.findViewById(R.id.video_down_cpb);
                ImageView playButton = (ImageView)itemView.findViewById(R.id.history_file_video_btn_player);
                if (playButton == null) break;
                playButton.setVisibility(fileInfo.getFileState() == 3 ? 8 : 0);
                break;
            }
            default: {
                return;
            }
        }
        if (cpb != null) {
            if (fileInfo.getFileState() == 3) {
                cpb.setVisibility(0);
                cpb.setProgress(itemBean.getFileInfo().getTranslatePercent());
            } else {
                cpb.setVisibility(8);
            }
        }
    }

    public void randomRemoveLeafItem(long msgId) {
        int leafPosition = this.getLeafPosition(msgId);
        if (leafPosition < 0 || leafPosition >= this.dataSources.size()) {
            return;
        }
        if (!this.dataSources.get(leafPosition - 1).isLeaf() && (leafPosition + 1 == this.dataSources.size() || leafPosition + 1 < this.dataSources.size() && !this.dataSources.get(leafPosition + 1).isLeaf())) {
            this.removeLeafBeanFromDir((TalkMessageBean)this.dataSources.get(leafPosition).getValue());
            this.dataSources.remove(leafPosition);
            this.dataSources.remove(leafPosition - 1);
            this.notifyItemRangeRemoved(leafPosition - 1, 2);
            return;
        }
        this.removeLeafBeanFromDir((TalkMessageBean)this.dataSources.get(leafPosition).getValue());
        this.dataSources.remove(leafPosition);
        this.notifyItemRangeRemoved(leafPosition, 1);
    }

    private void removeLeafBeanFromDir(TalkMessageBean deletBean) {
        for (GridItemBean gridItemBean : this.dataSources) {
            if (gridItemBean.isLeaf() || !gridItemBean.getChildList().contains(deletBean)) continue;
            gridItemBean.getChildList().remove(deletBean);
        }
    }

    private class CommonSpanSizeLookup
    extends GridLayoutManager.SpanSizeLookup {
        private CommonSpanSizeLookup() {
        }

        public int getSpanSize(int position) {
            int viewType = HistoryPhotoAndVideoAdapter.this.getItemViewType(position);
            if (viewType == 0) {
                return 4;
            }
            return 1;
        }
    }
}

