/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.share.view;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.SpannableString;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.lib.emoji.utils.EmotionUtils;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.filemanage.util.IMFileUtils;
import com.xdja.im.lib.share.model.IntentBean;
import com.xdja.im.lib.share.model.ShareBean;
import com.xdja.im.lib.share.model.WebPageInfo;
import com.xdja.im.lib.share.presenter.ShareSessionListPresenter;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.ObjectUtil;
import com.xdja.im.uikit.view.CircleImageView;
import com.xdja.im.uikit.view.PastEditText;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class ShareDialog {
    private Context context;
    private TextView sharedialogtv;
    private CircleImageView sharedialogusericon;
    private TextView sharedialogusername;
    private LinearLayout sharedialogsingleuserlayout;
    private LinearLayout sharedialogmoreuserlayout;
    private ImageView sharedialogimageContent;
    private TextView sharedialogtextContent;
    private LinearLayout sharedialogcontentLayout;
    private PastEditText sharedialogmessageContent;
    private LinearLayout sharedialogeditLayout;
    private TextView sharedialogcancelbtn;
    private TextView sharedialogsendbtn;
    private LinearLayout sharedialogbuttonLayout;
    private AlertDialog alertDialog;
    private ShareSessionListPresenter shareSessionListPresenter;
    private List<ShareBean> list = new ArrayList<ShareBean>();
    private IntentBean intentBean;
    private int type = -1;
    private boolean isForward = false;
    private Intent intent;

    public ShareDialog(@NonNull Context context, int type, ShareSessionListPresenter shareSessionListPresenter) {
        this.type = type;
        this.shareSessionListPresenter = shareSessionListPresenter;
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        this.alertDialog = builder.create();
        View view = LayoutInflater.from((Context)context).inflate(R.layout.im_uikit_share_dialog_layout, null);
        this.sharedialogbuttonLayout = (LinearLayout)view.findViewById(R.id.share_dialog_buttonLayout);
        this.sharedialogsendbtn = (TextView)view.findViewById(R.id.share_dialog_send_btn);
        this.sharedialogcancelbtn = (TextView)view.findViewById(R.id.share_dialog_cancel_btn);
        this.sharedialogeditLayout = (LinearLayout)view.findViewById(R.id.share_dialog_edit_Layout);
        this.sharedialogmessageContent = (PastEditText)view.findViewById(R.id.share_dialog_messageContent);
        this.sharedialogcontentLayout = (LinearLayout)view.findViewById(R.id.share_dialog_contentLayout);
        this.sharedialogtextContent = (TextView)view.findViewById(R.id.share_dialog_textContent);
        this.sharedialogimageContent = (ImageView)view.findViewById(R.id.share_dialog_imageContent);
        this.sharedialogmoreuserlayout = (LinearLayout)view.findViewById(R.id.share_dialog_more_user_layout);
        this.sharedialogsingleuserlayout = (LinearLayout)view.findViewById(R.id.share_dialog_single_user_layout);
        this.sharedialogusername = (TextView)view.findViewById(R.id.share_dialog_user_name);
        this.sharedialogusericon = (CircleImageView)view.findViewById(R.id.share_dialog_user_icon);
        this.sharedialogtv = (TextView)view.findViewById(R.id.share_dialog_tv);
        this.alertDialog.setView(view);
        this.sharedialogsendbtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ShareDialog.this.isForward) {
                    ShareDialog.this.shareSessionListPresenter.onDialogRequestForwardSend(ShareDialog.this.list, ShareDialog.this.intent, ShareDialog.this.sharedialogmessageContent.getText().toString());
                } else {
                    ShareDialog.this.shareSessionListPresenter.onDialogRequestSend(ShareDialog.this.list, ShareDialog.this.intentBean, ShareDialog.this.sharedialogmessageContent.getText().toString());
                }
                ShareDialog.this.alertDialog.dismiss();
            }
        });
        this.sharedialogcancelbtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ShareDialog.this.shareSessionListPresenter.onDialogCancleSend();
                ShareDialog.this.alertDialog.dismiss();
            }
        });
    }

    public void showForwardDialog(ShareBean shareBean, Intent intent) {
        this.intent = intent;
        this.list.clear();
        this.list.add(shareBean);
        this.isForward = true;
        if (shareBean != null) {
            Glide.with((Context)this.context).load(shareBean.getAvatarUrl()).error(this.getAvaterImage(shareBean)).into((ImageView)this.sharedialogusericon);
            this.sharedialogusername.setText((CharSequence)shareBean.getDisplayName());
        }
        if (intent != null) {
            this.sharedialogcontentLayout.setVisibility(0);
            ArrayList fileList = (ArrayList)intent.getSerializableExtra("selectFile");
            if (ObjectUtil.collectionIsEmpty(fileList)) {
                int msgType = intent.getIntExtra("FORWARD_MSG_TYPE", 0);
                switch (msgType) {
                    case 0: 
                    case 14: {
                        String content = intent.getExtras().getString("android.intent.extra.TEXT");
                        SpannableString ss = EmotionUtils.formatNormalSpanContent(content, this.context, content.length());
                        this.sharedialogtextContent.setText((CharSequence)ss);
                        this.sharedialogtextContent.setVisibility(0);
                        break;
                    }
                    case 201: {
                        String assistant_content = intent.getExtras().getString("android.intent.extra.TEXT");
                        this.sharedialogtextContent.setText((CharSequence)this.getSystemStr(assistant_content));
                        this.sharedialogtextContent.setVisibility(0);
                        break;
                    }
                    case 3: {
                        FileInfo imageFileInfo = (FileInfo)intent.getExtras().getSerializable("FORWARD_FILE");
                        Glide.with((Context)this.context).load(imageFileInfo.getFilePath()).into(this.sharedialogimageContent);
                        this.sharedialogimageContent.setVisibility(0);
                        break;
                    }
                    case 2: {
                        FileInfo videoFileInfo = (FileInfo)intent.getExtras().getSerializable("FORWARD_FILE");
                        Glide.with((Context)this.context).load(videoFileInfo.getFilePath()).into(this.sharedialogimageContent);
                        this.sharedialogimageContent.setVisibility(0);
                        break;
                    }
                    case 4: {
                        this.sharedialogimageContent.setImageResource(R.mipmap.im_uikit_ic_others);
                        this.sharedialogimageContent.setVisibility(0);
                        break;
                    }
                    case 5: {
                        WebPageInfo webPageInfo = (WebPageInfo)intent.getSerializableExtra("FORWARD_WEB");
                        this.sharedialogtextContent.setText((CharSequence)webPageInfo.getTitle());
                        this.sharedialogtextContent.setVisibility(0);
                        this.sharedialogimageContent.setImageResource(R.mipmap.im_uikit_ic_others);
                        this.sharedialogimageContent.setVisibility(0);
                    }
                }
            }
        }
        if (!this.alertDialog.isShowing()) {
            this.alertDialog.show();
        }
    }

    private String getSystemStr(CharSequence json) {
        String str = "";
        if (!TextUtils.isEmpty((CharSequence)json)) {
            try {
                JSONObject jsonObject = new JSONObject(json.toString());
                if (jsonObject.has("title_type")) {
                    str = "[" + jsonObject.getString("title_type") + "] ";
                }
                if (jsonObject.has("title")) {
                    str = str + jsonObject.getString("title");
                }
                return str;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return str;
    }

    public void showSingleDialog(ShareBean shareBean, IntentBean intentBean) {
        this.isForward = false;
        this.list.clear();
        this.list.add(shareBean);
        this.intentBean = intentBean;
        if (shareBean != null) {
            Glide.with((Context)this.context).load(shareBean.getAvatarUrl()).error(this.getAvaterImage(shareBean)).into((ImageView)this.sharedialogusericon);
            this.sharedialogusername.setText((CharSequence)shareBean.getDisplayName());
        }
        if (intentBean != null) {
            if (!TextUtils.isEmpty((CharSequence)intentBean.getContent())) {
                SpannableString ss = EmotionUtils.formatNormalSpanContent(intentBean.getContent(), this.context, intentBean.getContent().length());
                this.sharedialogtextContent.setText((CharSequence)ss);
                this.sharedialogcontentLayout.setVisibility(0);
                this.sharedialogtextContent.setVisibility(0);
            }
            if (intentBean.getUriArrayList() != null && intentBean.getUriArrayList().size() == 1) {
                FileItem info = null;
                if (!TextUtils.isEmpty((CharSequence)intentBean.getType()) && intentBean.getType().startsWith("image/")) {
                    String path = IMFileUtils.getImagePath(this.context, intentBean.getUriArrayList().get(0));
                    if (!TextUtils.isEmpty((CharSequence)path)) {
                        info = new FileItem();
                        info.setFileType(2);
                        info.setFilePath(path);
                    }
                } else {
                    info = IMFileUtils.queryLocalFiles(this.context, Uri.parse((String)Uri.decode((String)intentBean.getUriArrayList().get(0))));
                }
                if (info != null) {
                    this.sharedialogcontentLayout.setVisibility(0);
                    this.sharedialogimageContent.setVisibility(0);
                    if (info.getFileType() == 3 || info.getFileType() == 2) {
                        Glide.with((Context)this.context).load(info.getFilePath()).diskCacheStrategy(DiskCacheStrategy.NONE).into(this.sharedialogimageContent);
                    }
                } else {
                    Toast.makeText((Context)this.context, (CharSequence)"\u62b1\u6b49\uff0c\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u683c\u5f0f", (int)0).show();
                    return;
                }
            }
        }
        if (!this.alertDialog.isShowing()) {
            this.alertDialog.show();
        }
    }

    public void showMulitForwardDialog(List<ShareBean> list, Intent intent) {
        this.isForward = true;
        this.list.clear();
        this.list.addAll(list);
        this.intent = intent;
        this.sharedialogsingleuserlayout.removeAllViews();
        RecyclerView recyclerView = this.showMulitList(list);
        this.sharedialogsingleuserlayout.addView((View)recyclerView);
        if (intent != null) {
            this.sharedialogcontentLayout.setVisibility(0);
            int msgType = intent.getIntExtra("FORWARD_MSG_TYPE", 0);
            switch (msgType) {
                case 0: 
                case 14: {
                    String content = intent.getExtras().getString("android.intent.extra.TEXT");
                    SpannableString ss = EmotionUtils.formatNormalSpanContent(content, this.context, content.length());
                    this.sharedialogtextContent.setText((CharSequence)ss);
                    this.sharedialogtextContent.setVisibility(0);
                    break;
                }
                case 201: {
                    String assistant_content = intent.getExtras().getString("android.intent.extra.TEXT");
                    this.sharedialogtextContent.setText((CharSequence)this.getSystemStr(assistant_content));
                    this.sharedialogtextContent.setVisibility(0);
                    break;
                }
                case 3: {
                    FileInfo imageFileInfo = (FileInfo)intent.getExtras().getSerializable("FORWARD_FILE");
                    Glide.with((Context)this.context).load(imageFileInfo.getFilePath()).into(this.sharedialogimageContent);
                    this.sharedialogimageContent.setVisibility(0);
                    break;
                }
                case 2: {
                    FileInfo videoFileInfo = (FileInfo)intent.getExtras().getSerializable("FORWARD_FILE");
                    Glide.with((Context)this.context).load(videoFileInfo.getFilePath()).into(this.sharedialogimageContent);
                    this.sharedialogimageContent.setVisibility(0);
                    break;
                }
                case 4: {
                    this.sharedialogimageContent.setImageResource(R.mipmap.im_uikit_ic_others);
                    this.sharedialogimageContent.setVisibility(0);
                    break;
                }
                case 5: {
                    WebPageInfo webPageInfo = (WebPageInfo)intent.getSerializableExtra("FORWARD_WEB");
                    this.sharedialogtextContent.setText((CharSequence)webPageInfo.getWebUri());
                    this.sharedialogtextContent.setVisibility(0);
                    this.sharedialogimageContent.setImageResource(R.mipmap.im_uikit_ic_others);
                    this.sharedialogimageContent.setVisibility(0);
                }
            }
        }
        if (!this.alertDialog.isShowing()) {
            this.alertDialog.show();
        }
    }

    public void showMulitDialog(List<ShareBean> list, IntentBean intentBean) {
        this.isForward = false;
        this.list.clear();
        this.list.addAll(list);
        this.intentBean = intentBean;
        this.sharedialogsingleuserlayout.removeAllViews();
        RecyclerView recyclerView = this.showMulitList(list);
        this.sharedialogsingleuserlayout.addView((View)recyclerView);
        if (intentBean != null) {
            if (!TextUtils.isEmpty((CharSequence)intentBean.getContent())) {
                SpannableString ss = EmotionUtils.formatNormalSpanContent(intentBean.getContent(), this.context, intentBean.getContent().length());
                this.sharedialogtextContent.setText((CharSequence)ss);
                this.sharedialogcontentLayout.setVisibility(0);
                this.sharedialogtextContent.setVisibility(0);
            }
            if (intentBean.getUriArrayList() != null && intentBean.getUriArrayList().size() == 1) {
                FileItem info = null;
                if (!TextUtils.isEmpty((CharSequence)intentBean.getType()) && intentBean.getType().startsWith("image/")) {
                    String path = IMFileUtils.getImagePath(this.context, intentBean.getUriArrayList().get(0));
                    if (!TextUtils.isEmpty((CharSequence)path)) {
                        info = new FileItem();
                        info.setFileType(2);
                        info.setFilePath(path);
                    }
                } else {
                    info = IMFileUtils.queryLocalFiles(this.context, Uri.parse((String)Uri.decode((String)intentBean.getUriArrayList().get(0))));
                }
                this.sharedialogimageContent.setVisibility(0);
                if (info != null) {
                    if (info.getFileType() == 3 || info.getFileType() == 2) {
                        Glide.with((Context)this.context).load(info.getFilePath()).diskCacheStrategy(DiskCacheStrategy.NONE).into(this.sharedialogimageContent);
                    }
                } else {
                    Toast.makeText((Context)this.context, (CharSequence)"\u62b1\u6b49\uff0c\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u683c\u5f0f", (int)0).show();
                    return;
                }
            }
        }
        if (!this.alertDialog.isShowing()) {
            this.alertDialog.show();
        }
    }

    private CircleImageView getCircleImageView() {
        return new CircleImageView(this.context);
    }

    private RecyclerView showMulitList(List<ShareBean> list) {
        RecyclerView recyclerView = new RecyclerView(this.context);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.context, 0, false);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        ListAdapter adapter = new ListAdapter(list);
        recyclerView.setAdapter((RecyclerView.Adapter)adapter);
        return recyclerView;
    }

    private int getAvaterImage(ShareBean shareBean) {
        if (shareBean.getType() == 1) {
            return R.mipmap.im_uikit_user_header_40dp;
        }
        return R.mipmap.im_uikit_group_avatar_40;
    }

    class ListHolder
    extends RecyclerView.ViewHolder {
        CircleImageView circleImageView;

        public ListHolder(View itemView) {
            super(itemView);
            this.circleImageView = (CircleImageView)itemView.findViewById(R.id.item_user_icon);
        }
    }

    private class ListAdapter
    extends RecyclerView.Adapter<ListHolder> {
        private List<ShareBean> list;

        public ListAdapter(List<ShareBean> list) {
            this.list = list;
        }

        public ListHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            View view = LayoutInflater.from((Context)ShareDialog.this.context).inflate(R.layout.im_uikit_share_item_user_icon_layout, parent, false);
            return new ListHolder(view);
        }

        public void onBindViewHolder(ListHolder holder, int position) {
            Glide.with((Context)ShareDialog.this.context).load(this.list.get(position).getAvatarUrl()).error(ShareDialog.this.getAvaterImage(this.list.get(position))).into((ImageView)holder.circleImageView);
        }

        public int getItemCount() {
            return this.list.size();
        }
    }
}

