/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.action.media;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.drawable.Drawable;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.view.ViewTreeObserver;
import com.xdja.im.lib.audio.player.AudioPlayerManager;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.action.media.MediaManger;
import com.xdja.im.uikit.view.TipsTextView;

public class ReceiverModeManger
implements SensorEventListener,
Application.ActivityLifecycleCallbacks {
    private Activity mActivity;
    private float voiceMode = -1.0f;
    private static final int DEFAULT_MODE_CODE = -1;
    private SensorManager mSensorManager;
    private Sensor mSensor;
    private TipsTextView mTipsTv;
    private BroadcastReceiver headsetPlugReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.HEADSET_PLUG".equals(action)) {
                int state = intent.getIntExtra("state", 0);
                if (state == 1) {
                    MediaManger.getInstance().setReceiverModeOn();
                } else if (state == 0) {
                    MediaManger.getInstance().setReceiverModeOn();
                }
            }
        }
    };

    public void init(Activity activity) {
        this.mActivity = activity;
        this.mSensorManager = (SensorManager)activity.getSystemService("sensor");
        this.mSensor = this.mSensorManager.getDefaultSensor(8);
        this.mActivity.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        this.mTipsTv = (TipsTextView)this.mActivity.findViewById(R.id.tv_tips_receiver);
        this.initAudioMode(this.mActivity);
    }

    @SuppressLint(value={"NewApi"})
    public void initAudioMode(Activity activity) {
        this.mActivity = activity;
        this.mActivity.getWindow().getDecorView().getViewTreeObserver().addOnWindowFocusChangeListener(new ViewTreeObserver.OnWindowFocusChangeListener(){

            public void onWindowFocusChanged(boolean hasFocus) {
            }
        });
    }

    private void registerSensor() {
        this.mSensorManager.registerListener((SensorEventListener)this, this.mSensor, 3);
    }

    private void unRegisterSensor() {
        this.mSensorManager.unregisterListener((SensorEventListener)this);
    }

    private void registerHeadset() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.HEADSET_PLUG");
        intentFilter.addAction("android.media.AUDIO_BECOMING_NOISY");
        this.mActivity.registerReceiver(this.headsetPlugReceiver, intentFilter);
    }

    private void unRegisterHeadset() {
        try {
            this.mActivity.unregisterReceiver(this.headsetPlugReceiver);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showReceiverTipsView() {
        this.mTipsTv.setText(R.string.im_uikit_tips_loudspeaker);
        Drawable leftDrawable = this.mActivity.getDrawable(R.mipmap.im_uikit_ic_tips_loudspeaker);
        if (leftDrawable != null) {
            leftDrawable.setBounds(0, 0, leftDrawable.getMinimumWidth(), leftDrawable.getMinimumHeight());
            this.mTipsTv.setCompoundDrawables(leftDrawable, null, null, null);
        }
        this.mTipsTv.showTips();
    }

    private boolean assetActivity(Activity activity) {
        return this.mActivity.getClass().getName().equals(activity.getClass().getName());
    }

    public void onSensorChanged(SensorEvent event) {
        if (this.voiceMode == event.values[0] && AudioPlayerManager.getInstance().isPlaying()) {
            return;
        }
        if (MediaManger.getInstance().isHeadsetOn()) {
            if (event.values[0] >= this.mSensor.getMaximumRange()) {
                MediaManger.getInstance().setReceiverMode(false);
                AudioPlayerManager.getInstance().startToRePlay();
                MediaManger.getInstance().onSensorChanged(false);
            }
            MediaManger.getInstance().wakeLockBrightRelease();
            return;
        }
        if (AudioPlayerManager.getInstance().isPlaying()) {
            if (event.values[0] >= this.mSensor.getMaximumRange()) {
                MediaManger.getInstance().wakeLockBrightRelease();
            } else {
                MediaManger.getInstance().wakeLockBrightAcquire();
            }
        } else {
            MediaManger.getInstance().wakeLockBrightRelease();
        }
        this.voiceMode = event.values[0];
        if (event.values[0] >= this.mSensor.getMaximumRange()) {
            MediaManger.getInstance().setReceiverMode(false);
            MediaManger.getInstance().onSensorChanged(false);
            AudioPlayerManager.getInstance().startToRePlay();
        } else {
            MediaManger.getInstance().setReceiverMode(true);
            MediaManger.getInstance().onSensorChanged(true);
            AudioPlayerManager.getInstance().startToRePlay();
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        if (this.assetActivity(activity)) {
            this.registerSensor();
            this.registerHeadset();
        }
    }

    public void onActivityPaused(Activity activity) {
        if (this.assetActivity(activity)) {
            this.unRegisterSensor();
            this.unRegisterHeadset();
        }
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        if (this.assetActivity(activity)) {
            MediaManger.getInstance().releaseWakeLock();
            this.mActivity.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
    }
}

