/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.assistant.adapter;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.ClipboardManager;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.common.utils.SystemHelper;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.event.IMProxyMessageEvent;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.core.model.message.file.NormalFileInfo;
import com.xdja.im.core.model.message.file.VideoFileInfo;
import com.xdja.im.core.model.message.file.VoiceFileInfo;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.core.repository.interf.ProxyRepository;
import com.xdja.im.lib.audio.manager.TelphoneState;
import com.xdja.im.lib.share.model.WebPageInfo;
import com.xdja.im.lib.share.util.ShareUtils;
import com.xdja.im.uikit.IntentParam;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.assistant.presenter.MessageAssistantPresenter;
import com.xdja.im.uikit.assistant.view.vu.MessageAssistantVu;
import com.xdja.im.uikit.newui.base.AssistantRecyclerViewBaseAdapter;
import com.xdja.im.uikit.newui.base.RecyclerViewHolder;
import com.xdja.im.uikit.newui.holder.ViewCustomReceMeetingHolder;
import com.xdja.im.uikit.newui.holder.ViewCustomSendMeetingHolder;
import com.xdja.im.uikit.newui.holder.ViewNotifyHolder;
import com.xdja.im.uikit.newui.holder.receive.ViewReceFileHolder;
import com.xdja.im.uikit.newui.holder.receive.ViewReceImageHolder;
import com.xdja.im.uikit.newui.holder.receive.ViewReceLocationHolder;
import com.xdja.im.uikit.newui.holder.receive.ViewReceTextHolder;
import com.xdja.im.uikit.newui.holder.receive.ViewReceVideoHolder;
import com.xdja.im.uikit.newui.holder.receive.ViewReceVoiceHolder;
import com.xdja.im.uikit.newui.holder.receive.ViewReceWebHolder;
import com.xdja.im.uikit.newui.holder.send.ViewDefaultSendHolder;
import com.xdja.im.uikit.newui.holder.send.ViewSendFileHolder;
import com.xdja.im.uikit.newui.holder.send.ViewSendImageHolder;
import com.xdja.im.uikit.newui.holder.send.ViewSendLocationHolder;
import com.xdja.im.uikit.newui.holder.send.ViewSendTextHolder;
import com.xdja.im.uikit.newui.holder.send.ViewSendVideoHolder;
import com.xdja.im.uikit.newui.holder.send.ViewSendVoiceHolder;
import com.xdja.im.uikit.newui.holder.send.ViewSendWebHolder;
import com.xdja.im.uikit.newui.presenter.ChatDetailAdapterPresenter;
import com.xdja.im.uikit.ui.activity.FileDownloadActivity;
import com.xdja.im.uikit.ui.activity.FilePreviewActivity;
import com.xdja.im.uikit.ui.dialog.CustomDialog;
import com.xdja.im.uikit.utils.SpUtils;
import com.xdja.im.uikit.utils.audio.AudioPlayerManagerProxy;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.util.ArrayList;
import java.util.List;
import rx.Subscriber;

public class MessageAssistantAdapter
extends AssistantRecyclerViewBaseAdapter<TalkMessageBean, ChatDetailAdapterPresenter>
implements ChatDetailAdapterPresenter {
    private ProxyRepository proxyRepository;
    private MessageAssistantPresenter chatDetailPresenter;
    private MessageAssistantVu chatDetailVu;

    public MessageAssistantAdapter(MessageAssistantPresenter chatDetailPresenter, MessageAssistantVu chatDetailVu, ProxyRepository proxyRepository, List<TalkMessageBean> list) {
        super(list);
        this.chatDetailVu = chatDetailVu;
        this.chatDetailPresenter = chatDetailPresenter;
        this.proxyRepository = proxyRepository;
    }

    @Override
    protected ChatDetailAdapterPresenter getPresenter() {
        return this;
    }

    @Override
    protected int getViewType(TalkMessageBean talkMessageBean) {
        int chatDetailType;
        if (talkMessageBean == null) {
            LogUtil.e("Item viewType data is null.");
            return 16;
        }
        switch (talkMessageBean.getMessageType()) {
            case 14: {
                if (talkMessageBean.isMine()) {
                    chatDetailType = 0;
                    break;
                }
                chatDetailType = 1;
                break;
            }
            case 0: {
                if (talkMessageBean.isMine()) {
                    chatDetailType = 0;
                    break;
                }
                chatDetailType = 1;
                break;
            }
            case 1: {
                if (talkMessageBean.isMine()) {
                    chatDetailType = 2;
                    break;
                }
                chatDetailType = 3;
                break;
            }
            case 3: {
                if (talkMessageBean.isMine()) {
                    chatDetailType = 4;
                    break;
                }
                chatDetailType = 5;
                break;
            }
            case 2: {
                if (talkMessageBean.isMine()) {
                    chatDetailType = 6;
                    break;
                }
                chatDetailType = 7;
                break;
            }
            case 4: {
                if (talkMessageBean.isMine()) {
                    chatDetailType = 8;
                    break;
                }
                chatDetailType = 9;
                break;
            }
            case 5: {
                if (talkMessageBean.isMine()) {
                    chatDetailType = 10;
                    break;
                }
                chatDetailType = 11;
                break;
            }
            case 6: {
                if (talkMessageBean.isMine()) {
                    chatDetailType = 12;
                    break;
                }
                chatDetailType = 13;
                break;
            }
            case 101: {
                chatDetailType = 14;
                break;
            }
            case 102: {
                if (talkMessageBean.isMine()) {
                    chatDetailType = 15;
                    break;
                }
                chatDetailType = 17;
                break;
            }
            case 201: {
                if (talkMessageBean.isMine()) {
                    chatDetailType = 18;
                    break;
                }
                chatDetailType = 18;
                break;
            }
            default: {
                chatDetailType = 16;
            }
        }
        return chatDetailType;
    }

    @Override
    protected RecyclerViewHolder getViewHolder(ViewGroup parent, int viewType, TalkMessageBean talkMessageBean) {
        switch (viewType) {
            case 0: {
                return new ViewSendTextHolder(this.getItemView(parent, R.layout.im_uikit_item_chat_send_text));
            }
            case 1: {
                return new ViewReceTextHolder(this.getItemView(parent, R.layout.im_uikit_item_chat_receive_text));
            }
            case 2: {
                return new ViewSendVoiceHolder(this.getItemView(parent, R.layout.im_uikit_item_chat_send_voice));
            }
            case 3: {
                return new ViewReceVoiceHolder(this.getItemView(parent, R.layout.im_uikit_item_chat_receive_voice));
            }
            case 4: {
                return new ViewSendImageHolder(this.getItemView(parent, R.layout.im_uikit_item_chat_send_image));
            }
            case 5: {
                return new ViewReceImageHolder(this.getItemView(parent, R.layout.im_uikit_item_chat_receive_image));
            }
            case 6: {
                return new ViewSendVideoHolder(this.getItemView(parent, R.layout.im_uikit_item_chat_send_video));
            }
            case 7: {
                return new ViewReceVideoHolder(this.getItemView(parent, R.layout.im_uikit_item_chat_receive_video));
            }
            case 8: {
                return new ViewSendFileHolder(this.getItemView(parent, R.layout.im_uikit_item_chat_send_file));
            }
            case 9: {
                return new ViewReceFileHolder(this.getItemView(parent, R.layout.im_uikit_item_chat_receive_file));
            }
            case 10: {
                return new ViewSendWebHolder(this.getItemView(parent, R.layout.im_uikit_item_chat_send_web));
            }
            case 11: {
                return new ViewReceWebHolder(this.getItemView(parent, R.layout.im_uikit_item_chat_rec_web));
            }
            case 12: {
                return new ViewSendLocationHolder(this.getItemView(parent, R.layout.im_uikit_item_chat_send_file));
            }
            case 13: {
                return new ViewReceLocationHolder(this.getItemView(parent, R.layout.im_uikit_item_chat_receive_voice));
            }
            case 14: {
                return new ViewNotifyHolder(this.getItemView(parent, R.layout.im_uikit_item_chat_notify));
            }
            case 15: {
                return new ViewCustomSendMeetingHolder(this.getItemView(parent, R.layout.im_uikit_item_chat_send_custom));
            }
            case 16: {
                return new ViewDefaultSendHolder(this.getItemView(parent, R.layout.im_uikit_item_chat_default));
            }
            case 17: {
                return new ViewCustomReceMeetingHolder(this.getItemView(parent, R.layout.im_uikit_item_chat_receive_custom));
            }
            case 18: {
                return this.getPresenter().getThirdViewHolderItem(this.getActivity(), talkMessageBean);
            }
        }
        return null;
    }

    @Override
    public Activity getActivity() {
        return this.chatDetailPresenter.getActivity();
    }

    @Override
    public void reSendMessage(final int position) {
        final TalkMessageBean messageBean = this.getTalkMessage(position);
        if (messageBean == null) {
            LogUtil.e("ERROR: reSend message, but bean is null." + position);
            return;
        }
        this.proxyRepository.reSendMessage(messageBean, new Subscriber<Integer>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("Resend message error, " + e.getMessage());
            }

            public void onNext(Integer messageId) {
                LogUtil.d("Resend message successfully, " + messageBean.toString());
                messageBean.setMessageState(1);
                MessageAssistantAdapter.this.list.set(position, messageBean);
                MessageAssistantAdapter.this.notifyItemChanged(position);
            }
        });
    }

    @Override
    public void scrollTo(int position) {
        this.chatDetailVu.smoothMoveToPosition(position);
    }

    @Override
    public void deleteItem(int position) {
        final TalkMessageBean messageBean = this.getTalkMessage(position);
        if (messageBean != null) {
            final long id2 = messageBean.getId();
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(id2);
            LogUtil.d("Start delete message " + id2);
            this.proxyRepository.deleteMessages(ids, new Subscriber<Integer>(){

                public void onCompleted() {
                }

                public void onError(Throwable e) {
                    LogUtil.e("Delete message error, " + e.getMessage());
                    CommonTool.showToast(R.string.im_uikit_delete_msg_failed);
                }

                public void onNext(Integer integer) {
                    LogUtil.d("Delete message id " + id2 + ", result:" + integer);
                    MessageAssistantAdapter.this.postDeleteMessageEvent(messageBean);
                }
            });
        }
    }

    private int postDeleteMessageEvent(TalkMessageBean talkMessageBean) {
        try {
            IMProxyMessageEvent.DeleteMessageEvent messageEvent = new IMProxyMessageEvent.DeleteMessageEvent();
            messageEvent.setMsgAccount(talkMessageBean.getFrom());
            messageEvent.setTalkMessageBean(talkMessageBean);
            BusProvider.getInstance().post(messageEvent);
            return 1;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public void recallMessage(int position) {
        final TalkMessageBean messageBean = this.getTalkMessage(position);
        if (messageBean == null) {
            LogUtil.e("ERROR: recall message, but bean is null." + position);
            return;
        }
        if (!SpUtils.getInstance().getBoolean("recall_msg")) {
            new CustomDialog((Context)this.getActivity(), new CustomDialog.OnCloseListener(){

                @Override
                public void onClick(Dialog dialog, boolean confirm) {
                    if (confirm) {
                        SpUtils.getInstance().saveBoolean("recall_msg", true);
                        MessageAssistantAdapter.this.recallMsg(messageBean);
                    }
                }
            }).setIfShowNegative(false).setDialogTitle(R.string.im_uikit_hint).setDialogContent(R.string.im_uikit_first_use_recall).setPositiveButton(R.string.im_uikit_ok_text).show();
        } else {
            this.recallMsg(messageBean);
        }
    }

    private void recallMsg(TalkMessageBean talkMessageBean) {
        this.proxyRepository.recallMessages(talkMessageBean.getId(), 0, new Subscriber<Integer>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("ERROR: recall message failed." + e.getMessage());
            }

            public void onNext(Integer integer) {
                LogUtil.d("message is already recalled.");
            }
        });
    }

    @Override
    public void copyMessage(int position) {
        TalkMessageBean messageBean = this.getTalkMessage(position);
        if (messageBean == null) {
            LogUtil.e("ERROR: copy message, but bean is null." + position);
            return;
        }
        if (messageBean.getMessageType() == 0 || messageBean.getMessageType() == 14) {
            ClipboardManager cmb = (ClipboardManager)this.getActivity().getSystemService("clipboard");
            if (!TextUtils.isEmpty((CharSequence)messageBean.getContent())) {
                cmb.setText((CharSequence)messageBean.getContent());
            }
        }
    }

    @Override
    public void forwardMessage(int position) {
        Intent intent = ShareUtils.buildForwardIntent(this.getActivity(), this.getTalkMessage(position));
        if (intent == null) {
            Toast.makeText((Context)this.getActivity(), (CharSequence)"\u8bf7\u5148\u6253\u5f00\u6216\u4e0b\u8f7d\u6587\u4ef6", (int)0).show();
        } else {
            this.getActivity().startActivity(intent);
        }
    }

    @Override
    public void playVoice(TalkMessageBean bean) {
        LogUtil.d("start play voice file.");
        if (!TelphoneState.getPhotoStateIsIdle(this.getActivity().getApplicationContext())) {
            CommonTool.showToast(R.string.im_uikit_phone_is_inCall);
            return;
        }
        VoiceFileInfo fileInfo = (VoiceFileInfo)bean.getFileInfo();
        if (fileInfo == null || TextUtils.isEmpty((CharSequence)fileInfo.getFilePath())) {
            LogUtil.e("ERROR: start to play voice, but file is null  or file not exist.");
            return;
        }
        if (bean.isMine() || !bean.isMine() && fileInfo.getFileState() == 2) {
            if (!FileUtils.isFileExists(fileInfo.getFilePath())) {
                CommonTool.showToast(R.string.im_uikit_file_not_exist);
                return;
            }
        } else {
            this.downLoadFile(fileInfo);
        }
        boolean isCurrentPlaying = AudioPlayerManagerProxy.isPlayingWithMessage(fileInfo);
        if (AudioPlayerManagerProxy.isPlaying()) {
            AudioPlayerManagerProxy.stopPlay();
        }
        if (isCurrentPlaying) {
            return;
        }
        AudioPlayerManagerProxy.startToPlay(fileInfo, bean.getId(), bean.getMessageState() < 4);
        if (!bean.isMine() && bean.getMessageState() < 4) {
            this.sendReadReceipt(bean);
        }
    }

    @Override
    public void previewVideo(TalkMessageBean dataSource) {
        LogUtil.d("start play video file.");
        VideoFileInfo fileInfo = (VideoFileInfo)dataSource.getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("ERROR: video file info is null error.");
            return;
        }
        if (!FileUtils.isFileExists(fileInfo.getFilePath())) {
            LogUtil.e("ERROR: file not exit.");
            return;
        }
        this.startPreviewActivity(fileInfo.getTalkMessageId());
        if (!dataSource.isMine() && dataSource.getMessageState() < 4) {
            this.sendReadReceipt(dataSource);
        }
    }

    private void startPreviewActivity(long msgId) {
        Intent intent = new Intent();
        intent.setClass((Context)this.chatDetailPresenter.getActivity(), FilePreviewActivity.class);
        intent.putExtra("talkerId", this.chatDetailPresenter.getTalkFlag());
        intent.putExtra("messageId", msgId);
    }

    @Override
    public void previewImage(TalkMessageBean dataSource) {
        LogUtil.d("Start preview image.");
        ImageFileInfo imageFile = (ImageFileInfo)dataSource.getFileInfo();
        if (imageFile == null) {
            LogUtil.e("ERROR: image file info is null error.");
            return;
        }
        if (!FileUtils.isFileExists(imageFile.getFilePath())) {
            LogUtil.e("ERROR: file not exit.");
            return;
        }
        this.startPreviewActivity(imageFile.getTalkMessageId());
    }

    @Override
    public void downLoadFile(FileInfo fileInfo) {
        if (fileInfo == null) {
            LogUtil.e("start load file, but file info is null error.");
            return;
        }
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
        fileInfos.add(fileInfo);
        this.proxyRepository.downloadFile(fileInfos, new Subscriber<Integer>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.d("Download image error." + e.getMessage());
            }

            public void onNext(Integer integer) {
                LogUtil.d("Start to loadNormalFile file.");
            }
        });
    }

    @Override
    public void loadNormalFile(TalkMessageBean dataSource) {
        LogUtil.d("start open file.");
        if (dataSource == null) {
            LogUtil.e("ERROR: start open file, but data source is null.");
            return;
        }
        NormalFileInfo normalFileInfo = (NormalFileInfo)dataSource.getFileInfo();
        Intent intent = new Intent((Context)this.getActivity(), FileDownloadActivity.class);
        intent.putExtra("messageId", dataSource.getId());
        intent.putExtra("fileTranslateSize", normalFileInfo.getTranslateSize());
    }

    @Override
    public void openNormalFile(TalkMessageBean dataSource) {
        NormalFileInfo fileInfo = (NormalFileInfo)dataSource.getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("ERROR: open file failed, file info is null.");
            return;
        }
        if (FileUtils.isFileExists(fileInfo.getFilePath())) {
            SystemHelper.openFile(this.getActivity(), fileInfo.getFilePath());
        } else {
            CommonTool.showToast(R.string.im_uikit_file_not_exist);
        }
    }

    @Override
    public void openSetting(String talkId, int talkType) {
        try {
            boolean result = IMUiKitProxyImpl.getInstance().openChatSettingCallback(talkId, talkType);
            if (!result) {
                IntentParam.startSettingActivity((Context)this.getActivity(), talkId, talkType);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void openUserInfo(String account) {
        try {
            IMUiKitProxyImpl.getInstance().openChatUserInfoCallback(account);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onLongClickAtUser(String groupId, String account) {
        IMUiKitProxyImpl.getInstance().getAccount(account, 1, new Subscriber<AccountBean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                e.printStackTrace();
            }

            public void onNext(AccountBean accountBean) {
            }
        });
    }

    @Override
    public boolean getVoiceMessageIsPlaying(FileInfo fileInfo) {
        return AudioPlayerManagerProxy.isPlayingWithMessage(fileInfo);
    }

    @Override
    public void sendReadReceipt(final TalkMessageBean talkMessageBean) {
        this.proxyRepository.changeMessageState(talkMessageBean, 4, new Subscriber<Integer>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.d("ERROR: Change message state error." + e.getMessage());
            }

            public void onNext(Integer integer) {
                if (integer != 0) {
                    LogUtil.e("Change message state failed.");
                    return;
                }
                LogUtil.d("Change message state success.");
                int length = MessageAssistantAdapter.this.list.size();
                for (int i = length - 1; i >= 0; --i) {
                    if (((TalkMessageBean)MessageAssistantAdapter.this.list.get(i)).getId() != talkMessageBean.getId()) continue;
                    talkMessageBean.setMessageState(4);
                    MessageAssistantAdapter.this.list.set(i, talkMessageBean);
                    MessageAssistantAdapter.this.notifyItemChanged(i);
                    break;
                }
            }
        });
    }

    @Override
    public void postDestroyAnimate(TalkMessageBean bean) {
        IMProxyMessageEvent.RefreshMessageEvent event = new IMProxyMessageEvent.RefreshMessageEvent();
        event.setMsgAccount(bean.getFrom());
        bean.setMessageState(5);
        event.setTalkMessageBean(bean);
        BusProvider.getInstance().post(event);
    }

    @Override
    public TalkMessageBean getTalkMessage(int position) {
        return (TalkMessageBean)this.getItemData(position);
    }

    @Override
    public void getTalkMessageEntity(long msgId, Subscriber<TalkMessageBean> subscriber) {
        this.proxyRepository.getTalkMessage(msgId, subscriber);
    }

    @Override
    public void getAccount(String account, int talkType, Subscriber<AccountBean> subscriber) {
        IMUiKitProxyImpl.getInstance().getAccount(account, talkType, subscriber);
    }

    @Override
    public void clickWebMessage(TalkMessageBean talkMessageBean) {
        if (talkMessageBean == null) {
            return;
        }
        WebPageInfo pInfo = talkMessageBean.getWebPageInfo();
        if (pInfo.getWebUri() != null) {
            Intent intent = new Intent();
            intent.setAction(this.getActivity().getPackageName() + "." + "android.intent.action.XDJA.VIEW");
            Uri uri = Uri.parse((String)pInfo.getWebUri());
            intent.setData(uri);
            this.getActivity().startActivity(intent);
        }
    }

    @Override
    public View getThirdTypeViewItem(Activity activity, TalkMessageBean talkMessageBean) {
        return IMUiKitProxyImpl.getInstance().getThirdTypeItem(activity, talkMessageBean);
    }

    @Override
    public RecyclerViewHolder getThirdViewHolderItem(Activity activity, TalkMessageBean talkMessageBean) {
        return IMUiKitProxyImpl.getInstance().getThirdViewHolderItem(activity, talkMessageBean);
    }

    public void startAnimation(String filePath, long messageId) {
        int position = this.getPositionWithId(messageId);
        if (position >= 0) {
            this.notifyItemChanged(position);
        }
    }

    public void stopAnimation(String filePath, long messageId) {
        int position = this.getPositionWithId(messageId);
        if (position >= 0) {
            this.notifyItemChanged(position);
        }
    }

    public void playNextAudio(String filePath, long messageId, boolean isNext) {
        LogUtil.d("start play next voice file.msgId:" + messageId);
        int position = this.getPositionWithId(messageId);
        if (position >= 0) {
            TalkMessageBean dataSource = (TalkMessageBean)this.getItemData(position);
            this.notifyItemChanged(position);
            if (dataSource.isMine() || !isNext) {
                return;
            }
            TalkMessageBean bean = this.findNextVoiceItem(position, messageId);
            if (bean != null && !bean.isMine()) {
                this.playVoice(bean);
            }
        }
    }

    private int getPositionWithId(long messageId) {
        TalkMessageBean bean = new TalkMessageBean();
        bean.setId(messageId);
        return this.list.indexOf(bean);
    }

    private TalkMessageBean findNextVoiceItem(int curPosition, long messageId) {
        TalkMessageBean bean = new TalkMessageBean();
        bean.setId(messageId);
        int size = this.list.size();
        if (curPosition >= 0) {
            for (int i = curPosition + 1; i < size; ++i) {
                FileInfo fileInfo;
                TalkMessageBean talkMessageBean = (TalkMessageBean)this.list.get(i);
                if (talkMessageBean.isMine() || (fileInfo = talkMessageBean.getFileInfo()) == null || fileInfo.getFileType() != 1) continue;
                if (talkMessageBean.getMessageState() >= 4 || fileInfo.getFileState() != 2) break;
                return talkMessageBean;
            }
        }
        return null;
    }
}

