/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.assistant.callback.impl;

import android.os.Bundle;
import com.xdja.im.common.cache.interf.UserCache;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.repository.interf.ProxyRepository;
import com.xdja.im.core.repository.interf.datasource.DiskDataStore;
import com.xdja.im.uikit.assistant.adapter.MessageAssistantAdapter;
import com.xdja.im.uikit.assistant.callback.MessageAssistantCallBack;
import com.xdja.im.uikit.assistant.presenter.MessageAssistantPresenter;
import com.xdja.im.uikit.assistant.view.vu.MessageAssistantVu;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import rx.Subscriber;

public class MessageAssistantCallBackImpl
implements MessageAssistantCallBack {
    private String mTalkId;
    private int mTalkType;
    private static final int PAGE_SIZE = 15;
    private List<TalkMessageBean> mMessageList = new ArrayList<TalkMessageBean>();
    private MessageAssistantAdapter mAdapter;
    private MessageAssistantVu vu;
    private MessageAssistantPresenter presenter;
    private ProxyRepository proxyRepository;
    private DiskDataStore diskDataStore;
    private UserCache userCache;

    @Inject
    public MessageAssistantCallBackImpl(ProxyRepository proxyRepository, DiskDataStore diskDataStore, UserCache userCache) {
        this.proxyRepository = proxyRepository;
        this.diskDataStore = diskDataStore;
        this.userCache = userCache;
    }

    @Override
    public void initChatPram(Bundle arguments, MessageAssistantVu vu, MessageAssistantPresenter presenter) {
        this.vu = vu;
        this.presenter = presenter;
        if (arguments != null) {
            this.mAdapter = null;
            this.mTalkId = arguments.getString("talkerId");
            this.mTalkType = arguments.getInt("talkType", 1);
        }
    }

    @Override
    public String getTalkId() {
        return this.mTalkId;
    }

    @Override
    public int getTalkType() {
        return this.mTalkType;
    }

    @Override
    public void downRefreshList() {
        long msgId = 0L;
        if (!this.mMessageList.isEmpty()) {
            msgId = this.mMessageList.get(0).getId();
        }
        LogUtil.d("do refresh, msgId :" + msgId);
        this.loadMessages(msgId);
    }

    @Override
    public MessageAssistantAdapter buildAdapter() {
        if (this.mAdapter == null) {
            this.mAdapter = new MessageAssistantAdapter(this.presenter, this.vu, this.proxyRepository, this.mMessageList);
        }
        return this.mAdapter;
    }

    @Override
    public void loadMessages(final long msgId) {
        LogUtil.d("Start load message msgId " + msgId);
        this.proxyRepository.getMessageList(this.mTalkId, this.mTalkType, msgId, 15, new Subscriber<List<TalkMessageBean>>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("load message error:" + e.getMessage());
                MessageAssistantCallBackImpl.this.mAdapter.notifyDataSetChanged();
            }

            public void onNext(List<TalkMessageBean> talkMessageList) {
                if (talkMessageList == null) {
                    return;
                }
                LogUtil.d(talkMessageList.toString());
                if (msgId == 0L) {
                    MessageAssistantCallBackImpl.this.mMessageList.clear();
                }
                if (talkMessageList.size() > 0) {
                    MessageAssistantCallBackImpl.this.mMessageList.addAll(0, talkMessageList);
                }
                MessageAssistantCallBackImpl.this.buildAdapter().notifyDataSetChanged();
                if (MessageAssistantCallBackImpl.this.vu.isRefreshing()) {
                    if (talkMessageList.size() > 0) {
                        MessageAssistantCallBackImpl.this.vu.setListSelection(talkMessageList.size() - 1);
                    }
                } else if (MessageAssistantCallBackImpl.this.mMessageList.size() > 0) {
                    MessageAssistantCallBackImpl.this.vu.setListSelection(MessageAssistantCallBackImpl.this.mMessageList.size() - 1);
                }
                if (MessageAssistantCallBackImpl.this.mMessageList.size() > 0) {
                    MessageAssistantCallBackImpl.this.vu.setListSelection(MessageAssistantCallBackImpl.this.mMessageList.size() - 1);
                }
            }
        });
    }
}

