/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.assistant.holder;

import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.newui.base.RecyclerViewHolder;
import com.xdja.im.uikit.newui.presenter.ChatDetailAdapterPresenter;
import com.xdja.im.uikit.utils.sys.TimeUtil;

public class AssistantHolder
extends RecyclerViewHolder<TalkMessageBean, ChatDetailAdapterPresenter> {
    View itemView;
    LinearLayout linearLayout;
    private LinearLayout.LayoutParams layoutParams;
    public static final long TIME_DIFFERENCE = 300000L;
    private TextView mTimeLineTv;

    public AssistantHolder(View itemView) {
        super(itemView);
        this.itemView = itemView;
        this.linearLayout = (LinearLayout)itemView.findViewById(R.id.view_custom_third_view_layout);
        this.mTimeLineTv = (TextView)this.findViewById(R.id.tv_timeLine);
        this.layoutParams = new LinearLayout.LayoutParams(-1, -2);
    }

    @Override
    public void bindData(int position, TalkMessageBean itemData) {
        super.bindData(position, itemData);
        if (itemData != null) {
            if (position == 0) {
                this.setTimeLineVisible(((TalkMessageBean)this.dataSource).getShowTime());
            } else {
                TalkMessageBean lastMessage = ((ChatDetailAdapterPresenter)this.getPresenter()).getTalkMessage(this.curPosition);
                if (lastMessage != null && ((TalkMessageBean)this.dataSource).getShowTime() - lastMessage.getShowTime() > 300000L) {
                    this.mTimeLineTv.setVisibility(0);
                    this.mTimeLineTv.setText((CharSequence)TimeUtil.convertChatTime(((TalkMessageBean)this.dataSource).getShowTime()));
                } else {
                    this.mTimeLineTv.setVisibility(8);
                }
            }
            if (itemData.getMessageState() < 4) {
                ((ChatDetailAdapterPresenter)this.getPresenter()).sendReadReceipt(itemData);
            }
        }
    }

    private void setTimeLineVisible(long time) {
        this.mTimeLineTv.setVisibility(0);
        this.mTimeLineTv.setText((CharSequence)TimeUtil.convertChatTime(time));
    }
}

