/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.assistant.view;

import android.content.Context;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.assistant.adapter.MessageAssistantAdapter;
import com.xdja.im.uikit.assistant.presenter.MessageAssistantPresenter;
import com.xdja.im.uikit.assistant.view.vu.MessageAssistantVu;
import com.xdja.im.uikit.base.ImFragmentSuperView;
import com.xdja.im.uikit.newui.base.SpaceItemDecoration;

public class MessageAssistantView
extends ImFragmentSuperView<MessageAssistantPresenter>
implements MessageAssistantVu {
    private RelativeLayout mContentLayout;
    private RecyclerView mRecyclerView;
    private LinearLayout networkStateLineaLayout;
    private TextView networkStateTv;
    private SwipeRefreshLayout swipeRefreshLayout;
    private boolean mShouldScroll;
    private boolean isScrollView;
    private int mToPosition;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_message_assistant_layout;
    }

    @Override
    protected int getToolbarType() {
        return 0;
    }

    @Override
    protected void injectView() {
        super.injectView();
        this.mContentLayout = (RelativeLayout)this.findViewById(R.id.content_layout);
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.lv_message_list);
        this.swipeRefreshLayout = (SwipeRefreshLayout)this.findViewById(R.id.swipe_container);
        this.networkStateLineaLayout = (LinearLayout)this.findViewById(R.id.network_state_view);
        this.networkStateTv = (TextView)this.findViewById(R.id.networkstate_tv);
    }

    @Override
    public void init(LayoutInflater inflater, ViewGroup container) {
        super.init(inflater, container);
        this.swipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                ((MessageAssistantPresenter)MessageAssistantView.this.getPresenter()).downRefreshList();
            }
        });
        this.initChatListListView();
        this.setNavigateCallback(new ImFragmentSuperView.onNavigateCallback(){

            @Override
            public void onBackClick() {
            }

            @Override
            public void onAddClick() {
                Toast.makeText((Context)MessageAssistantView.this.getActivity(), (CharSequence)"\u8bbe\u7f6e", (int)0).show();
            }
        });
    }

    private void initChatListListView() {
        this.mRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                if (MessageAssistantView.this.mShouldScroll) {
                    MessageAssistantView.this.mShouldScroll = false;
                    MessageAssistantView.this.smoothMoveToPosition(MessageAssistantView.this.mToPosition);
                }
            }

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (MessageAssistantView.this.isScrollView) {
                    MessageAssistantView.this.isScrollView = false;
                    int lastItem = MessageAssistantView.this.mRecyclerView.getAdapter().getItemCount() - 1;
                    MessageAssistantView.this.smoothMoveToPosition(lastItem);
                }
            }
        });
    }

    @Override
    public void setToolBarVisibility(int visibility) {
        this.supportActionBar(visibility == 0);
    }

    @Override
    public void setToolBarAddVisibility(int visibility) {
        this.setToolBarAddVisible(visibility == 0);
    }

    @Override
    public boolean isRefreshing() {
        return this.swipeRefreshLayout.isRefreshing();
    }

    @Override
    public void stopRefresh() {
        this.swipeRefreshLayout.setRefreshing(false);
    }

    @Override
    public void setTitle(String title) {
        if (this.isSupportActionBar()) {
            this.setToolBarTitle(title);
        }
    }

    @Override
    public void setAdapter(MessageAssistantAdapter adapter) {
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)((MessageAssistantPresenter)this.getPresenter()).getLinearLayoutManager());
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new SpaceItemDecoration(8));
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)adapter);
    }

    @Override
    public RecyclerView getRecyclerView() {
        return this.mRecyclerView;
    }

    @Override
    public void setListSelection(int selection) {
        this.smoothMoveToPosition(selection);
    }

    @Override
    public void smoothMoveToPosition(int index) {
        int firstItem = ((MessageAssistantPresenter)this.getPresenter()).getLinearLayoutManager().findFirstVisibleItemPosition();
        int lastItem = ((MessageAssistantPresenter)this.getPresenter()).getLinearLayoutManager().findLastVisibleItemPosition();
        if (index <= firstItem) {
            this.mRecyclerView.smoothScrollToPosition(index);
        } else if (index <= lastItem) {
            int movePosition = index - firstItem;
            if (movePosition >= 0 && movePosition < this.mRecyclerView.getChildCount()) {
                int top = this.mRecyclerView.getChildAt(movePosition).getTop();
                this.mRecyclerView.smoothScrollBy(0, top);
            }
        } else {
            this.mRecyclerView.smoothScrollToPosition(index);
            this.mToPosition = index;
            this.mShouldScroll = true;
        }
    }
}

