/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.newui.base;

import android.app.Activity;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.utils.DataCache;
import com.xdja.im.core.utils.ToolUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.action.options.ImOption;
import com.xdja.im.uikit.newui.base.RecyclerViewHolder;
import com.xdja.im.uikit.newui.presenter.ChatDetailAdapterPresenter;
import com.xdja.im.uikit.ui.dialog.BaseListDialog;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.utils.sys.TimeUtil;
import com.xdja.im.uikit.view.CircleImageView;
import java.util.ArrayList;
import java.util.List;
import rx.Subscriber;

public class BaseChatHolder
extends RecyclerViewHolder<TalkMessageBean, ChatDetailAdapterPresenter> {
    public static final long TIME_DIFFERENCE = 300000L;
    private CircleImageView mUserHeader;
    protected TextView mUserName;
    private TextView mTimeLineTv;
    protected BaseListDialog mPopDialog;
    protected List<ImOption> mImOptions = new ArrayList<ImOption>();

    public BaseChatHolder(View itemView) {
        super(itemView);
        this.mUserHeader = (CircleImageView)((Object)this.findViewById(R.id.img_user_icon));
        this.mTimeLineTv = (TextView)this.findViewById(R.id.tv_timeLine);
        this.mPopDialog = new BaseListDialog(itemView.getContext()){

            @Override
            public List<ImOption> getOptions() {
                return BaseChatHolder.this.buildImOptions();
            }
        };
        this.mUserHeader.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String account = ((TalkMessageBean)BaseChatHolder.this.dataSource).getFrom();
                if (TextUtils.isEmpty((CharSequence)account)) {
                    LogUtil.e("ERROR: User account is null.");
                    return;
                }
                LogUtil.d("Start open user setting.(" + account + ")");
                ((ChatDetailAdapterPresenter)BaseChatHolder.this.getPresenter()).openUserInfo(account);
            }
        });
        this.mUserHeader.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (((TalkMessageBean)BaseChatHolder.this.dataSource).isGroupMsg() && !((TalkMessageBean)BaseChatHolder.this.dataSource).isMine()) {
                    ((ChatDetailAdapterPresenter)BaseChatHolder.this.getPresenter()).onLongClickAtUser(((TalkMessageBean)BaseChatHolder.this.dataSource).getTo(), ((TalkMessageBean)BaseChatHolder.this.dataSource).getFrom());
                    return true;
                }
                return false;
            }
        });
    }

    public Activity getActivity() {
        return ((ChatDetailAdapterPresenter)this.getPresenter()).getActivity();
    }

    @Override
    public void bindData(int position, TalkMessageBean dataSource) {
        super.bindData(position, dataSource);
        if (position == 0) {
            this.setTimeLineVisible(dataSource.getShowTime());
        } else {
            TalkMessageBean lastMessage = ((ChatDetailAdapterPresenter)this.getPresenter()).getTalkMessage(this.curPosition);
            if (lastMessage != null && dataSource.getShowTime() - lastMessage.getShowTime() > 300000L) {
                this.mTimeLineTv.setVisibility(0);
                this.mTimeLineTv.setText((CharSequence)TimeUtil.convertChatTime(dataSource.getShowTime()));
            } else {
                this.mTimeLineTv.setVisibility(8);
            }
        }
        if (dataSource.getMessageType() == 101) {
            return;
        }
        try {
            this.loadUserData();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setTimeLineVisible(long time) {
        this.mTimeLineTv.setVisibility(0);
        this.mTimeLineTv.setText((CharSequence)TimeUtil.convertChatTime(time));
    }

    protected int getNormalTextColor() {
        return -16777216;
    }

    protected int getLimitTextColor() {
        return -3355444;
    }

    private List<ImOption> buildImOptions() {
        this.mImOptions.add(new ImOption(1, this.getStringRes(R.string.im_uikit_chat_option_delete)));
        this.mImOptions.add(new ImOption(2, this.getStringRes(R.string.im_uikit_chat_option_copy)));
        this.mImOptions.add(new ImOption(3, this.getStringRes(R.string.im_uikit_chat_option_recall)));
        this.mImOptions.add(new ImOption(4, this.getStringRes(R.string.im_uikit_chat_option_resend)));
        this.mImOptions.add(new ImOption(5, this.getStringRes(R.string.im_uikit_chat_option_forward)));
        return this.mImOptions;
    }

    protected void loadUserData() {
        final String account = ((TalkMessageBean)this.dataSource).getFrom();
        if (TextUtils.isEmpty((CharSequence)account)) {
            return;
        }
        String sessionFlag = ToolUtils.getSessionTag(account, 1);
        AccountBean accountBean = (AccountBean)DataCache.getInstance().get(sessionFlag);
        if (accountBean != null) {
            this.mUserHeader.loadImage(accountBean.getAvatarUrl(), true, R.mipmap.im_uikit_user_header_40dp);
            if (this.mUserName != null && ((TalkMessageBean)this.dataSource).isGroupMsg() && !((TalkMessageBean)this.dataSource).isMine()) {
                this.mUserName.setText((CharSequence)accountBean.getDisplayName());
            }
            return;
        }
        ((ChatDetailAdapterPresenter)this.getPresenter()).getAccount(account, 1, new Subscriber<AccountBean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.w("ERROR: get account failed." + account);
            }

            public void onNext(AccountBean accountBean) {
                if (accountBean == null) {
                    return;
                }
                BaseChatHolder.this.mUserHeader.loadImage(accountBean.getAvatarUrl(), true, R.mipmap.im_uikit_user_header_40dp);
                if (BaseChatHolder.this.mUserName != null && ((TalkMessageBean)BaseChatHolder.this.dataSource).isGroupMsg() && !((TalkMessageBean)BaseChatHolder.this.dataSource).isMine()) {
                    BaseChatHolder.this.mUserName.setText((CharSequence)accountBean.getDisplayName());
                }
            }
        });
    }
}

